/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.tree.ExpressionNode;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.tree.TextNode;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeferredValueUtils {
    private static final Pattern TEMPLATE_TAG_PATTERN = Pattern.compile("(\\w+(?:\\.\\w+)*)");

    public static void deferVariables(String[] varTokens, Map<String, Object> context) {
        for (String varToken : varTokens) {
            String key = varToken.trim();
            Object originalValue = context.get(key);
            if (originalValue != null) {
                if (originalValue instanceof DeferredValue) {
                    context.put(key, originalValue);
                    continue;
                }
                context.put(key, DeferredValue.instance(originalValue));
                continue;
            }
            context.put(key, DeferredValue.instance());
        }
    }

    public static Set<String> findAndMarkDeferredProperties(Context context, Node newNode) {
        String templateSource = DeferredValueUtils.rebuildTemplateForNodes(newNode);
        Set<String> deferredProps = DeferredValueUtils.getPropertiesUsedInDeferredNodes(context, templateSource);
        Set<String> setProps = DeferredValueUtils.getPropertiesSetInDeferredNodes(templateSource);
        DeferredValueUtils.markDeferredProperties(context, Sets.union(deferredProps, setProps));
        return deferredProps;
    }

    public static Set<String> getPropertiesSetInDeferredNodes(String templateSource) {
        return DeferredValueUtils.findSetProperties(templateSource);
    }

    public static Set<DeferredTag> getDeferredTagsRecursively(Node deferredNode) {
        return DeferredValueUtils.getDeferredTags(deferredNode, 0);
    }

    public static Set<String> getPropertiesUsedInDeferredNodes(Context context, String templateSource) {
        return DeferredValueUtils.getPropertiesUsedInDeferredNodes(context, templateSource, true);
    }

    public static Set<String> getPropertiesUsedInDeferredNodes(Context context, String templateSource, boolean onlyAlreadyInContext) {
        Stream<String> propertiesUsed = DeferredValueUtils.findUsedProperties(templateSource).stream().map(prop -> prop.split("\\.", 2)[0]);
        if (onlyAlreadyInContext) {
            propertiesUsed = propertiesUsed.filter(context::containsKey);
        }
        return propertiesUsed.collect(Collectors.toSet());
    }

    private static void markDeferredProperties(Context context, Set<String> props) {
        props.stream().filter(prop -> !(context.get(prop) instanceof DeferredValue)).filter(prop -> !context.getMetaContextVariables().contains(prop)).forEach(prop -> {
            Object value = context.get(prop);
            if (value != null) {
                context.put(prop, DeferredValue.instance(value));
            } else {
                context.put(prop, DeferredValue.instance());
            }
        });
    }

    private static Set<DeferredTag> getDeferredTags(Node node, int depth) {
        int maxRenderDepth;
        Set deferredTags = DeferredValueUtils.getDeferredTags(node).orElse(new HashSet());
        int n = maxRenderDepth = JinjavaInterpreter.getCurrent() == null ? 3 : JinjavaInterpreter.getCurrent().getConfig().getMaxRenderDepth();
        if (depth > maxRenderDepth) {
            return deferredTags;
        }
        node.getChildren().forEach(child -> deferredTags.addAll(DeferredValueUtils.getDeferredTags(child, depth + 1)));
        return deferredTags;
    }

    private static String rebuildTemplateForNodes(Node node) {
        StringJoiner joiner = new StringJoiner(" ");
        DeferredValueUtils.getDeferredTagsRecursively(node).stream().map(DeferredTag::getTag).forEach(joiner::add);
        return joiner.toString();
    }

    private static Set<String> findUsedProperties(String templateSource) {
        Matcher matcher = TEMPLATE_TAG_PATTERN.matcher(templateSource);
        HashSet<String> tags = Sets.newHashSet();
        while (matcher.find()) {
            tags.add(matcher.group(1));
        }
        return tags;
    }

    private static Set<String> findSetProperties(String templateSource) {
        String[] lines;
        HashSet<String> tags = Sets.newHashSet();
        for (String line : lines = templateSource.split("\n")) {
            if (!(line = line.trim()).contains("set ")) continue;
            tags.addAll(DeferredValueUtils.findUsedProperties(line));
        }
        return tags;
    }

    private static Optional<Set<DeferredTag>> getDeferredTags(Node deferredNode) {
        TagNode tagNode;
        if (deferredNode instanceof TextNode || deferredNode.getMaster() == null) {
            return Optional.empty();
        }
        String nodeImage = deferredNode.getMaster().getImage();
        if (Strings.nullToEmpty(nodeImage).trim().isEmpty()) {
            return Optional.empty();
        }
        HashSet<DeferredTag> deferredTags = new HashSet<DeferredTag>();
        deferredTags.add(new DeferredTag().setTag(nodeImage).setNormalizedTag(DeferredValueUtils.getNormalizedTag(deferredNode)));
        if (deferredNode instanceof TagNode && (tagNode = (TagNode)deferredNode).getEndName() != null) {
            String endTag = tagNode.reconstructEnd();
            deferredTags.add(new DeferredTag().setTag(endTag).setNormalizedTag(endTag));
        }
        return Optional.of(deferredTags);
    }

    private static String getNormalizedTag(Node node) {
        if (node instanceof ExpressionNode) {
            return node.toString().replaceAll("\\s+", "");
        }
        return node.getMaster().getImage();
    }

    private static class DeferredTag {
        String tag;
        String normalizedTag;

        private DeferredTag() {
        }

        public String getTag() {
            return this.tag;
        }

        public DeferredTag setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public DeferredTag setNormalizedTag(String normalizedTag) {
            this.normalizedTag = normalizedTag;
            return this;
        }
    }
}

