/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.tree.parse;

import com.google.common.collect.AbstractIterator;
import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.tree.parse.Token;
import com.hubspot.jinjava.tree.parse.TokenScannerSymbols;
import com.hubspot.jinjava.tree.parse.UnclosedToken;
import com.hubspot.jinjava.util.CharArrayUtils;

public class TokenScanner
extends AbstractIterator<Token> {
    private final JinjavaConfig config;
    private final char[] is;
    private final int length;
    private int currPost = 0;
    private int tokenStart = 0;
    private int tokenLength = 0;
    private int tokenKind = -1;
    private int lastStart = 0;
    private int inComment = 0;
    private int inRaw = 0;
    private int inBlock = 0;
    private char inQuote = '\u0000';
    private int currLine = 1;
    private int lastNewlinePos = 0;
    private TokenScannerSymbols symbols;

    public TokenScanner(String input, JinjavaConfig config) {
        this.config = config;
        this.is = input.toCharArray();
        this.length = this.is.length;
        this.currPost = 0;
        this.tokenStart = 0;
        this.tokenKind = -1;
        this.lastStart = 0;
        this.inComment = 0;
        this.inRaw = 0;
        this.inBlock = 0;
        this.inQuote = '\u0000';
        this.currLine = 1;
        this.lastNewlinePos = 0;
        this.symbols = config.getTokenScannerSymbols();
    }

    private Token getNextToken() {
        while (this.currPost < this.length) {
            char c = this.is[this.currPost++];
            if (this.currPost == this.length) {
                return this.getEndToken();
            }
            if (this.inBlock > 0) {
                if (c == '\\') {
                    ++this.currPost;
                    continue;
                }
                if (this.inQuote != '\u0000') {
                    if (this.inQuote != c) continue;
                    this.inQuote = '\u0000';
                    continue;
                }
                if (c == '\'' || c == '\"') {
                    this.inQuote = c;
                    continue;
                }
            }
            if (c == this.symbols.getPrefix()) {
                if (this.currPost < this.length) {
                    c = this.is[this.currPost];
                    boolean startTokenFound = true;
                    if (this.config.getLegacyOverrides().isWhitespaceRequiredWithinTokens()) {
                        boolean nextCharIsWhitespace;
                        boolean hasNextChar = this.currPost + 1 < this.length;
                        startTokenFound = nextCharIsWhitespace = hasNextChar && ' ' == this.is[this.currPost + 1];
                    }
                    if (!startTokenFound) continue;
                    if (c == this.symbols.getNote()) {
                        if (this.inComment == 1 || this.inRaw == 1) continue;
                        this.inComment = 1;
                        this.tokenLength = this.currPost - this.tokenStart - 1;
                        if (this.tokenLength > 0) {
                            this.lastStart = this.tokenStart;
                            this.tokenStart = --this.currPost;
                            this.tokenKind = c;
                            this.inComment = 0;
                            return this.newToken(this.symbols.getFixed());
                        }
                        this.tokenKind = c;
                        continue;
                    }
                    if (c != this.symbols.getTag() && c != this.symbols.getExprStart() || this.inComment > 0 || this.inRaw > 0 && (c == this.symbols.getExprStart() || !this.isEndRaw()) || !this.matchToken(c) && this.tokenKind > 0 || this.inBlock++ > 0) continue;
                    this.tokenLength = this.currPost - this.tokenStart - 1;
                    if (this.tokenLength > 0) {
                        this.lastStart = this.tokenStart;
                        this.tokenStart = --this.currPost;
                        this.tokenKind = c;
                        return this.newToken(this.symbols.getFixed());
                    }
                    this.tokenKind = c;
                    continue;
                }
                return this.getEndToken();
            }
            if (c == this.symbols.getTag() || c == this.symbols.getExprEnd()) {
                if (this.inComment > 0 || !this.matchToken(c)) continue;
                if (this.currPost < this.length) {
                    c = this.is[this.currPost];
                    if (c != this.symbols.getPostfix()) continue;
                    this.inBlock = 0;
                    this.tokenLength = this.currPost - this.tokenStart + 1;
                    if (this.tokenLength <= 0) continue;
                    this.lastStart = this.tokenStart;
                    this.tokenStart = ++this.currPost;
                    int kind = this.tokenKind;
                    this.tokenKind = this.symbols.getFixed();
                    return this.newToken(kind);
                }
                return this.getEndToken();
            }
            if (c == this.symbols.getNote()) {
                if (!this.matchToken(c)) continue;
                if (this.currPost < this.length) {
                    c = this.is[this.currPost];
                    if (c != this.symbols.getPostfix()) continue;
                    this.inComment = 0;
                    this.tokenLength = this.currPost - this.tokenStart + 1;
                    if (this.tokenLength <= 0) continue;
                    this.lastStart = this.tokenStart;
                    this.tokenStart = ++this.currPost;
                    this.tokenKind = this.symbols.getFixed();
                    return this.newToken(this.symbols.getNote());
                }
                return this.getEndToken();
            }
            if (c == this.symbols.getNewline()) {
                ++this.currLine;
                this.lastNewlinePos = this.currPost;
                if (this.inComment > 0 || this.inBlock > 0) continue;
                this.tokenKind = this.symbols.getFixed();
                continue;
            }
            if (this.tokenKind != -1) continue;
            this.tokenKind = this.symbols.getFixed();
        }
        return null;
    }

    private boolean isEndRaw() {
        int pos = this.currPost + 1;
        while (pos < this.length && Character.isWhitespace(this.is[pos++])) {
        }
        if (pos + 5 >= this.length) {
            return false;
        }
        return CharArrayUtils.charArrayRegionMatches(this.is, pos - 1, "endraw");
    }

    private Token getEndToken() {
        this.tokenLength = this.currPost - this.tokenStart;
        int type = this.symbols.getFixed();
        if (this.inComment > 0) {
            type = this.symbols.getNote();
        } else if (this.inBlock > 0) {
            return new UnclosedToken(String.valueOf(this.is, this.tokenStart, this.tokenLength), this.currLine, this.tokenStart - this.lastNewlinePos + 1, this.symbols);
        }
        return Token.newToken(type, this.symbols, String.valueOf(this.is, this.tokenStart, this.tokenLength), this.currLine, this.tokenStart - this.lastNewlinePos + 1);
    }

    private Token newToken(int kind) {
        Token t = Token.newToken(kind, this.symbols, String.valueOf(this.is, this.lastStart, this.tokenLength), this.currLine, this.lastStart - this.lastNewlinePos + 1);
        if (t instanceof TagToken) {
            TagToken tt;
            if (this.config.isTrimBlocks() && this.currPost < this.length && this.is[this.currPost] == '\n') {
                this.lastNewlinePos = this.currPost++;
                ++this.tokenStart;
            }
            if ("raw".equals((tt = (TagToken)t).getTagName())) {
                this.inRaw = 1;
                return tt;
            }
            if ("endraw".equals(tt.getTagName())) {
                this.inRaw = 0;
                return tt;
            }
        }
        if (this.inRaw > 0 && t.getType() != this.symbols.getFixed()) {
            return Token.newToken(this.symbols.getFixed(), this.symbols, t.image, this.currLine, this.tokenStart);
        }
        return t;
    }

    private boolean matchToken(char kind) {
        if (kind == this.symbols.getExprStart()) {
            return this.tokenKind == this.symbols.getExprEnd();
        }
        if (kind == this.symbols.getExprEnd()) {
            return this.tokenKind == this.symbols.getExprStart();
        }
        return kind == this.tokenKind;
    }

    @Override
    protected Token computeNext() {
        Token t = this.getNextToken();
        if (t == null) {
            return (Token)this.endOfData();
        }
        return t;
    }
}

