/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.tree.parse;

import com.hubspot.jinjava.tree.parse.Token;
import com.hubspot.jinjava.tree.parse.TokenScannerSymbols;
import org.apache.commons.lang3.StringUtils;

public class TextToken
extends Token {
    public TextToken(String image, int lineNumber, int startPosition, TokenScannerSymbols symbols) {
        super(image, lineNumber, startPosition, symbols);
    }

    public void mergeImageAndContent(TextToken otherToken) {
        String thisOutput = this.output();
        String otherTokenOutput = otherToken.output();
        this.content = this.image = thisOutput + otherTokenOutput;
    }

    @Override
    public int getType() {
        return this.getSymbols().getFixed();
    }

    @Override
    protected void parse() {
        this.content = this.image;
    }

    public boolean isBlank() {
        return StringUtils.isBlank(this.content);
    }

    public String trim() {
        return this.content.trim();
    }

    public String output() {
        if (this.isLeftTrim() && this.isRightTrim()) {
            return this.trim();
        }
        if (this.isLeftTrim()) {
            return StringUtils.stripStart(this.content, null);
        }
        if (this.isRightTrim()) {
            return StringUtils.stripEnd(this.content, null);
        }
        return this.content;
    }

    @Override
    public String toString() {
        if (this.isBlank()) {
            return "{~ ~}";
        }
        return "{~ " + this.content + " ~}";
    }
}

