/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.objects.serialization.PyishCharacterEscapes;
import com.hubspot.jinjava.objects.serialization.PyishPrettyPrinter;
import com.hubspot.jinjava.objects.serialization.PyishSerializable;
import java.io.IOException;
import java.util.Objects;

public class PyishSerializer
extends JsonSerializer<Object> {
    public static final PyishSerializer INSTANCE = new PyishSerializer();

    private PyishSerializer() {
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.setPrettyPrinter(PyishPrettyPrinter.INSTANCE);
        jsonGenerator.setCharacterEscapes(PyishCharacterEscapes.INSTANCE);
        Object wrappedObject = JinjavaInterpreter.getCurrentMaybe().map(interpreter -> interpreter.wrap(object)).orElse(object);
        if (wrappedObject instanceof PyishSerializable) {
            ((PyishSerializable)wrappedObject).writePyishSelf(jsonGenerator, serializerProvider);
        } else if (wrappedObject instanceof Boolean) {
            jsonGenerator.writeBoolean((Boolean)wrappedObject);
        } else if (wrappedObject instanceof Number) {
            jsonGenerator.writeNumber(wrappedObject.toString());
        } else if (wrappedObject instanceof String) {
            jsonGenerator.writeString((String)wrappedObject);
        } else {
            String string = Objects.toString(wrappedObject, "");
            try {
                double number = Double.parseDouble(string);
                if (string.equals(String.valueOf(number)) || string.equals(String.valueOf((long)number))) {
                    jsonGenerator.writeNumber(string);
                } else {
                    jsonGenerator.writeString(string);
                }
            }
            catch (NumberFormatException e) {
                if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
                    jsonGenerator.writeBoolean(Boolean.parseBoolean(string));
                }
                jsonGenerator.writeString(string);
            }
        }
    }
}

