/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.serialization;

import com.hubspot.jinjava.objects.serialization.LengthLimitingJsonProcessingException;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicInteger;

public class LengthLimitingWriter
extends Writer {
    private final CharArrayWriter charArrayWriter;
    private final AtomicInteger remainingLength;
    private final int startingLength;

    public LengthLimitingWriter(CharArrayWriter charArrayWriter, AtomicInteger remainingLength) {
        this.charArrayWriter = charArrayWriter;
        this.remainingLength = remainingLength;
        this.startingLength = remainingLength.get();
    }

    @Override
    public void write(int c) throws LengthLimitingJsonProcessingException {
        this.checkMaxSize(1);
        this.charArrayWriter.write(c);
    }

    @Override
    public void write(char[] c, int off, int len) throws LengthLimitingJsonProcessingException {
        this.checkMaxSize(len);
        this.charArrayWriter.write(c, off, len);
    }

    @Override
    public void write(String str, int off, int len) throws LengthLimitingJsonProcessingException {
        this.checkMaxSize(len);
        this.charArrayWriter.write(str, off, len);
    }

    private void checkMaxSize(int extra) throws LengthLimitingJsonProcessingException {
        if (this.remainingLength.addAndGet(extra * -1) < 0) {
            throw new LengthLimitingJsonProcessingException(this.startingLength, this.charArrayWriter.size() + extra);
        }
    }

    public String toString() {
        return this.charArrayWriter.toString();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

