/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.objects.collections;

import com.hubspot.jinjava.interpret.CollectionTooBigException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.objects.collections.PyList;
import java.util.Collection;
import java.util.List;

public class SizeLimitingPyList
extends PyList {
    private int maxSize;
    private boolean hasWarned;

    public SizeLimitingPyList(List<Object> list, int maxSize) {
        super(list);
        if (list == null) {
            throw new IllegalArgumentException("list is null");
        }
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be >= 1");
        }
        this.maxSize = maxSize;
        if (list.size() > maxSize) {
            throw new CollectionTooBigException(list.size(), maxSize);
        }
    }

    @Override
    public boolean add(Object element) {
        this.checkSize(this.size() + 1);
        return super.add(element);
    }

    @Override
    public void add(int index, Object element) {
        this.checkSize(this.size() + 1);
        super.add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<?> elements) {
        if (elements == null || elements.isEmpty()) {
            return false;
        }
        this.checkSize(this.size() + elements.size());
        return super.addAll(index, elements);
    }

    @Override
    public boolean addAll(Collection<?> elements) {
        if (elements == null || elements.isEmpty()) {
            return false;
        }
        this.checkSize(this.size() + elements.size());
        return super.addAll(elements);
    }

    private void checkSize(int newSize) {
        if (newSize > this.maxSize) {
            throw new CollectionTooBigException(newSize, this.maxSize);
        }
        if (!this.hasWarned && (double)newSize >= (double)this.maxSize * 0.9) {
            this.hasWarned = true;
            JinjavaInterpreter.getCurrent().addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.COLLECTION_TOO_BIG, String.format("List is at 90%% of max size (%d of %d)", newSize, this.maxSize), null, -1, -1, new CollectionTooBigException(newSize, this.maxSize)));
        }
    }
}

