/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager.importing;

import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import com.hubspot.jinjava.lib.tag.eager.DeferredToken;
import com.hubspot.jinjava.lib.tag.eager.importing.EagerImportingStrategy;
import com.hubspot.jinjava.lib.tag.eager.importing.ImportingData;
import com.hubspot.jinjava.objects.collections.PyMap;
import com.hubspot.jinjava.objects.serialization.PyishObjectMapper;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import com.hubspot.jinjava.util.PrefixToPreserveState;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Stream;

public class AliasedEagerImportingStrategy
implements EagerImportingStrategy {
    private static final String TEMPORARY_IMPORT_ALIAS_PREFIX = "__temp_import_alias_";
    private static final String TEMPORARY_IMPORT_ALIAS_FORMAT = "__temp_import_alias_%d__";
    private final ImportingData importingData;
    private final String currentImportAlias;
    private final String fullImportAlias;

    public static Optional<String> getTemporaryImportAlias(Context context) {
        return context.getImportResourceAlias().map(AliasedEagerImportingStrategy::getTemporaryImportAlias);
    }

    public static boolean isTemporaryImportAlias(String varName) {
        return varName.startsWith(TEMPORARY_IMPORT_ALIAS_PREFIX);
    }

    private static String getTemporaryImportAlias(String fullAlias) {
        return String.format(TEMPORARY_IMPORT_ALIAS_FORMAT, Math.abs(Objects.hashCode(fullAlias)));
    }

    public AliasedEagerImportingStrategy(ImportingData importingData, String currentImportAlias) {
        this.importingData = importingData;
        this.currentImportAlias = currentImportAlias;
        Optional<String> maybeParentImportAlias = importingData.getOriginalInterpreter().getContext().getImportResourceAlias();
        this.fullImportAlias = maybeParentImportAlias.isPresent() ? String.format("%s.%s", maybeParentImportAlias.get(), currentImportAlias) : currentImportAlias;
    }

    @Override
    public String handleDeferredTemplateFile(DeferredValueException e) {
        return this.importingData.getInitialPathSetter() + new PrefixToPreserveState(EagerReconstructionUtils.handleDeferredTokenAndReconstructReferences(this.importingData.getOriginalInterpreter(), DeferredToken.builderFromToken(this.importingData.getTagToken()).addUsedDeferredWords(Stream.of(this.importingData.getHelpers().get(0))).addSetDeferredWords(Stream.of(this.currentImportAlias)).build())) + this.importingData.getTagToken().getImage();
    }

    @Override
    public void setup(JinjavaInterpreter child) {
        child.getContext().getScope().put("import_resource_alias", this.fullImportAlias);
        child.getContext().put("import_resource_alias", this.fullImportAlias);
        AliasedEagerImportingStrategy.constructFullAliasPathMap(this.currentImportAlias, child);
        AliasedEagerImportingStrategy.getMapForCurrentContextAlias(this.currentImportAlias, child);
        this.importingData.getOriginalInterpreter().getContext().put(AliasedEagerImportingStrategy.getTemporaryImportAlias(this.fullImportAlias), DeferredValue.instance());
    }

    @Override
    public void integrateChild(JinjavaInterpreter child) {
        JinjavaInterpreter parent = this.importingData.getOriginalInterpreter();
        for (MacroFunction macro : child.getContext().getGlobalMacros().values()) {
            if (!parent.getContext().isDeferredExecutionMode()) continue;
            macro.setDeferred(true);
        }
        Map<String, Object> childBindings = child.getContext().getSessionBindings();
        childBindings.putAll(child.getContext().getGlobalMacros());
        String temporaryImportAlias = AliasedEagerImportingStrategy.getTemporaryImportAlias(this.fullImportAlias);
        Map<String, Object> mapForCurrentContextAlias = AliasedEagerImportingStrategy.getMapForCurrentContextAlias(this.currentImportAlias, child);
        childBindings.remove(temporaryImportAlias);
        this.importingData.getOriginalInterpreter().getContext().remove(temporaryImportAlias);
        childBindings.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("__macros__") && !((String)entry.getKey()).equals("import_resource_alias")).forEach(entry -> mapForCurrentContextAlias.put((String)entry.getKey(), entry.getValue()));
    }

    @Override
    public String getFinalOutput(String newPathSetter, String output, JinjavaInterpreter child) {
        String temporaryImportAlias = AliasedEagerImportingStrategy.getTemporaryImportAlias(this.fullImportAlias);
        return newPathSetter + EagerReconstructionUtils.buildBlockOrInlineSetTag(temporaryImportAlias, Collections.emptyMap(), this.importingData.getOriginalInterpreter()) + this.wrapInChildScope(EagerImportingStrategy.getSetTagForDeferredChildBindings(child, this.currentImportAlias, child.getContext()) + output, child) + EagerReconstructionUtils.buildSetTag(ImmutableMap.of(this.currentImportAlias, temporaryImportAlias), this.importingData.getOriginalInterpreter(), true) + this.importingData.getInitialPathSetter();
    }

    private static void constructFullAliasPathMap(String currentImportAlias, JinjavaInterpreter child) {
        String fullImportAlias = child.getContext().getImportResourceAlias().orElse(currentImportAlias);
        String[] allAliases = fullImportAlias.split("\\.");
        Map<String, Object> currentMap = child.getContext().getParent();
        for (int i = 0; i < allAliases.length - 1; ++i) {
            Object maybeNextMap = currentMap.get(allAliases[i]);
            if (maybeNextMap instanceof Map) {
                currentMap = (Map)maybeNextMap;
                continue;
            }
            if (maybeNextMap instanceof DeferredValue && ((DeferredValue)maybeNextMap).getOriginalValue() instanceof Map) {
                currentMap = (Map)((DeferredValue)maybeNextMap).getOriginalValue();
                continue;
            }
            throw new InterpretException("Encountered a problem with import alias maps");
        }
        currentMap.put(allAliases[allAliases.length - 1], child.getContext().isDeferredExecutionMode() ? DeferredValue.instance(new PyMap(new HashMap<String, Object>())) : new PyMap(new HashMap<String, Object>()));
    }

    private static Map<String, Object> getMapForCurrentContextAlias(String currentImportAlias, JinjavaInterpreter child) {
        Object parentValueForChild = child.getContext().getParent().getSessionBindings().get(currentImportAlias);
        if (parentValueForChild instanceof Map) {
            return (Map)parentValueForChild;
        }
        if (parentValueForChild instanceof DeferredValue) {
            if (((DeferredValue)parentValueForChild).getOriginalValue() instanceof Map) {
                return (Map)((DeferredValue)parentValueForChild).getOriginalValue();
            }
            PyMap newMap = new PyMap(new HashMap<String, Object>());
            child.getContext().getParent().put(currentImportAlias, DeferredValue.instance(newMap));
            return newMap;
        }
        PyMap newMap = new PyMap(new HashMap<String, Object>());
        child.getContext().getParent().put(currentImportAlias, child.getContext().isDeferredExecutionMode() ? DeferredValue.instance(newMap) : newMap);
        return newMap;
    }

    private String wrapInChildScope(String output, JinjavaInterpreter child) {
        String combined = output + this.getDoTagToPreserve(this.importingData.getOriginalInterpreter(), child);
        return EagerReconstructionUtils.wrapInChildScope(combined, this.importingData.getOriginalInterpreter());
    }

    private String getDoTagToPreserve(JinjavaInterpreter interpreter, JinjavaInterpreter child) {
        StringJoiner keyValueJoiner = new StringJoiner(",");
        String temporaryImportAlias = AliasedEagerImportingStrategy.getTemporaryImportAlias(this.fullImportAlias);
        Map<String, Object> currentAliasMap = AliasedEagerImportingStrategy.getMapForCurrentContextAlias(this.currentImportAlias, child);
        for (Map.Entry<String, Object> entry : currentAliasMap.entrySet()) {
            if (entry.getKey().equals(temporaryImportAlias)) continue;
            if (entry.getValue() instanceof DeferredValue) {
                keyValueJoiner.add(String.format("'%s': %s", entry.getKey(), entry.getKey()));
                continue;
            }
            if (entry.getValue() instanceof MacroFunction) continue;
            keyValueJoiner.add(String.format("'%s': %s", entry.getKey(), PyishObjectMapper.getAsPyishString(entry.getValue())));
        }
        if (keyValueJoiner.length() > 0) {
            return EagerReconstructionUtils.buildDoUpdateTag(temporaryImportAlias, "{" + keyValueJoiner.toString() + "}", interpreter);
        }
        return "";
    }
}

