/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.PrintTag;
import com.hubspot.jinjava.lib.tag.eager.DeferredToken;
import com.hubspot.jinjava.lib.tag.eager.EagerExecutionResult;
import com.hubspot.jinjava.lib.tag.eager.EagerStateChangingTag;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.util.EagerContextWatcher;
import com.hubspot.jinjava.util.EagerExpressionResolver;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import com.hubspot.jinjava.util.LengthLimitingStringJoiner;
import com.hubspot.jinjava.util.PrefixToPreserveState;
import org.apache.commons.lang3.StringUtils;

public class EagerPrintTag
extends EagerStateChangingTag<PrintTag> {
    public EagerPrintTag() {
        super(new PrintTag());
    }

    public EagerPrintTag(PrintTag printTag) {
        super(printTag);
    }

    @Override
    public String getEagerTagImage(TagToken tagToken, JinjavaInterpreter interpreter) {
        String expr = tagToken.getHelpers();
        if (StringUtils.isBlank(expr)) {
            throw new TemplateSyntaxException(interpreter, tagToken.getImage(), "Tag 'print' expects expression");
        }
        return EagerPrintTag.interpretExpression(expr, tagToken, interpreter, true);
    }

    public static String interpretExpression(String expr, TagToken tagToken, JinjavaInterpreter interpreter, boolean includeExpressionResult) {
        EagerExecutionResult eagerExecutionResult = EagerContextWatcher.executeInChildContext(eagerInterpreter -> EagerExpressionResolver.resolveExpression(expr, interpreter), interpreter, EagerContextWatcher.EagerChildContextConfig.newBuilder().withTakeNewValue(true).build());
        PrefixToPreserveState prefixToPreserveState = new PrefixToPreserveState();
        if (!eagerExecutionResult.getResult().isFullyResolved() || interpreter.getContext().isDeferredExecutionMode()) {
            prefixToPreserveState.putAll(eagerExecutionResult.getPrefixToPreserveState());
        } else {
            EagerReconstructionUtils.commitSpeculativeBindings(interpreter, eagerExecutionResult);
        }
        if (eagerExecutionResult.getResult().isFullyResolved()) {
            return prefixToPreserveState.toString() + (includeExpressionResult ? EagerReconstructionUtils.wrapInRawIfNeeded(eagerExecutionResult.getResult().toString(true), interpreter) : "");
        }
        EagerReconstructionUtils.hydrateReconstructionFromContextBeforeDeferring(prefixToPreserveState, eagerExecutionResult.getResult().getDeferredWords(), interpreter);
        LengthLimitingStringJoiner joiner = new LengthLimitingStringJoiner(interpreter.getConfig().getMaxOutputSize(), " ");
        joiner.add(tagToken.getSymbols().getExpressionStartWithTag()).add(tagToken.getTagName()).add(eagerExecutionResult.getResult().toString().trim()).add(tagToken.getSymbols().getExpressionEndWithTag());
        prefixToPreserveState.withAllInFront(EagerReconstructionUtils.handleDeferredTokenAndReconstructReferences(interpreter, DeferredToken.builderFromImage(joiner.toString(), tagToken).addUsedDeferredWords(eagerExecutionResult.getResult().getDeferredWords()).build()));
        return EagerReconstructionUtils.wrapInAutoEscapeIfNeeded(prefixToPreserveState.toString() + joiner.toString(), interpreter);
    }
}

