/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.hubspot.jinjava.interpret.DeferredLazyReferenceSource;
import com.hubspot.jinjava.interpret.DeferredValueShadow;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.LazyReference;
import com.hubspot.jinjava.objects.serialization.PyishObjectMapper;
import com.hubspot.jinjava.util.EagerExpressionResolver;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import com.hubspot.jinjava.util.PrefixToPreserveState;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class EagerExecutionResult {
    private final EagerExpressionResolver.EagerExpressionResult result;
    private final Map<String, Object> speculativeBindings;
    private PrefixToPreserveState prefixToPreserveState;

    public EagerExecutionResult(EagerExpressionResolver.EagerExpressionResult result, Map<String, Object> speculativeBindings) {
        this.result = result;
        this.speculativeBindings = speculativeBindings;
    }

    public EagerExpressionResolver.EagerExpressionResult getResult() {
        return this.result;
    }

    public Map<String, Object> getSpeculativeBindings() {
        return this.speculativeBindings;
    }

    public PrefixToPreserveState getPrefixToPreserveState() {
        if (this.prefixToPreserveState != null) {
            return this.prefixToPreserveState;
        }
        JinjavaInterpreter interpreter = JinjavaInterpreter.getCurrent();
        this.prefixToPreserveState = new PrefixToPreserveState();
        Collection filteredEntries = this.speculativeBindings.entrySet().stream().filter(entry -> {
            Object contextValue = interpreter.getContext().get(entry.getKey());
            if (contextValue instanceof DeferredLazyReferenceSource) {
                ((DeferredLazyReferenceSource)contextValue).setReconstructed(true);
            }
            return !(contextValue instanceof DeferredValueShadow);
        }).collect(Collectors.toList());
        filteredEntries.stream().filter(entry -> !(entry.getValue() instanceof LazyReference)).forEach(entry -> EagerReconstructionUtils.hydrateBlockOrInlineSetTagRecursively(this.prefixToPreserveState, (String)entry.getKey(), entry.getValue(), interpreter));
        filteredEntries.stream().filter(entry -> entry.getValue() instanceof LazyReference).map(entry -> new AbstractMap.SimpleImmutableEntry<String, String>((String)entry.getKey(), PyishObjectMapper.getAsPyishString(entry.getValue()))).sorted((a, b) -> ((String)a.getValue()).equals(b.getKey()) ? 1 : (((String)b.getValue()).equals(a.getKey()) ? -1 : 0)).forEach(entry -> this.prefixToPreserveState.put((String)entry.getKey(), EagerReconstructionUtils.buildSetTag(Collections.singletonMap((String)entry.getKey(), (String)entry.getValue()), interpreter, false)));
        return this.prefixToPreserveState;
    }

    public String asTemplateString() {
        return this.getPrefixToPreserveState().toString() + this.result.toString(true);
    }
}

