/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag.eager;

import com.hubspot.jinjava.interpret.CallStack;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.DeferredLazyReference;
import com.hubspot.jinjava.interpret.DeferredLazyReferenceSource;
import com.hubspot.jinjava.interpret.DeferredMacroValueImpl;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueShadow;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.tree.parse.Token;
import com.hubspot.jinjava.tree.parse.TokenScannerSymbols;
import com.hubspot.jinjava.util.EagerExpressionResolver;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeferredToken {
    private final Token token;
    private final Set<String> usedDeferredWords;
    private final Set<String> setDeferredWords;
    private final CallStack macroStack;
    private final String importResourcePath;

    public static DeferredTokenBuilder builderFromToken(Token token) {
        return new DeferredTokenBuilder(token);
    }

    public static <T extends Token> DeferredTokenBuilder builderFromImage(String image, Class<T> tokenClass, JinjavaInterpreter interpreter) {
        return DeferredToken.builderFromToken(DeferredToken.constructToken(tokenClass, image, interpreter.getLineNumber(), interpreter.getPosition(), interpreter.getConfig().getTokenScannerSymbols()));
    }

    public static DeferredTokenBuilder builderFromImage(String image, Token originalToken) {
        return DeferredToken.builderFromToken(DeferredToken.constructToken(originalToken.getClass(), image, originalToken.getLineNumber(), originalToken.getStartPosition(), originalToken.getSymbols()));
    }

    private static <T extends Token> T constructToken(Class<T> tokenClass, String image, int lineNumber, int startPosition, TokenScannerSymbols symbols) {
        try {
            return (T)((Token)tokenClass.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, TokenScannerSymbols.class).newInstance(image, lineNumber, startPosition, symbols));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public DeferredToken(Token token, Set<String> usedDeferredWords) {
        this(token, usedDeferredWords, Collections.emptySet());
    }

    @Deprecated
    public DeferredToken(Token token, Set<String> usedDeferredWords, Set<String> setDeferredWords) {
        this(token, DeferredToken.getBases(usedDeferredWords), DeferredToken.getBases(setDeferredWords), DeferredToken.acquireImportResourcePath(), DeferredToken.acquireMacroStack());
    }

    private DeferredToken(Token token, Set<String> usedDeferredWordBases, Set<String> setDeferredWordBases, String importResourcePath, CallStack macroStack) {
        this.token = token;
        this.usedDeferredWords = usedDeferredWordBases;
        this.setDeferredWords = setDeferredWordBases;
        this.importResourcePath = importResourcePath;
        this.macroStack = macroStack;
    }

    public Token getToken() {
        return this.token;
    }

    public Set<String> getUsedDeferredWords() {
        return this.usedDeferredWords;
    }

    public Set<String> getSetDeferredWords() {
        return this.setDeferredWords;
    }

    public String getImportResourcePath() {
        return this.importResourcePath;
    }

    public CallStack getMacroStack() {
        return this.macroStack;
    }

    public void addTo(Context context) {
        this.addTo(context, this.usedDeferredWords.stream().filter(word -> {
            Object value = context.get(word);
            return value != null && !(value instanceof DeferredValue);
        }).collect(Collectors.toCollection(HashSet::new)));
    }

    private void addTo(Context context, Set<String> wordsWithoutDeferredSource) {
        context.getDeferredTokens().add(this);
        this.deferPropertiesOnContext(context, wordsWithoutDeferredSource);
        if (context.getParent() != null) {
            Context parent = context.getParent();
            if (parent.getParent() != null) {
                this.addTo(parent, wordsWithoutDeferredSource);
            } else {
                context.checkNumberOfDeferredTokens();
            }
        }
    }

    private void deferPropertiesOnContext(Context context, Set<String> wordsWithoutDeferredSource) {
        if (this.isInSameScope(context)) {
            DeferredToken.markDeferredWordsAndFindSources(context, this.getSetDeferredWords(), true);
        }
        wordsWithoutDeferredSource.forEach(word -> DeferredToken.deferDuplicatePointers(context, word));
        wordsWithoutDeferredSource.removeAll(DeferredToken.markDeferredWordsAndFindSources(context, wordsWithoutDeferredSource, false));
    }

    private boolean isInSameScope(Context context) {
        return this.getMacroStack() == null || this.getMacroStack() == context.getMacroStack();
    }

    private static void deferDuplicatePointers(Context context, String word) {
        Object wordValue = context.get(word);
        if (!(wordValue instanceof DeferredValue) && !EagerExpressionResolver.isPrimitive(wordValue)) {
            DeferredLazyReference deferredLazyReference = DeferredLazyReference.instance(context, word);
            Context temp = context;
            HashSet matchingEntries = new HashSet();
            while (temp.getParent() != null) {
                temp.getScope().entrySet().stream().filter(entry -> entry.getValue() == wordValue || entry.getValue() instanceof DeferredValue && ((DeferredValue)entry.getValue()).getOriginalValue() == wordValue).forEach(entry -> {
                    matchingEntries.add(entry);
                    deferredLazyReference.getOriginalValue().setReferenceKey((String)entry.getKey());
                });
                temp = temp.getParent();
            }
            if (matchingEntries.size() > 1) {
                matchingEntries.forEach(entry -> {
                    if (deferredLazyReference.getOriginalValue().getReferenceKey().equals(entry.getKey())) {
                        DeferredToken.convertToDeferredLazyReferenceSource(context, entry);
                    } else {
                        entry.setValue(deferredLazyReference.clone());
                    }
                });
            }
        }
    }

    private static void convertToDeferredLazyReferenceSource(Context context, Map.Entry<String, Object> entry) {
        Object val = entry.getValue();
        if (val instanceof DeferredLazyReferenceSource) {
            return;
        }
        DeferredLazyReferenceSource deferredLazyReferenceSource = DeferredLazyReferenceSource.instance(val instanceof DeferredValue ? ((DeferredValue)val).getOriginalValue() : val);
        context.replace(entry.getKey(), deferredLazyReferenceSource);
        entry.setValue(deferredLazyReferenceSource);
    }

    private static Collection<String> markDeferredWordsAndFindSources(Context context, Set<String> wordsToDefer, boolean replacing) {
        return wordsToDefer.stream().filter(prop -> {
            Object val = context.get(prop);
            if (replacing) {
                return !(val instanceof DeferredValue) || context.getScope().containsKey(prop);
            }
            return !(val instanceof DeferredValue);
        }).filter(prop -> !context.getMetaContextVariables().contains(prop)).filter(prop -> {
            DeferredValue deferredValue = DeferredToken.convertToDeferredValue(context, prop);
            context.put(prop, deferredValue);
            return !(deferredValue instanceof DeferredValueShadow);
        }).collect(Collectors.toList());
    }

    private static DeferredValue convertToDeferredValue(Context context, String prop) {
        Object valueInScope = context.getScope().get(prop);
        Object value = context.get(prop);
        if (value instanceof DeferredValue) {
            value = ((DeferredValue)value).getOriginalValue();
        }
        if (value != null) {
            if (valueInScope == null) {
                return DeferredValue.shadowInstance(value);
            }
            return DeferredValue.instance(value);
        }
        return DeferredValue.instance();
    }

    private static String acquireImportResourcePath() {
        return JinjavaInterpreter.getCurrentMaybe().map(interpreter -> interpreter.getContext().get("import_resource_path")).filter(path -> path instanceof String).orElse(null);
    }

    private static CallStack acquireMacroStack() {
        return JinjavaInterpreter.getCurrentMaybe().map(interpreter -> interpreter.getContext().getMacroStack()).orElse(null);
    }

    public static Set<String> getBases(Set<String> original) {
        return original.stream().map(prop -> prop.split("\\.", 2)[0]).collect(Collectors.toSet());
    }

    public static class DeferredTokenBuilder {
        private final Token token;
        private Stream<String> usedDeferredWords;
        private Stream<String> setDeferredWords;

        private DeferredTokenBuilder(Token token) {
            this.token = token;
        }

        public DeferredToken build() {
            JinjavaInterpreter interpreter = JinjavaInterpreter.getCurrent();
            return new DeferredToken(this.token, this.usedDeferredWords != null ? this.usedDeferredWords.map(prop -> prop.split("\\.", 2)[0]).distinct().filter(word -> interpreter == null || !(interpreter.getContext().get(word) instanceof DeferredMacroValueImpl)).collect(Collectors.toSet()) : Collections.emptySet(), this.setDeferredWords != null ? this.setDeferredWords.map(prop -> prop.split("\\.", 2)[0]).collect(Collectors.toSet()) : Collections.emptySet(), DeferredToken.acquireImportResourcePath(), DeferredToken.acquireMacroStack());
        }

        public DeferredTokenBuilder addUsedDeferredWords(Collection<String> usedDeferredWordsToAdd) {
            return this.addUsedDeferredWords(usedDeferredWordsToAdd.stream());
        }

        public DeferredTokenBuilder addUsedDeferredWords(Stream<String> usedDeferredWordsToAdd) {
            this.usedDeferredWords = this.usedDeferredWords == null ? usedDeferredWordsToAdd : Stream.concat(this.usedDeferredWords, usedDeferredWordsToAdd);
            return this;
        }

        public DeferredTokenBuilder addSetDeferredWords(Collection<String> setDeferredWordsToAdd) {
            return this.addSetDeferredWords(setDeferredWordsToAdd.stream());
        }

        public DeferredTokenBuilder addSetDeferredWords(Stream<String> setDeferredWordsToAdd) {
            this.setDeferredWords = this.setDeferredWords == null ? setDeferredWordsToAdd : Stream.concat(this.setDeferredWords, setDeferredWordsToAdd);
            return this;
        }
    }
}

