/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.HelperStringTokenizer;
import java.util.List;

@JinjavaDoc(params={@JinjavaParam(value="string_to_print")})
public class CycleTag
implements Tag {
    public static final String TAG_NAME = "cycle";
    public static final String LOOP_INDEX = "loop.index0";
    private static final long serialVersionUID = 9145890505287556784L;

    @Override
    public boolean isRenderedInValidationMode() {
        return true;
    }

    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        String var = null;
        HelperStringTokenizer tk = new HelperStringTokenizer(tagNode.getHelpers());
        List<String> helper = tk.allTokens();
        if (helper.size() == 1) {
            HelperStringTokenizer items = new HelperStringTokenizer(helper.get(0));
            items.splitComma(true);
            List values = items.allTokens();
            Integer forindex = (Integer)interpreter.retraceVariable(LOOP_INDEX, tagNode.getLineNumber(), tagNode.getStartPosition());
            if (forindex == null) {
                forindex = 0;
            }
            if (values.size() == 1) {
                var = values.get(0);
                if ((values = (List)interpreter.retraceVariable(var, tagNode.getLineNumber(), tagNode.getStartPosition())) == null) {
                    return interpreter.resolveString(var, tagNode.getLineNumber(), tagNode.getStartPosition());
                }
            } else {
                for (int i = 0; i < values.size(); ++i) {
                    values.set(i, interpreter.resolveString(values.get(i), tagNode.getLineNumber(), tagNode.getStartPosition()));
                }
            }
            return values.get(forindex % values.size());
        }
        if (helper.size() == 3) {
            HelperStringTokenizer items = new HelperStringTokenizer(helper.get(0));
            items.splitComma(true);
            List<String> values = items.allTokens();
            for (int i = 0; i < values.size(); ++i) {
                values.set(i, interpreter.resolveString(values.get(i), tagNode.getLineNumber(), tagNode.getStartPosition()));
            }
            var = helper.get(2);
            interpreter.getContext().put(var, values);
            return "";
        }
        throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'cycle' expects 1 or 3 helper(s), was: " + helper.size(), tagNode.getLineNumber(), tagNode.getStartPosition());
    }

    @Override
    public String getEndTagName() {
        return null;
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }
}

