/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.InvalidArgumentException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.lib.filter.AdvancedFilter;
import com.hubspot.jinjava.lib.fn.Functions;
import com.hubspot.jinjava.objects.SafeString;
import java.util.Map;
import java.util.Objects;
import jinjava.org.jsoup.Jsoup;
import jinjava.org.jsoup.nodes.Document;
import jinjava.org.jsoup.nodes.Element;
import jinjava.org.jsoup.nodes.Node;
import jinjava.org.jsoup.nodes.TextNode;
import jinjava.org.jsoup.select.NodeVisitor;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(params={@JinjavaParam(value="length", type="number", defaultValue="255"), @JinjavaParam(value="end", defaultValue="..."), @JinjavaParam(value="breakword", type="boolean", defaultValue="false")})
public class TruncateHtmlFilter
implements AdvancedFilter {
    private static final int DEFAULT_TRUNCATE_LENGTH = 255;
    private static final String DEFAULT_END = "...";
    private static final String LENGTH_KEY = "length";
    private static final String END_KEY = "end";
    private static final String BREAKWORD_KEY = "breakword";

    @Override
    public String getName() {
        return "truncatehtml";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, Object[] args, Map<String, Object> kwargs) {
        String length = null;
        if (kwargs.containsKey(LENGTH_KEY)) {
            length = Objects.toString(kwargs.get(LENGTH_KEY));
        }
        String end = null;
        if (kwargs.containsKey(END_KEY)) {
            end = Objects.toString(kwargs.get(END_KEY));
        }
        String breakword = null;
        if (kwargs.containsKey(BREAKWORD_KEY)) {
            breakword = Objects.toString(kwargs.get(BREAKWORD_KEY));
        }
        String[] newArgs = new String[3];
        for (int i = 0; i < args.length && i < newArgs.length; ++i) {
            newArgs[i] = Objects.toString(args[i]);
        }
        if (length != null) {
            newArgs[0] = length;
        }
        if (end != null) {
            newArgs[1] = end;
        }
        if (breakword != null) {
            newArgs[2] = breakword;
        }
        if (var instanceof SafeString) {
            return this.filter((SafeString)var, interpreter, newArgs);
        }
        return this.filter(var, interpreter, newArgs);
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        if (var instanceof String) {
            int length = 255;
            String ends = DEFAULT_END;
            if (args.length > 0) {
                try {
                    length = Integer.parseInt(Objects.toString(args[0]));
                }
                catch (Exception e) {
                    interpreter.addError(TemplateError.fromInvalidArgumentException(new InvalidArgumentException(interpreter, "truncatehtml", String.format("truncatehtml(): error setting length of %s, using default of %d", args[0], 255))));
                }
            }
            if (args.length > 1 && args[1] != null) {
                ends = args[1];
            }
            boolean killwords = false;
            if (args.length > 2 && args[2] != null) {
                killwords = BooleanUtils.toBoolean(args[2]);
            }
            Document dom = Jsoup.parseBodyFragment((String)var);
            ContentTruncatingNodeVisitor visitor = new ContentTruncatingNodeVisitor(length, ends, killwords);
            dom.select("body").traverse(visitor);
            dom.select(".__deleteme").remove();
            return dom.select("body").html();
        }
        return var;
    }

    private static class ContentTruncatingNodeVisitor
    implements NodeVisitor {
        private final int maxTextLen;
        private int textLen;
        private final String ending;
        private final boolean killwords;

        ContentTruncatingNodeVisitor(int maxTextLen, String ending, boolean killwords) {
            this.maxTextLen = maxTextLen;
            this.ending = ending;
            this.killwords = killwords;
        }

        @Override
        public void head(Node node, int depth) {
            if (node instanceof TextNode) {
                TextNode text = (TextNode)node;
                String textContent = text.text();
                if (this.textLen >= this.maxTextLen) {
                    text.text("");
                } else if (this.textLen + textContent.length() > this.maxTextLen) {
                    int ptr = this.maxTextLen - this.textLen;
                    if (!this.killwords) {
                        ptr = Functions.movePointerToJustBeforeLastWord(ptr, textContent) - 1;
                    }
                    text.text(textContent.substring(0, ptr) + this.ending);
                    this.textLen = this.maxTextLen;
                } else {
                    this.textLen += textContent.length();
                }
            }
        }

        @Override
        public void tail(Node node, int depth) {
            Element el;
            if (node instanceof Element && StringUtils.isBlank((el = (Element)node).text())) {
                el.addClass("__deleteme");
            }
        }
    }
}

