/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.random.RandomNumberGeneratorStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

@JinjavaDoc
public class ShuffleFilter
implements Filter {
    @Override
    public String getName() {
        return "shuffle";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        if (interpreter.getConfig().getRandomNumberGeneratorStrategy() == RandomNumberGeneratorStrategy.CONSTANT_ZERO) {
            return var;
        }
        if (var instanceof Collection) {
            ArrayList list = new ArrayList((Collection)var);
            Collections.shuffle(list, interpreter.getRandom());
            return list;
        }
        return var;
    }
}

