/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.InvalidInputException;
import com.hubspot.jinjava.interpret.InvalidReason;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.math.NumberUtils;

@JinjavaDoc(params={@JinjavaParam(value="precision", type="number", defaultValue="0"), @JinjavaParam(value="method", type="enum common|ceil|floor", defaultValue="common")})
public class RoundFilter
implements Filter {
    @Override
    public String getName() {
        return "round";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        RoundingMode roundingMode;
        BigDecimal result;
        if (var == null) {
            return null;
        }
        try {
            result = new BigDecimal(var.toString());
        }
        catch (NumberFormatException e) {
            throw new InvalidInputException(interpreter, this, InvalidReason.NUMBER_FORMAT, var.toString());
        }
        int precision = 0;
        if (args.length > 0 && args[0] != null) {
            precision = NumberUtils.toInt(args[0]);
        }
        String method = "common";
        if (args.length > 1 && args[1] != null) {
            method = args[1];
        }
        switch (method) {
            case "ceil": {
                roundingMode = RoundingMode.CEILING;
                break;
            }
            case "floor": {
                roundingMode = RoundingMode.FLOOR;
                break;
            }
            default: {
                roundingMode = RoundingMode.HALF_UP;
            }
        }
        return result.setScale(precision, roundingMode);
    }
}

