/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.InvalidArgumentException;
import com.hubspot.jinjava.interpret.InvalidInputException;
import com.hubspot.jinjava.interpret.InvalidReason;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.Importable;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.lib.filter.ReplaceFilter;

@JinjavaDoc(params={@JinjavaParam(value="regex", required=true), @JinjavaParam(value="new", required=true)})
public class RegexReplaceFilter
implements Filter {
    @Override
    public String getName() {
        return "regex_replace";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        if (args.length < 2) {
            throw new TemplateSyntaxException(interpreter, this.getName(), "requires 2 arguments (regex string, replacement string)");
        }
        if (args[0] == null || args[1] == null) {
            throw new TemplateSyntaxException(interpreter, this.getName(), "requires both a valid regex and new params (not null)");
        }
        if (var == null) {
            return null;
        }
        if (var instanceof String) {
            String s = (String)var;
            if (s.length() > 100) {
                ReplaceFilter.checkLength(interpreter, s, this);
            }
            String toReplace = args[0];
            String replaceWith = args[1];
            try {
                Pattern p = Pattern.compile(toReplace);
                Matcher matcher = p.matcher(s);
                return matcher.replaceAll(replaceWith);
            }
            catch (PatternSyntaxException e) {
                throw new InvalidArgumentException(interpreter, (Importable)this, InvalidReason.REGEX, 0, toReplace);
            }
        }
        throw new InvalidInputException(interpreter, this, InvalidReason.STRING, new Object[0]);
    }
}

