/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.AbstractFilter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(params={@JinjavaParam(value="width", type="number", defaultValue="4"), @JinjavaParam(value="indentfirst", type="boolean", defaultValue="False")})
public class IndentFilter
extends AbstractFilter {
    public static final String INDENT_FIRST_PARAM = "indentfirst";
    public static final String WIDTH_PARAM = "width";
    private static final Splitter NEWLINE_SPLITTER = Splitter.on('\n');
    private static final Joiner NEWLINE_JOINER = Joiner.on('\n');

    @Override
    public String getName() {
        return "indent";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, Map<String, Object> parsedArgs) {
        int width = ((Number)parsedArgs.get(WIDTH_PARAM)).intValue();
        boolean indentFirst = (Boolean)parsedArgs.get(INDENT_FIRST_PARAM);
        ArrayList<String> indentedLines = new ArrayList<String>();
        for (String line : NEWLINE_SPLITTER.split(Objects.toString(var, ""))) {
            int thisWidth = indentedLines.size() == 0 && !indentFirst ? 0 : width;
            indentedLines.add(StringUtils.repeat(' ', thisWidth) + line);
        }
        return NEWLINE_JOINER.join(indentedLines);
    }
}

