/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.commons.lang3.math.NumberUtils;

@JinjavaDoc(params={@JinjavaParam(value="default", type="float", defaultValue="0.0")})
public class FloatFilter
implements Filter {
    @Override
    public String getName() {
        return "float";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        float result;
        float defaultVal = 0.0f;
        if (args.length > 0) {
            defaultVal = NumberUtils.toFloat(args[0], 0.0f);
        }
        if (var == null) {
            return Float.valueOf(defaultVal);
        }
        if (Float.class.isAssignableFrom(var.getClass())) {
            return var;
        }
        if (Number.class.isAssignableFrom(var.getClass())) {
            return Float.valueOf(((Number)var).floatValue());
        }
        String input = var.toString();
        Locale locale = interpreter.getConfig().getLocale();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        ParsePosition pp = new ParsePosition(0);
        try {
            result = numberFormat.parse(input, pp).floatValue();
        }
        catch (Exception e) {
            result = defaultVal;
        }
        if (pp.getErrorIndex() != -1 || pp.getIndex() != input.length()) {
            result = defaultVal;
        }
        return Float.valueOf(result);
    }
}

