/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(params={@JinjavaParam(value="all_braces", type="boolean", defaultValue="true")})
public class EscapeJinjavaFilter
implements Filter {
    private static final String SLBRACE = "{";
    private static final String BLBRACE = "&lbrace;";
    private static final String SRBRACE = "}";
    private static final String BRBRACE = "&rbrace;";
    private static final String[] TO_REPLACE = new String[]{"{", "}"};
    private static final String[] REPLACE_WITH = new String[]{"&lbrace;", "&rbrace;"};

    public static String escapeJinjavaEntities(String input) {
        return StringUtils.replaceEach(input, TO_REPLACE, REPLACE_WITH);
    }

    public static String escapeFullJinjavaEntities(String input) {
        return input.replace("{{", "&lbrace;&lbrace;").replace("}}", "&rbrace;&rbrace;").replaceAll("\\{([{%#])", "&lbrace;$1").replaceAll("([}%#])}", "$1&rbrace;");
    }

    @Override
    public Object filter(Object object, JinjavaInterpreter interpreter, String ... arg) {
        if (arg.length > 0 && "false".equals(arg[0])) {
            return EscapeJinjavaFilter.escapeFullJinjavaEntities(Objects.toString(object, ""));
        }
        return EscapeJinjavaFilter.escapeJinjavaEntities(Objects.toString(object, ""));
    }

    @Override
    public String getName() {
        return "escape_jinjava";
    }
}

