/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.filter.AbstractFilter;
import com.hubspot.jinjava.lib.filter.AdvancedFilter;
import com.hubspot.jinjava.objects.PyWrapper;
import com.hubspot.jinjava.util.ObjectTruthValue;
import java.util.Map;
import java.util.Objects;

@JinjavaDoc(params={@JinjavaParam(value="default_value", type="object", required=true), @JinjavaParam(value="truthy", type="boolean", defaultValue="False")})
public class DefaultFilter
extends AbstractFilter
implements AdvancedFilter {
    public static final String DEFAULT_VALUE_PARAM = "default_value";
    public static final String TRUTHY_PARAM = "truthy";

    @Override
    public Object filter(Object object, JinjavaInterpreter interpreter, Map<String, Object> parsedArgs) {
        if (parsedArgs.size() < 1) {
            throw new TemplateSyntaxException(interpreter, this.getName(), "requires either 1 (default value to use) or 2 (default value to use, default with variables that evaluate to false) arguments");
        }
        boolean truthy = Boolean.TRUE.equals(parsedArgs.get(TRUTHY_PARAM));
        Object defaultValue = parsedArgs.get(DEFAULT_VALUE_PARAM);
        if (truthy ? ObjectTruthValue.evaluate(object) : object != null) {
            return object;
        }
        return defaultValue instanceof PyWrapper || defaultValue == null ? defaultValue : Objects.toString(defaultValue);
    }

    @Override
    public String getName() {
        return "default";
    }
}

