/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.interpret;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.hubspot.jinjava.Jinjava;
import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.el.ExpressionResolver;
import com.hubspot.jinjava.el.ext.DeferredParsingException;
import com.hubspot.jinjava.interpret.CollectionTooBigException;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.ExtendsTagCycleException;
import com.hubspot.jinjava.interpret.OutputTooBigException;
import com.hubspot.jinjava.interpret.PartiallyDeferredValue;
import com.hubspot.jinjava.interpret.RevertibleObject;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.lib.tag.ExtendsTag;
import com.hubspot.jinjava.lib.tag.eager.EagerGenericTag;
import com.hubspot.jinjava.objects.serialization.PyishObjectMapper;
import com.hubspot.jinjava.objects.serialization.PyishSerializable;
import com.hubspot.jinjava.random.ConstantZeroRandomNumberGenerator;
import com.hubspot.jinjava.random.DeferredRandomNumberGenerator;
import com.hubspot.jinjava.tree.ExpressionNode;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.tree.TreeParser;
import com.hubspot.jinjava.tree.output.BlockInfo;
import com.hubspot.jinjava.tree.output.BlockPlaceholderOutputNode;
import com.hubspot.jinjava.tree.output.OutputList;
import com.hubspot.jinjava.tree.output.OutputNode;
import com.hubspot.jinjava.tree.output.RenderedOutputNode;
import com.hubspot.jinjava.util.EagerReconstructionUtils;
import com.hubspot.jinjava.util.Logging;
import com.hubspot.jinjava.util.RenderLimitUtils;
import com.hubspot.jinjava.util.Variable;
import com.hubspot.jinjava.util.WhitespaceUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class JinjavaInterpreter
implements PyishSerializable {
    private final Multimap<String, BlockInfo> blocks = ArrayListMultimap.create();
    private final LinkedList<Node> extendParentRoots = new LinkedList();
    private final Map<String, RevertibleObject> revertibleObjects = new HashMap<String, RevertibleObject>();
    private Context context;
    private final JinjavaConfig config;
    private final ExpressionResolver expressionResolver;
    private final Jinjava application;
    private final Random random;
    private int lineNumber = -1;
    private int position = 0;
    private int scopeDepth = 1;
    private BlockInfo currentBlock;
    private final List<TemplateError> errors = new ArrayList<TemplateError>();
    private final Set<Integer> errorSet = new HashSet<Integer>();
    private static final ThreadLocal<Stack<JinjavaInterpreter>> CURRENT_INTERPRETER = ThreadLocal.withInitial(Stack::new);

    public JinjavaInterpreter(Jinjava application, Context context, JinjavaConfig renderConfig) {
        this.context = context;
        this.config = renderConfig;
        this.application = application;
        this.config.getExecutionMode().prepareContext(this.context);
        switch (this.config.getRandomNumberGeneratorStrategy()) {
            case THREAD_LOCAL: {
                this.random = ThreadLocalRandom.current();
                break;
            }
            case CONSTANT_ZERO: {
                this.random = new ConstantZeroRandomNumberGenerator();
                break;
            }
            case DEFERRED: {
                this.random = new DeferredRandomNumberGenerator();
                break;
            }
            default: {
                throw new IllegalStateException("No random number generator with strategy " + (Object)((Object)this.config.getRandomNumberGeneratorStrategy()));
            }
        }
        this.expressionResolver = new ExpressionResolver(this, application);
    }

    public JinjavaInterpreter(JinjavaInterpreter orig) {
        this(orig.application, new Context(orig.context), orig.config);
        this.scopeDepth = orig.getScopeDepth() + 1;
    }

    public static boolean isOutputTooLarge(String string) {
        Optional<Long> maxStringLength = JinjavaInterpreter.getCurrentMaybe().map(interpreter -> interpreter.getConfig().getMaxOutputSize()).filter(max -> max > 0L);
        return maxStringLength.map(max -> string != null && (long)string.length() > max).orElse(false);
    }

    public void addExtendParentRoot(Node root) {
        this.extendParentRoots.add(root);
    }

    public void addBlock(String name, BlockInfo blockInfo) {
        this.blocks.put(name, blockInfo);
    }

    public InterpreterScopeClosable enterScope() {
        return this.enterScope(null);
    }

    public InterpreterScopeClosable enterScope(Map<Context.Library, Set<String>> disabled) {
        this.context = new Context(this.context, null, disabled);
        ++this.scopeDepth;
        return new InterpreterScopeClosable();
    }

    public InterpreterScopeClosable enterNonStackingScope() {
        this.context = new Context(this.context, null, null, false);
        ++this.scopeDepth;
        return new InterpreterScopeClosable();
    }

    public void leaveScope() {
        Context parent = this.context.getParent();
        --this.scopeDepth;
        if (parent != null) {
            parent.addDependencies(this.context.getDependencies());
            this.context = parent;
        }
    }

    public Random getRandom() {
        return this.random;
    }

    public boolean isValidationMode() {
        return this.config.isValidationMode();
    }

    public Map<String, RevertibleObject> getRevertibleObjects() {
        return this.revertibleObjects;
    }

    public Node parse(String template) {
        return new TreeParser(this, template).buildTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderFlat(String template) {
        int depth = this.context.getRenderDepth();
        try {
            if (depth > this.config.getMaxRenderDepth()) {
                Logging.ENGINE_LOG.warn("Max render depth exceeded: {}", (Object)Integer.toString(depth));
                String string = template;
                return string;
            }
            this.context.setRenderDepth(depth + 1);
            String string = this.render(this.parse(template), false);
            return string;
        }
        finally {
            this.context.setRenderDepth(depth);
        }
    }

    public String render(String template) {
        return this.render(template, this.config.getMaxOutputSize());
    }

    public String render(String template, long renderLimit) {
        return this.render(this.parse(template), true, renderLimit);
    }

    public String render(Node root) {
        return this.render(root, true, this.config.getMaxOutputSize());
    }

    public String render(Node root, boolean processExtendRoots) {
        return this.render(root, processExtendRoots, this.config.getMaxOutputSize());
    }

    private String render(Node root, boolean processExtendRoots, long renderLimit) {
        OutputList output = new OutputList(RenderLimitUtils.clampProvidedRenderLimitToConfig(renderLimit, this.config));
        for (Node node2 : root.getChildren()) {
            this.lineNumber = node2.getLineNumber();
            this.position = node2.getStartPosition();
            String renderStr = node2.getMaster().getImage();
            try {
                OutputNode out;
                if (node2 instanceof ExpressionNode && this.context.doesRenderStackContain(renderStr)) {
                    this.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.EXCEPTION, TemplateError.ErrorItem.TAG, "Rendering cycle detected: '" + renderStr + "'", null, this.getLineNumber(), node2.getStartPosition(), null, BasicTemplateErrorCategory.IMPORT_CYCLE_DETECTED, ImmutableMap.of("string", renderStr)));
                    output.addNode(new RenderedOutputNode(renderStr));
                    continue;
                }
                this.context.pushRenderStack(renderStr);
                try {
                    out = node2.render(this);
                }
                catch (DeferredValueException e) {
                    this.context.handleDeferredNode(node2);
                    out = new RenderedOutputNode(node2.getMaster().getImage());
                }
                this.context.popRenderStack();
                output.addNode(out);
            }
            catch (OutputTooBigException e) {
                this.addError(TemplateError.fromOutputTooBigException(e));
                return output.getValue();
            }
            catch (CollectionTooBigException e) {
                this.addError(new TemplateError(TemplateError.ErrorType.FATAL, TemplateError.ErrorReason.COLLECTION_TOO_BIG, TemplateError.ErrorItem.OTHER, ExceptionUtils.getMessage(e), null, -1, -1, e, BasicTemplateErrorCategory.UNKNOWN, ImmutableMap.of()));
                return output.getValue();
            }
        }
        StringBuilder ignoredOutput = new StringBuilder();
        if (processExtendRoots) {
            HashSet<String> extendPaths = new HashSet<String>();
            Optional<String> extendPath = this.context.getExtendPathStack().peek();
            int numDeferredTokensBefore = 0;
            while (!this.extendParentRoots.isEmpty()) {
                if (extendPaths.contains(extendPath.orElse(""))) {
                    this.addError(TemplateError.fromException(new ExtendsTagCycleException(extendPath.orElse(""), this.context.getExtendPathStack().getTopLineNumber(), this.context.getExtendPathStack().getTopStartPosition())));
                    break;
                }
                extendPaths.add(extendPath.orElse(""));
                this.context.getCurrentPathStack().push(extendPath.orElse(""), this.context.getExtendPathStack().getTopLineNumber(), this.context.getExtendPathStack().getTopStartPosition());
                Node parentRoot = this.extendParentRoots.removeFirst();
                if (this.context.getDeferredTokens().size() > numDeferredTokensBefore) {
                    ignoredOutput.append(output.getNodes().stream().filter(node -> node instanceof RenderedOutputNode).map(OutputNode::getValue).collect(Collectors.joining()));
                }
                numDeferredTokensBefore = this.context.getDeferredTokens().size();
                output = new OutputList(this.config.getMaxOutputSize());
                boolean hasNestedExtends = false;
                for (Node node3 : parentRoot.getChildren()) {
                    this.lineNumber = node3.getLineNumber() - 1;
                    this.position = node3.getStartPosition();
                    try {
                        OutputNode out = node3.render(this);
                        output.addNode(out);
                        if (!this.isExtendsTag(node3)) continue;
                        hasNestedExtends = true;
                    }
                    catch (OutputTooBigException e) {
                        this.addError(TemplateError.fromOutputTooBigException(e));
                        return output.getValue();
                    }
                }
                Optional<String> currentExtendPath = this.context.getExtendPathStack().pop();
                extendPath = hasNestedExtends ? currentExtendPath : this.context.getExtendPathStack().peek();
                this.context.getCurrentPathStack().pop();
            }
        }
        this.resolveBlockStubs(output);
        if (ignoredOutput.length() > 0) {
            return EagerReconstructionUtils.labelWithNotes(EagerReconstructionUtils.wrapInTag(ignoredOutput.toString(), "do", this, false), "ignored_output_from_extends", this) + output.getValue();
        }
        return output.getValue();
    }

    private void resolveBlockStubs(OutputList output) {
        this.resolveBlockStubs(output, new Stack<String>());
    }

    private boolean isExtendsTag(Node node) {
        return node instanceof TagNode && (((TagNode)node).getTag() instanceof ExtendsTag || this.isEagerExtendsTag((TagNode)node));
    }

    private boolean isEagerExtendsTag(TagNode node) {
        return node.getTag() instanceof EagerGenericTag && ((EagerGenericTag)node.getTag()).getTag() instanceof ExtendsTag;
    }

    private void resolveBlockStubs(OutputList output, Stack<String> blockNames) {
        for (BlockPlaceholderOutputNode blockPlaceholder : output.getBlocks()) {
            Collection<BlockInfo> blockChain;
            BlockInfo block;
            if (!blockNames.contains(blockPlaceholder.getBlockName()) && (block = (BlockInfo)Iterables.getFirst(blockChain = this.blocks.get(blockPlaceholder.getBlockName()), null)) != null && block.getNodes() != null) {
                List superBlock = Optional.ofNullable(Iterables.get(blockChain, 1, null)).map(BlockInfo::getNodes).orElse(null);
                this.context.setSuperBlock(superBlock);
                this.currentBlock = block;
                OutputList blockValueBuilder = new OutputList(this.config.getMaxOutputSize());
                for (Node node : block.getNodes()) {
                    this.lineNumber = node.getLineNumber();
                    this.position = node.getStartPosition();
                    boolean pushedParentPathOntoStack = false;
                    if (block.getParentPath().isPresent() && !this.getContext().getCurrentPathStack().contains(block.getParentPath().get())) {
                        this.getContext().getCurrentPathStack().push(block.getParentPath().get(), block.getParentLineNo(), block.getParentPosition());
                        pushedParentPathOntoStack = true;
                        --this.lineNumber;
                    }
                    blockValueBuilder.addNode(node.render(this));
                    if (!pushedParentPathOntoStack) continue;
                    this.getContext().getCurrentPathStack().pop();
                }
                blockNames.push(blockPlaceholder.getBlockName());
                this.resolveBlockStubs(blockValueBuilder, blockNames);
                blockNames.pop();
                this.context.removeSuperBlock();
                this.currentBlock = null;
                blockPlaceholder.resolve(blockValueBuilder.getValue());
            }
            if (blockPlaceholder.isResolved()) continue;
            blockPlaceholder.resolve("");
        }
    }

    public Object retraceVariable(String variable, int lineNumber, int startPosition) {
        if (StringUtils.isBlank(variable)) {
            return "";
        }
        Variable var = new Variable(this, variable);
        String varName = var.getName();
        Object obj = this.context.get(varName);
        if (obj == null && this.context.getDynamicVariableResolver() != null) {
            obj = this.context.getDynamicVariableResolver().apply(varName);
        }
        if (obj != null) {
            if (obj instanceof DeferredValue && !(obj instanceof PartiallyDeferredValue)) {
                if (this.config.getExecutionMode().useEagerParser()) {
                    throw new DeferredParsingException(this, variable);
                }
                throw new DeferredValueException(variable, lineNumber, startPosition);
            }
            obj = var.resolve(obj);
        }
        return obj;
    }

    public Object retraceVariable(String variable, int lineNumber) {
        return this.retraceVariable(variable, lineNumber, -1);
    }

    public Object resolveObject(String variable, int lineNumber, int startPosition) {
        if (StringUtils.isBlank(variable)) {
            return "";
        }
        if (WhitespaceUtils.isQuoted(variable)) {
            return WhitespaceUtils.unquote(variable);
        }
        Object val = this.retraceVariable(variable, lineNumber, startPosition);
        if (val == null) {
            return variable;
        }
        return val;
    }

    public String resolveString(String variable, int lineNumber, int startPosition) {
        Object object = this.resolveObject(variable, lineNumber, startPosition);
        return this.getAsString(object);
    }

    public String getAsString(Object object) {
        if (this.config.getLegacyOverrides().isUsePyishObjectMapper()) {
            return PyishObjectMapper.getAsUnquotedPyishString(object);
        }
        return Objects.toString(object, "");
    }

    public Context getContext() {
        return this.context;
    }

    public String resolveResourceLocation(String location) {
        return this.application.getResourceLocator().getLocationResolver().map(resolver -> resolver.resolve(location, this)).orElse(location);
    }

    public String getResource(String resource) throws IOException {
        return this.application.getResourceLocator().getString(resource, this.config.getCharset(), this);
    }

    public JinjavaConfig getConfig() {
        return this.config;
    }

    public Object resolveELExpressionSilently(String expression) {
        return this.expressionResolver.resolveExpressionSilently(expression);
    }

    public Object resolveELExpression(String expression, int lineNumber) {
        this.lineNumber = lineNumber;
        return this.expressionResolver.resolveExpression(expression);
    }

    public Object resolveELExpression(String expression, int lineNumber, int position) {
        this.position = position;
        return this.resolveELExpression(expression, lineNumber);
    }

    public Object resolveProperty(Object object, String propertyName) {
        return this.resolveProperty(object, Collections.singletonList(propertyName));
    }

    public Object resolveProperty(Object object, List<String> propertyNames) {
        return this.expressionResolver.resolveProperty(object, propertyNames);
    }

    public Object wrap(Object object) {
        return this.expressionResolver.wrap(object);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void addError(TemplateError templateError) {
        int errorCode;
        if (templateError == null) {
            return;
        }
        if (this.context.getThrowInterpreterErrors()) {
            if (templateError.getSeverity() == TemplateError.ErrorType.FATAL) {
                throw new TemplateSyntaxException(this, templateError.getFieldName(), templateError.getMessage());
            }
            return;
        }
        if (!this.context.getCurrentPathStack().isEmpty()) {
            if (!templateError.getSourceTemplate().isPresent() && this.context.getCurrentPathStack().peek().isPresent()) {
                templateError.setMessage(this.getWrappedErrorMessage(this.context.getCurrentPathStack().peek().get(), templateError));
                templateError.setSourceTemplate(this.context.getCurrentPathStack().peek().get());
            }
            templateError.setStartPosition(this.context.getCurrentPathStack().getTopStartPosition());
            templateError.setLineno(this.context.getCurrentPathStack().getTopLineNumber());
        }
        if (this.errors.size() < 100 && !this.errorSet.contains(errorCode = (templateError = templateError.withScopeDepth(this.scopeDepth)).hashCode())) {
            this.errors.add(templateError);
            this.errorSet.add(errorCode);
        }
    }

    public int getScopeDepth() {
        return this.scopeDepth;
    }

    public void addAllChildErrors(String childTemplateName, Collection<TemplateError> childErrors) {
        if (this.errors.size() >= 100) {
            return;
        }
        childErrors.stream().limit(100 - this.errors.size()).forEach(error -> {
            if (!error.getSourceTemplate().isPresent()) {
                error.setMessage(this.getWrappedErrorMessage(childTemplateName, (TemplateError)error));
                error.setSourceTemplate(childTemplateName);
            }
            error.setStartPosition(this.getPosition());
            error.setLineno(this.getLineNumber());
            this.addError((TemplateError)error);
        });
    }

    public List<TemplateError> getErrors() {
        return this.getErrorsCopy();
    }

    public List<TemplateError> getErrorsCopy() {
        return Lists.newArrayList(this.errors);
    }

    public static JinjavaInterpreter getCurrent() {
        if (CURRENT_INTERPRETER.get().isEmpty()) {
            return null;
        }
        return CURRENT_INTERPRETER.get().peek();
    }

    public static Optional<JinjavaInterpreter> getCurrentMaybe() {
        return Optional.ofNullable(JinjavaInterpreter.getCurrent());
    }

    public static void pushCurrent(JinjavaInterpreter interpreter) {
        CURRENT_INTERPRETER.get().push(interpreter);
    }

    public static void popCurrent() {
        if (!CURRENT_INTERPRETER.get().isEmpty()) {
            CURRENT_INTERPRETER.get().pop();
        }
    }

    private String getWrappedErrorMessage(String childTemplateName, TemplateError templateError) {
        String lineNumber;
        String severity = templateError.getSeverity() == TemplateError.ErrorType.WARNING ? "Warning" : "Error";
        String string = lineNumber = templateError.getLineno() > 0 ? String.format(" on line %d", templateError.getLineno()) : "";
        if (Strings.isNullOrEmpty(templateError.getMessage())) {
            return String.format("Unknown %s in file `%s`%s", severity.toLowerCase(), childTemplateName, lineNumber);
        }
        return String.format("%s in `%s`%s: %s", severity, childTemplateName, lineNumber, templateError.getMessage());
    }

    @Override
    public <T extends Appendable & CharSequence> T appendPyishString(T appendable) throws IOException {
        return (T)appendable.append("____int3rpr3t3r____");
    }

    public class InterpreterScopeClosable
    implements AutoCloseable {
        @Override
        public void close() {
            JinjavaInterpreter.this.leaveScope();
        }
    }
}

