/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava;

import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.el.ExtendedSyntaxBuilder;
import com.hubspot.jinjava.el.TruthyTypeConverter;
import com.hubspot.jinjava.el.ext.eager.EagerExtendedSyntaxBuilder;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.InvalidArgumentException;
import com.hubspot.jinjava.interpret.InvalidInputException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.RenderResult;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.loader.ClasspathResourceLocator;
import com.hubspot.jinjava.loader.ResourceLocator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jinjava.de.odysseus.el.ExpressionFactoryImpl;
import jinjava.de.odysseus.el.tree.TreeBuilder;
import jinjava.javax.el.ExpressionFactory;

public class Jinjava {
    private ExpressionFactory expressionFactory;
    private ExpressionFactory eagerExpressionFactory;
    private ResourceLocator resourceLocator;
    private Context globalContext;
    private JinjavaConfig globalConfig;

    public Jinjava() {
        this(new JinjavaConfig());
    }

    public Jinjava(JinjavaConfig globalConfig) {
        this.globalConfig = globalConfig;
        this.globalContext = new Context();
        Properties expConfig = new Properties();
        expConfig.setProperty(TreeBuilder.class.getName(), ExtendedSyntaxBuilder.class.getName());
        Properties eagerExpConfig = new Properties();
        eagerExpConfig.setProperty(TreeBuilder.class.getName(), EagerExtendedSyntaxBuilder.class.getName());
        eagerExpConfig.setProperty("jinjava.javax.el.cacheSize", "0");
        TruthyTypeConverter converter = new TruthyTypeConverter();
        this.expressionFactory = new ExpressionFactoryImpl(expConfig, converter);
        this.eagerExpressionFactory = new ExpressionFactoryImpl(eagerExpConfig, converter);
        this.resourceLocator = new ClasspathResourceLocator();
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public ExpressionFactory getEagerExpressionFactory() {
        return this.eagerExpressionFactory;
    }

    public Context getGlobalContext() {
        return this.globalContext;
    }

    public ResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    public RenderResult renderForResult(String template, Map<String, ?> bindings) {
        return this.renderForResult(template, bindings, this.globalConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderResult renderForResult(String template, Map<String, ?> bindings, JinjavaConfig renderConfig) {
        Context context;
        JinjavaInterpreter parentInterpreter = JinjavaInterpreter.getCurrent();
        if (parentInterpreter != null) {
            renderConfig = parentInterpreter.getConfig();
            Map<String, Object> bindingsWithParentContext = this.createBindingsWithParentContext(bindings, parentInterpreter.getContext());
            context = new Context(this.copyGlobalContext(), bindingsWithParentContext, renderConfig.getDisabled());
        } else {
            context = new Context(this.copyGlobalContext(), bindings, renderConfig.getDisabled());
        }
        JinjavaInterpreter interpreter = this.globalConfig.getInterpreterFactory().newInstance(this, context, renderConfig);
        JinjavaInterpreter.pushCurrent(interpreter);
        try {
            String result = interpreter.render(template);
            RenderResult renderResult = new RenderResult(result, interpreter.getContext(), interpreter.getErrorsCopy());
            return renderResult;
        }
        catch (InterpretException e) {
            if (e instanceof TemplateSyntaxException) {
                RenderResult renderResult = new RenderResult(TemplateError.fromException((TemplateSyntaxException)e), interpreter.getContext(), interpreter.getErrorsCopy());
                return renderResult;
            }
            RenderResult renderResult = new RenderResult(TemplateError.fromSyntaxError(e), interpreter.getContext(), interpreter.getErrorsCopy());
            return renderResult;
        }
        catch (InvalidArgumentException e) {
            RenderResult renderResult = new RenderResult(TemplateError.fromInvalidArgumentException(e), interpreter.getContext(), interpreter.getErrorsCopy());
            return renderResult;
        }
        catch (InvalidInputException e) {
            RenderResult renderResult = new RenderResult(TemplateError.fromInvalidInputException(e), interpreter.getContext(), interpreter.getErrorsCopy());
            return renderResult;
        }
        catch (Exception e) {
            RenderResult renderResult = new RenderResult(TemplateError.fromException(e), interpreter.getContext(), interpreter.getErrorsCopy());
            return renderResult;
        }
        finally {
            this.globalContext.reset();
            JinjavaInterpreter.popCurrent();
        }
    }

    protected Map<String, Object> createBindingsWithParentContext(Map<String, ?> bindings, Map<String, ?> bindingsFromParentContext) {
        HashMap<String, Object> bindingsWithParentContext = new HashMap<String, Object>(bindings);
        if (bindingsFromParentContext != null) {
            bindingsWithParentContext.putAll(bindingsFromParentContext);
        }
        return bindingsWithParentContext;
    }

    private Context copyGlobalContext() {
        Context context = new Context(null, this.globalContext);
        this.globalContext.getAllExpTests().forEach(context::registerExpTest);
        this.globalContext.getAllFilters().forEach(context::registerFilter);
        this.globalContext.getAllFunctions().forEach(context::registerFunction);
        this.globalContext.getAllTags().forEach(context::registerTag);
        context.setAutoEscape(this.globalContext.isAutoEscape());
        context.setDynamicVariableResolver(this.globalContext.getDynamicVariableResolver());
        return context;
    }
}

