/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ipv6;

import com.googlecode.ipv6.IPv6AddressHelpers;
import com.googlecode.ipv6.IPv6NetworkMask;
import java.io.Serializable;

public final class IPv6Address
implements Serializable,
Comparable<IPv6Address> {
    public static final IPv6Address MAX = IPv6Address.fromString("ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
    private final long highBits;
    private final long lowBits;

    IPv6Address(long highBits, long lowBits) {
        this.highBits = highBits;
        this.lowBits = lowBits;
    }

    public static IPv6Address fromString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("can not parse [null]");
        }
        String withoutIPv4MappedNotation = IPv6AddressHelpers.rewriteIPv4MappedNotation(string);
        String longNotation = IPv6AddressHelpers.expandShortNotation(withoutIPv4MappedNotation);
        long[] longs = IPv6Address.tryParseStringArrayIntoLongArray(string, longNotation);
        IPv6AddressHelpers.validateLongs(longs);
        return IPv6AddressHelpers.mergeLongArrayIntoIPv6Address(longs);
    }

    private static long[] tryParseStringArrayIntoLongArray(String string, String longNotation) {
        try {
            return IPv6AddressHelpers.parseStringArrayIntoLongArray(longNotation.split(":"));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("can not parse [" + string + "]");
        }
    }

    public IPv6Address add(int value) {
        long newLowBits = this.lowBits + (long)value;
        if (value >= 0) {
            if (IPv6AddressHelpers.isLessThanUnsigned(newLowBits, this.lowBits)) {
                return new IPv6Address(this.highBits + 1L, newLowBits);
            }
            return new IPv6Address(this.highBits, newLowBits);
        }
        if (IPv6AddressHelpers.isLessThanUnsigned(this.lowBits, newLowBits)) {
            return new IPv6Address(this.highBits - 1L, newLowBits);
        }
        return new IPv6Address(this.highBits, newLowBits);
    }

    public IPv6Address maskWithNetworkMask(IPv6NetworkMask networkMask) {
        if (networkMask.asPrefixLength() == 128) {
            return this;
        }
        if (networkMask.asPrefixLength() == 64) {
            return new IPv6Address(this.highBits, 0L);
        }
        if (networkMask.asPrefixLength() == 0) {
            return new IPv6Address(0L, 0L);
        }
        if (networkMask.asPrefixLength() > 64) {
            int remainingPrefixLength = networkMask.asPrefixLength() - 64;
            return new IPv6Address(this.highBits, this.lowBits & -1L << 64 - remainingPrefixLength);
        }
        return new IPv6Address(this.highBits & -1L << 64 - networkMask.asPrefixLength(), 0L);
    }

    public IPv6Address maximumAddressWithNetworkMask(IPv6NetworkMask networkMask) {
        if (networkMask.asPrefixLength() == 128) {
            return this;
        }
        if (networkMask.asPrefixLength() == 64) {
            return new IPv6Address(this.highBits, -1L);
        }
        if (networkMask.asPrefixLength() > 64) {
            int remainingPrefixLength = networkMask.asPrefixLength() - 64;
            return new IPv6Address(this.highBits, this.lowBits | -1L >>> remainingPrefixLength);
        }
        return new IPv6Address(this.highBits | -1L >>> networkMask.asPrefixLength(), -1L);
    }

    public boolean isIPv4Mapped() {
        return this.highBits == 0L && (this.lowBits & 0xFFFF000000000000L) == 0L && (this.lowBits & 0xFFFF00000000L) == 0xFFFF00000000L;
    }

    public String toString() {
        if (this.isIPv4Mapped()) {
            return this.toIPv4MappedAddressString();
        }
        return this.toShortHandNotationString();
    }

    private String toIPv4MappedAddressString() {
        int byteZero = (int)((this.lowBits & 0xFF000000L) >> 24);
        int byteOne = (int)((this.lowBits & 0xFF0000L) >> 16);
        int byteTwo = (int)((this.lowBits & 0xFF00L) >> 8);
        int byteThree = (int)(this.lowBits & 0xFFL);
        StringBuilder result = new StringBuilder("::ffff:");
        result.append(byteZero).append(".").append(byteOne).append(".").append(byteTwo).append(".").append(byteThree);
        return result.toString();
    }

    private String toShortHandNotationString() {
        String[] strings = this.toArrayOfShortStrings();
        StringBuilder result = new StringBuilder();
        int[] shortHandNotationPositionAndLength = this.startAndLengthOfLongestRunOfZeroes();
        int shortHandNotationPosition = shortHandNotationPositionAndLength[0];
        int shortHandNotationLength = shortHandNotationPositionAndLength[1];
        boolean useShortHandNotation = shortHandNotationLength > 1;
        for (int i = 0; i < strings.length; ++i) {
            if (useShortHandNotation && i == shortHandNotationPosition) {
                if (i == 0) {
                    result.append("::");
                    continue;
                }
                result.append(":");
                continue;
            }
            if (i > shortHandNotationPosition && i < shortHandNotationPosition + shortHandNotationLength) continue;
            result.append(strings[i]);
            if (i >= 7) continue;
            result.append(":");
        }
        return result.toString().toLowerCase();
    }

    private String[] toArrayOfShortStrings() {
        short[] shorts = this.toShortArray();
        String[] strings = new String[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            strings[i] = String.format("%x", shorts[i]);
        }
        return strings;
    }

    private short[] toShortArray() {
        short[] shorts = new short[8];
        for (int i = 0; i < 8; ++i) {
            shorts[i] = IPv6AddressHelpers.inHighRange(i) ? (short)(this.highBits << i * 16 >>> 112 & 0xFFFFL) : (short)(this.lowBits << i * 16 >>> 112 & 0xFFFFL);
        }
        return shorts;
    }

    int[] startAndLengthOfLongestRunOfZeroes() {
        int longestConsecutiveZeroes = 0;
        int longestConsecutiveZeroesPos = -1;
        short[] shorts = this.toShortArray();
        for (int pos = 0; pos < shorts.length; ++pos) {
            int consecutiveZeroesAtCurrentPos = this.countConsecutiveZeroes(shorts, pos);
            if (consecutiveZeroesAtCurrentPos <= longestConsecutiveZeroes) continue;
            longestConsecutiveZeroes = consecutiveZeroesAtCurrentPos;
            longestConsecutiveZeroesPos = pos;
        }
        return new int[]{longestConsecutiveZeroesPos, longestConsecutiveZeroes};
    }

    private int countConsecutiveZeroes(short[] shorts, int offset) {
        int count = 0;
        for (int i = offset; i < shorts.length && shorts[i] == 0; ++i) {
            ++count;
        }
        return count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPv6Address that = (IPv6Address)o;
        if (this.highBits != that.highBits) {
            return false;
        }
        return this.lowBits == that.lowBits;
    }

    public int hashCode() {
        int result = (int)(this.lowBits ^ this.lowBits >>> 32);
        result = 31 * result + (int)(this.highBits ^ this.highBits >>> 32);
        return result;
    }

    @Override
    public int compareTo(IPv6Address that) {
        if (this.highBits == that.highBits) {
            if (this.lowBits == that.lowBits) {
                return 0;
            }
            return IPv6AddressHelpers.isLessThanUnsigned(this.lowBits, that.lowBits) ? -1 : 1;
        }
        if (this.highBits == that.highBits) {
            return 0;
        }
        return IPv6AddressHelpers.isLessThanUnsigned(this.highBits, that.highBits) ? -1 : 1;
    }
}

