/*
 * Decompiled with CFR 0.152.
 */
package com.google.re2j;

import com.google.re2j.Compiler;
import com.google.re2j.Machine;
import com.google.re2j.MachineInput;
import com.google.re2j.Parser;
import com.google.re2j.PatternSyntaxException;
import com.google.re2j.Prog;
import com.google.re2j.Regexp;
import com.google.re2j.Simplify;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

class RE2 {
    final String expr;
    final Prog prog;
    final int cond;
    final int numSubexp;
    boolean longest;
    String prefix;
    byte[] prefixUTF8;
    boolean prefixComplete;
    int prefixRune;
    private final List<Machine> machine = new ArrayList<Machine>();

    private RE2(String expr, Prog prog, int numSubexp, boolean longest) {
        this.expr = expr;
        this.prog = prog;
        this.numSubexp = numSubexp;
        this.cond = prog.startCond();
        this.longest = longest;
    }

    static RE2 compileImpl(String expr, int mode, boolean longest) throws PatternSyntaxException {
        Regexp re = Parser.parse(expr, mode);
        int maxCap = re.maxCap();
        re = Simplify.simplify(re);
        Prog prog = Compiler.compileRegexp(re);
        RE2 re2 = new RE2(expr, prog, maxCap, longest);
        StringBuilder prefixBuilder = new StringBuilder();
        re2.prefixComplete = prog.prefix(prefixBuilder);
        re2.prefix = prefixBuilder.toString();
        try {
            re2.prefixUTF8 = re2.prefix.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("can't happen");
        }
        if (!re2.prefix.isEmpty()) {
            re2.prefixRune = re2.prefix.codePointAt(0);
        }
        return re2;
    }

    int numberOfCapturingGroups() {
        return this.numSubexp;
    }

    synchronized Machine get() {
        int n = this.machine.size();
        if (n > 0) {
            return this.machine.remove(n - 1);
        }
        return new Machine(this);
    }

    synchronized void put(Machine m) {
        this.machine.add(m);
    }

    public String toString() {
        return this.expr;
    }

    private int[] doExecute(MachineInput in, int pos, int anchor, int ncap) {
        Machine m = this.get();
        m.init(ncap);
        int[] cap = m.match(in, pos, anchor) ? m.submatches() : null;
        this.put(m);
        return cap;
    }

    boolean match(CharSequence input, int start, int end, int anchor, int[] group, int ngroup) {
        if (start > end) {
            return false;
        }
        int[] groupMatch = this.doExecute(MachineInput.fromUTF16(input, 0, end), start, anchor, 2 * ngroup);
        if (groupMatch == null) {
            return false;
        }
        if (group != null) {
            System.arraycopy(groupMatch, 0, group, 0, groupMatch.length);
        }
        return true;
    }
}

