/*
 * Decompiled with CFR 0.152.
 */
package com.google.re2j;

import com.google.re2j.RE2;
import com.google.re2j.Utils;

abstract class MachineInput {
    MachineInput() {
    }

    static MachineInput fromUTF16(CharSequence s, int start, int end) {
        return new UTF16Input(s, start, end);
    }

    abstract int step(int var1);

    abstract boolean canCheckPrefix();

    abstract int index(RE2 var1, int var2);

    abstract int context(int var1);

    abstract int endPos();

    private static class UTF16Input
    extends MachineInput {
        final CharSequence str;
        final int start;
        final int end;

        public UTF16Input(CharSequence str, int start, int end) {
            this.str = str;
            this.start = start;
            this.end = end;
        }

        @Override
        int step(int pos) {
            if ((pos += this.start) < this.end) {
                int rune = Character.codePointAt(this.str, pos);
                int nextPos = pos + Character.charCount(rune);
                int width = nextPos - pos;
                return rune << 3 | width;
            }
            return -8;
        }

        @Override
        boolean canCheckPrefix() {
            return true;
        }

        @Override
        int index(RE2 re2, int pos) {
            int i = this.indexOf(this.str, re2.prefix, pos += this.start);
            return i < 0 ? i : i - pos;
        }

        @Override
        int context(int pos) {
            int r1 = (pos += this.start) > this.start && pos <= this.end ? Character.codePointBefore(this.str, pos) : -1;
            int r2 = pos < this.end ? Character.codePointAt(this.str, pos) : -1;
            return Utils.emptyOpContext(r1, r2);
        }

        @Override
        int endPos() {
            return this.end;
        }

        private int indexOf(CharSequence hayStack, String needle, int pos) {
            if (hayStack instanceof String) {
                return ((String)hayStack).indexOf(needle, pos);
            }
            if (hayStack instanceof StringBuilder) {
                return ((StringBuilder)hayStack).indexOf(needle, pos);
            }
            return this.indexOfFallback(hayStack, needle, pos);
        }

        private int indexOfFallback(CharSequence hayStack, String needle, int fromIndex) {
            if (fromIndex >= hayStack.length()) {
                return needle.isEmpty() ? 0 : -1;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (needle.isEmpty()) {
                return fromIndex;
            }
            char first = needle.charAt(0);
            int max = hayStack.length() - needle.length();
            for (int i = fromIndex; i <= max; ++i) {
                if (hayStack.charAt(i) != first) {
                    while (++i <= max && hayStack.charAt(i) != first) {
                    }
                }
                if (i > max) continue;
                int j = i + 1;
                int end = j + needle.length() - 1;
                int k = 1;
                while (j < end && hayStack.charAt(j) == needle.charAt(k)) {
                    ++j;
                    ++k;
                }
                if (j != end) continue;
                return i;
            }
            return -1;
        }
    }
}

