/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.safetensors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tjake.jlama.safetensors.DType;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Objects;

public class TensorInfo
implements Comparable<TensorInfo> {
    @JsonProperty(value="dtype")
    public final DType dType;
    @JsonProperty(value="shape")
    public final int[] shape;
    @JsonProperty(value="data_offsets")
    public final long[] dataOffsets;

    @JsonCreator
    public TensorInfo(@JsonProperty(value="dtype") DType dType, @JsonProperty(value="shape") long[] shape, @JsonProperty(value="data_offsets") long[] dataOffsets) {
        this.dType = dType;
        this.shape = new int[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            this.shape[i] = Ints.checkedCast(shape[i]);
        }
        this.dataOffsets = dataOffsets;
    }

    public String toString() {
        return "TensorInfo{dType=" + String.valueOf((Object)this.dType) + ", shape=" + Arrays.toString(this.shape) + ", dataOffsets=" + Arrays.toString(this.dataOffsets) + "}";
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TensorInfo)) {
            return false;
        }
        TensorInfo that = (TensorInfo)o;
        return this.dType == that.dType && Arrays.equals(this.shape, that.shape) && Arrays.equals(this.dataOffsets, that.dataOffsets);
    }

    public int hashCode() {
        int result = Objects.hashCode((Object)this.dType);
        result = 31 * result + Arrays.hashCode(this.shape);
        result = 31 * result + Arrays.hashCode(this.dataOffsets);
        return result;
    }

    @Override
    public int compareTo(TensorInfo o) {
        return Long.compare(this.dataOffsets[0], o.dataOffsets[0]);
    }
}

