/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.model.mixtral;

import com.github.tjake.jlama.model.AbstractModel;
import com.github.tjake.jlama.model.CausalSelfAttention;
import com.github.tjake.jlama.model.MoEBlock;
import com.github.tjake.jlama.model.ModelSupport;
import com.github.tjake.jlama.model.RMSNorm;
import com.github.tjake.jlama.model.TransformerBlock;
import com.github.tjake.jlama.model.mistral.MistralModel;
import com.github.tjake.jlama.model.mixtral.MixtralConfig;
import com.github.tjake.jlama.safetensors.Config;
import com.github.tjake.jlama.safetensors.DType;
import com.github.tjake.jlama.safetensors.WeightLoader;
import com.github.tjake.jlama.safetensors.tokenizer.Tokenizer;
import com.github.tjake.jlama.tensor.AbstractTensor;
import java.util.Optional;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixtralModel
extends MistralModel {
    private static final Logger logger = LoggerFactory.getLogger(MixtralModel.class);

    public MixtralModel(Config config, WeightLoader weights, Tokenizer tokenizer, DType workingDType, DType workingQType, Optional<DType> modelQType) {
        super(AbstractModel.InferenceType.FULL_GENERATION, config, weights, tokenizer, workingDType, workingQType, modelQType);
    }

    public MixtralModel(AbstractModel.InferenceType inferenceType, Config config, WeightLoader weights, Tokenizer tokenizer, DType workingDType, DType workingQType, Optional<DType> modelQType) {
        super(inferenceType, config, weights, tokenizer, workingDType, workingQType, modelQType);
    }

    @Override
    public ModelSupport.ModelType getModelType() {
        return ModelSupport.ModelType.MIXTRAL;
    }

    @Override
    protected TransformerBlock[] loadTransformerBlockWeights() {
        MixtralConfig mixtralConfig = (MixtralConfig)this.c;
        DType qType = this.modelQType.orElse(this.modelDType);
        if (qType != this.modelDType) {
            logger.info("Quantizing model with {} - Please hold...", (Object)qType);
        }
        TransformerBlock[] transformerBlocks = new TransformerBlock[this.c.dctx().numberOfLayers];
        IntStream.range(this.c.dctx().layerStart, this.c.dctx().layerEnd).parallel().forEach(i -> {
            String base = "model.layers." + i + ".";
            String prefix = base + "self_attn.";
            CausalSelfAttention attention = new CausalSelfAttention(this, i, this.weights.load(prefix + "q_proj.weight", this.c.dctx(), true, false).quantize(qType), this.weights.load(prefix + "k_proj.weight", this.c.dctx(), true, false).quantize(qType), this.weights.load(prefix + "v_proj.weight", this.c.dctx(), true, false).quantize(qType), this.weights.load(prefix + "o_proj.weight").quantize(qType));
            prefix = base + "block_sparse_moe.";
            AbstractTensor[] expertGateWeights = new AbstractTensor[mixtralConfig.numberOfExperts];
            AbstractTensor[] expertDownWeights = new AbstractTensor[mixtralConfig.numberOfExperts];
            AbstractTensor[] expertUpWeights = new AbstractTensor[mixtralConfig.numberOfExperts];
            for (int e = 0; e < mixtralConfig.numberOfExperts; ++e) {
                String expertPrefix = prefix + "experts." + e + ".";
                expertGateWeights[e] = this.weights.load(expertPrefix + "w1.weight", this.c.dctx(), true, false).quantize(qType);
                expertDownWeights[e] = this.weights.load(expertPrefix + "w2.weight").quantize(qType);
                expertUpWeights[e] = this.weights.load(expertPrefix + "w3.weight", this.c.dctx(), true, false).quantize(qType);
            }
            MoEBlock moe = new MoEBlock(this, mixtralConfig.numberOfExperts, mixtralConfig.numberOfExpertsPerToken, this.c.activationFunction, this.weights.load(prefix + "gate.weight").quantize(qType), expertGateWeights, expertDownWeights, expertUpWeights);
            transformerBlocks[i] = new TransformerBlock((AbstractModel)this, i, new RMSNorm(this, this.weights.load(base + "input_layernorm.weight").quantize(qType)), attention, new RMSNorm(this, this.weights.load(base + "post_attention_layernorm.weight").quantize(qType)), moe);
        });
        return transformerBlocks;
    }
}

