/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.EnumNamingStrategy;
import com.fasterxml.jackson.databind.cfg.EnumFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;

public final class EnumValues
implements Serializable {
    private final Class<Enum<?>> _enumClass;
    private final Enum<?>[] _values;
    private final SerializableString[] _textual;

    private EnumValues(Class<Enum<?>> enumClass, SerializableString[] textual) {
        this._enumClass = enumClass;
        this._values = enumClass.getEnumConstants();
        this._textual = textual;
    }

    public static EnumValues constructFromName(MapperConfig<?> config, AnnotatedClass annotatedClass) {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        boolean useLowerCase = config.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Class<?> enumCls0 = annotatedClass.getRawType();
        Class<Enum<?>> enumCls = EnumValues._enumClass(enumCls0);
        Enum<?>[] enumConstants = EnumValues._enumConstants(enumCls0);
        String[] names = ai.findEnumValues(config, annotatedClass, enumConstants, new String[enumConstants.length]);
        SerializableString[] textual = new SerializableString[enumConstants.length];
        int len = enumConstants.length;
        for (int i = 0; i < len; ++i) {
            Enum<?> enumValue = enumConstants[i];
            String name = EnumValues._findNameToUse(names[i], enumValue.name(), useLowerCase);
            textual[enumValue.ordinal()] = config.compileString(name);
        }
        return EnumValues.construct(enumCls, textual);
    }

    public static EnumValues constructFromToString(MapperConfig<?> config, AnnotatedClass annotatedClass) {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        boolean useLowerCase = config.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Class<?> enumCls0 = annotatedClass.getRawType();
        Class<Enum<?>> enumCls = EnumValues._enumClass(enumCls0);
        Enum<?>[] enumConstants = EnumValues._enumConstants(enumCls0);
        String[] names = new String[enumConstants.length];
        if (ai != null) {
            ai.findEnumValues(config, annotatedClass, enumConstants, names);
        }
        SerializableString[] textual = new SerializableString[enumConstants.length];
        for (int i = 0; i < enumConstants.length; ++i) {
            String enumToString = enumConstants[i].toString();
            enumToString = enumToString == null ? "" : enumToString;
            String name = EnumValues._findNameToUse(names[i], enumToString, useLowerCase);
            textual[i] = config.compileString(name);
        }
        return EnumValues.construct(enumCls, textual);
    }

    public static EnumValues constructUsingEnumNamingStrategy(MapperConfig<?> config, AnnotatedClass annotatedClass, EnumNamingStrategy namingStrategy) {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        boolean useLowerCase = config.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Class<?> enumCls0 = annotatedClass.getRawType();
        Class<Enum<?>> enumCls = EnumValues._enumClass(enumCls0);
        Enum<?>[] enumConstants = EnumValues._enumConstants(enumCls0);
        String[] names = new String[enumConstants.length];
        if (ai != null) {
            ai.findEnumValues(config, annotatedClass, enumConstants, names);
        }
        SerializableString[] textual = new SerializableString[enumConstants.length];
        int len = enumConstants.length;
        for (int i = 0; i < len; ++i) {
            Enum<?> enumValue = enumConstants[i];
            String name = EnumValues._findNameToUse(names[i], namingStrategy.convertEnumToExternalName(enumValue.name()), useLowerCase);
            textual[i] = config.compileString(name);
        }
        return EnumValues.construct(enumCls, textual);
    }

    public static EnumValues construct(Class<Enum<?>> enumClass, SerializableString[] externalValues) {
        return new EnumValues(enumClass, externalValues);
    }

    protected static Class<Enum<?>> _enumClass(Class<?> enumCls0) {
        return enumCls0;
    }

    protected static Enum<?>[] _enumConstants(Class<?> enumCls) {
        Enum<?>[] enumValues = ClassUtil.findEnumType(enumCls).getEnumConstants();
        if (enumValues == null) {
            throw new IllegalArgumentException("No enum constants for class " + enumCls.getName());
        }
        return enumValues;
    }

    protected static String _findNameToUse(String explicitName, String otherName, boolean toLowerCase) {
        if (explicitName != null) {
            return explicitName;
        }
        if (toLowerCase) {
            return otherName.toLowerCase();
        }
        return otherName;
    }

    public SerializableString serializedValueFor(Enum<?> key) {
        return this._textual[key.ordinal()];
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }
}

