/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class BeanUtil {
    public static Object getDefaultValue(JavaType type) {
        Class<?> cls = type.getRawClass();
        Class<?> prim = ClassUtil.primitiveType(cls);
        if (prim != null) {
            return ClassUtil.defaultValue(prim);
        }
        if (type.isContainerType() || type.isReferenceType()) {
            return JsonInclude.Include.NON_EMPTY;
        }
        if (cls == String.class) {
            return "";
        }
        if (type.isTypeOrSubTypeOf(Date.class)) {
            return new Date(0L);
        }
        if (type.isTypeOrSubTypeOf(Calendar.class)) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTimeInMillis(0L);
            return c;
        }
        return null;
    }

    public static String checkUnsupportedType(MapperConfig<?> config, JavaType type) {
        String moduleName;
        String typeName;
        boolean fail;
        String className = type.getRawClass().getName();
        MapperFeature failFeature = null;
        if (BeanUtil.isJava8TimeClass(className)) {
            if (className.indexOf(46, 10) >= 0) {
                return null;
            }
            if (type.isTypeOrSubTypeOf(Throwable.class)) {
                return null;
            }
            failFeature = MapperFeature.REQUIRE_HANDLERS_FOR_JAVA8_TIMES;
            boolean bl = fail = config == null || config.isEnabled(failFeature);
            if (!fail) {
                return null;
            }
            typeName = "Java 8 date/time";
            moduleName = "com.fasterxml.jackson.datatype:jackson-datatype-jsr310";
        } else if (BeanUtil.isJodaTimeClass(className)) {
            typeName = "Joda date/time";
            moduleName = "com.fasterxml.jackson.datatype:jackson-datatype-joda";
        } else if (BeanUtil.isJava8OptionalClass(className)) {
            failFeature = MapperFeature.REQUIRE_HANDLERS_FOR_JAVA8_OPTIONALS;
            boolean bl = fail = config == null || config.isEnabled(failFeature);
            if (!fail) {
                return null;
            }
            typeName = "Java 8 optional";
            moduleName = "com.fasterxml.jackson.datatype:jackson-datatype-jdk8";
        } else {
            return null;
        }
        String str = String.format("%s type %s not supported by default: add Module \"%s\" to enable handling", typeName, ClassUtil.getTypeDescription(type), moduleName);
        if (failFeature != null) {
            str = String.format("%s (or disable `MapperFeature.%s`)", str, failFeature.name());
        }
        return str;
    }

    private static boolean isJava8TimeClass(String className) {
        return className.startsWith("java.time.");
    }

    private static boolean isJava8OptionalClass(String className) {
        return className.startsWith("java.util.Optional");
    }

    private static boolean isJodaTimeClass(String className) {
        return className.startsWith("org.joda.time.");
    }
}

