/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.InternalNodeMapper;
import com.fasterxml.jackson.databind.util.ExceptionUtil;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class BaseJsonNode
extends JsonNode
implements Serializable {
    protected BaseJsonNode() {
    }

    @Override
    public JsonParser.NumberType numberType() {
        return null;
    }

    @Override
    public abstract void serialize(JsonGenerator var1, SerializerProvider var2) throws IOException;

    public String toString() {
        return InternalNodeMapper.nodeToString(this);
    }

    protected BigInteger _bigIntFromBigDec(BigDecimal value) {
        try {
            StreamReadConstraints.defaults().validateBigIntegerScale(value.scale());
        }
        catch (StreamConstraintsException e) {
            ExceptionUtil.throwSneaky(e);
        }
        return value.toBigInteger();
    }
}

