/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jdk14;

import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.PotentialCreator;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.NativeImageUtil;
import java.lang.reflect.Method;
import java.util.List;

public class JDK14Util {
    public static String[] getRecordFieldNames(Class<?> recordType) {
        return RecordAccessor.instance().getRecordFieldNames(recordType);
    }

    public static PotentialCreator findCanonicalRecordConstructor(MapperConfig<?> config, AnnotatedClass recordClass, List<PotentialCreator> constructors) {
        AnnotatedConstructor defCtor;
        RawTypeName[] recordFields = RecordAccessor.instance().getRecordFields(recordClass.getRawType());
        if (recordFields == null) {
            return null;
        }
        int argCount = recordFields.length;
        if (argCount == 0 && (defCtor = recordClass.getDefaultConstructor()) != null) {
            return new PotentialCreator(defCtor, null);
        }
        block0: for (PotentialCreator ctor : constructors) {
            if (ctor.paramCount() != argCount) continue;
            for (int i = 0; i < argCount; ++i) {
                if (!ctor.creator().getRawParameterType(i).equals(recordFields[i].rawType)) continue block0;
            }
            PropertyName[] implicits = new PropertyName[argCount];
            for (int i = 0; i < argCount; ++i) {
                implicits[i] = PropertyName.construct(recordFields[i].name);
            }
            return ctor.introspectParamNames(config, implicits);
        }
        throw new IllegalArgumentException("Failed to find the canonical Record constructor of type " + ClassUtil.getTypeDescription(recordClass.getType()));
    }

    static class RawTypeName {
        public final Class<?> rawType;
        public final String name;

        public RawTypeName(Class<?> rt, String n) {
            this.rawType = rt;
            this.name = n;
        }
    }

    static class RecordAccessor {
        private final Method RECORD_GET_RECORD_COMPONENTS;
        private final Method RECORD_COMPONENT_GET_NAME;
        private final Method RECORD_COMPONENT_GET_TYPE;
        private static final RecordAccessor INSTANCE;
        private static final RuntimeException PROBLEM;

        private RecordAccessor() throws RuntimeException {
            try {
                this.RECORD_GET_RECORD_COMPONENTS = Class.class.getMethod("getRecordComponents", new Class[0]);
                Class<?> c = Class.forName("java.lang.reflect.RecordComponent");
                this.RECORD_COMPONENT_GET_NAME = c.getMethod("getName", new Class[0]);
                this.RECORD_COMPONENT_GET_TYPE = c.getMethod("getType", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to access Methods needed to support `java.lang.Record`: (%s) %s", e.getClass().getName(), e.getMessage()), e);
            }
        }

        public static RecordAccessor instance() {
            if (PROBLEM != null) {
                throw PROBLEM;
            }
            return INSTANCE;
        }

        public String[] getRecordFieldNames(Class<?> recordType) throws IllegalArgumentException {
            Object[] components = this.recordComponents(recordType);
            if (components == null) {
                return null;
            }
            String[] names = new String[components.length];
            for (int i = 0; i < components.length; ++i) {
                try {
                    names[i] = (String)this.RECORD_COMPONENT_GET_NAME.invoke(components[i], new Object[0]);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Failed to access name of field #%d (of %d) of Record type %s", i, components.length, ClassUtil.nameOf(recordType)), e);
                }
            }
            return names;
        }

        public RawTypeName[] getRecordFields(Class<?> recordType) throws IllegalArgumentException {
            Object[] components = this.recordComponents(recordType);
            if (components == null) {
                return null;
            }
            RawTypeName[] results = new RawTypeName[components.length];
            for (int i = 0; i < components.length; ++i) {
                Class type;
                String name;
                try {
                    name = (String)this.RECORD_COMPONENT_GET_NAME.invoke(components[i], new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Failed to access name of field #%d (of %d) of Record type %s", i, components.length, ClassUtil.nameOf(recordType)), e);
                }
                try {
                    type = (Class)this.RECORD_COMPONENT_GET_TYPE.invoke(components[i], new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Failed to access type of field #%d (of %d) of Record type %s", i, components.length, ClassUtil.nameOf(recordType)), e);
                }
                results[i] = new RawTypeName(type, name);
            }
            return results;
        }

        protected Object[] recordComponents(Class<?> recordType) throws IllegalArgumentException {
            try {
                return (Object[])this.RECORD_GET_RECORD_COMPONENTS.invoke(recordType, new Object[0]);
            }
            catch (Exception e) {
                if (NativeImageUtil.isUnsupportedFeatureError(e)) {
                    return null;
                }
                throw new IllegalArgumentException("Failed to access RecordComponents of type " + ClassUtil.nameOf(recordType));
            }
        }

        static {
            RuntimeException prob = null;
            RecordAccessor inst = null;
            try {
                inst = new RecordAccessor();
            }
            catch (RuntimeException e) {
                prob = e;
            }
            INSTANCE = inst;
            PROBLEM = prob;
        }
    }
}

