/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class JsonNode
extends JsonSerializable.Base
implements TreeNode,
Iterable<JsonNode> {
    protected JsonNode() {
    }

    public int size() {
        return 0;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public JsonNode get(String fieldName) {
        return null;
    }

    public abstract JsonNode path(String var1);

    public abstract JsonNodeType getNodeType();

    public final boolean isPojo() {
        return this.getNodeType() == JsonNodeType.POJO;
    }

    public final boolean isNumber() {
        return this.getNodeType() == JsonNodeType.NUMBER;
    }

    public final boolean isTextual() {
        return this.getNodeType() == JsonNodeType.STRING;
    }

    public final boolean isNull() {
        return this.getNodeType() == JsonNodeType.NULL;
    }

    public final boolean isBinary() {
        return this.getNodeType() == JsonNodeType.BINARY;
    }

    public boolean canConvertToInt() {
        return false;
    }

    public boolean canConvertToLong() {
        return false;
    }

    public String textValue() {
        return null;
    }

    public byte[] binaryValue() throws IOException {
        return null;
    }

    public Number numberValue() {
        return null;
    }

    public int intValue() {
        return 0;
    }

    public long longValue() {
        return 0L;
    }

    public double doubleValue() {
        return 0.0;
    }

    public BigDecimal decimalValue() {
        return BigDecimal.ZERO;
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.ZERO;
    }

    public abstract String asText();

    public int asInt() {
        return this.asInt(0);
    }

    public int asInt(int defaultValue) {
        return defaultValue;
    }

    public boolean asBoolean() {
        return this.asBoolean(false);
    }

    public boolean asBoolean(boolean defaultValue) {
        return defaultValue;
    }

    public boolean has(String fieldName) {
        return this.get(fieldName) != null;
    }

    @Override
    public final Iterator<JsonNode> iterator() {
        return this.elements();
    }

    public Iterator<JsonNode> elements() {
        return ClassUtil.emptyIterator();
    }

    @Deprecated
    public Iterator<Map.Entry<String, JsonNode>> fields() {
        return ClassUtil.emptyIterator();
    }

    public Set<Map.Entry<String, JsonNode>> properties() {
        return Collections.emptySet();
    }
}

