/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class BitwiseConditionalExpressionCleanupCore
extends AbstractMultiFix {
    public BitwiseConditionalExpressionCleanupCore() {
        this(Collections.emptyMap());
    }

    public BitwiseConditionalExpressionCleanupCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.bitwise_conditional_expression");
        Map<String, String> requiredOptions = null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.bitwise_conditional_expression")) {
            return new String[]{MultiFixMessages.CheckSignOfBitwiseOperation_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.bitwise_conditional_expression")) {
            return "if (value & CONSTANT != 0) {}\n";
        }
        return "if (value & CONSTANT > 0) {}\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.bitwise_conditional_expression")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(InfixExpression node) {
                if (!node.hasExtendedOperands() && (node.getOperator() == InfixExpression.Operator.GREATER && this.isBitwiseExpression(node.getLeftOperand()) && Long.valueOf(0L).equals(ASTNodes.getIntegerLiteral(node.getRightOperand())) || node.getOperator() == InfixExpression.Operator.LESS && this.isBitwiseExpression(node.getRightOperand()) && Long.valueOf(0L).equals(ASTNodes.getIntegerLiteral(node.getLeftOperand())))) {
                    rewriteOperations.add(new RewriteInfixExpressionOperator(node));
                    return false;
                }
                return true;
            }

            private boolean isBitwiseExpression(Expression bitwiseExpression) {
                if (bitwiseExpression instanceof ParenthesizedExpression) {
                    return this.isBitwiseExpression(((ParenthesizedExpression)bitwiseExpression).getExpression());
                }
                if (!(bitwiseExpression instanceof InfixExpression)) {
                    return false;
                }
                final AtomicBoolean result = new AtomicBoolean(false);
                try {
                    bitwiseExpression.accept(new ASTVisitor(){

                        public boolean visit(InfixExpression node) {
                            if (!ASTNodes.hasOperator(node, InfixExpression.Operator.AND, InfixExpression.Operator.OR, InfixExpression.Operator.XOR)) {
                                result.set(false);
                                throw new AbortSearchException();
                            }
                            result.set(true);
                            return false;
                        }
                    });
                }
                catch (AbortSearchException e) {
                    return false;
                }
                return result.get();
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.CheckSignOfBitwiseOperation_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class RewriteInfixExpressionOperator
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private InfixExpression fExpression;

        public RewriteInfixExpressionOperator(InfixExpression expression) {
            this.fExpression = expression;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.CheckSignOfBitwiseOperation_description, cuRewrite);
            InfixExpression newInfixExpression = ast.newInfixExpression();
            newInfixExpression.setOperator(InfixExpression.Operator.NOT_EQUALS);
            newInfixExpression.setLeftOperand(ASTNodes.createMoveTarget(rewrite, this.fExpression.getLeftOperand()));
            newInfixExpression.setRightOperand(ASTNodes.createMoveTarget(rewrite, this.fExpression.getRightOperand()));
            newInfixExpression.setFlags(this.fExpression.getFlags());
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.fExpression, (ASTNode)newInfixExpression, group);
        }
    }
}

