/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.encoding.utf8;

import io.matthewnelson.encoding.core.Decoder;
import io.matthewnelson.encoding.core.Encoder;
import io.matthewnelson.encoding.core.EncoderDecoder;
import io.matthewnelson.encoding.core.MalformedEncodingException;
import io.matthewnelson.encoding.core.util.DecoderInput;
import io.matthewnelson.encoding.utf8.UTF8;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CharIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\b\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017B\u000f\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0004J\u001a\u0010\u0007\u001a\f0\bR\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u001a\u0010\f\u001a\f0\rR\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000fH\u0004\u00a8\u0006\u0018"}, d2={"Lio/matthewnelson/encoding/utf8/UTF8;", "Lio/matthewnelson/encoding/core/EncoderDecoder;", "Lio/matthewnelson/encoding/utf8/UTF8$Config;", "config", "(Lio/matthewnelson/encoding/utf8/UTF8$Config;)V", "name", "", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "Builder", "CharPreProcessor", "Config", "DecoderFeed", "Default", "EncoderFeed", "ReplacementStrategy", "ThrowOnInvalid", "io.matthewnelson.encoding_utf8_jvm"})
public class UTF8
extends EncoderDecoder<Config> {
    @NotNull
    public static final Default Default = new Default(null);
    @NotNull
    private static final String NAME = "UTF-8";

    @NotNull
    protected final String name() {
        return NAME;
    }

    @NotNull
    protected final Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
        Decoder.Feed feed;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int n = ((Config)this.getConfig()).replacementStrategy.size;
        if (n == ReplacementStrategy.U_003F.size) {
            feed = new DecoderFeed(this, out){

                protected void outputReplacementSequence(Decoder.OutFeed $this$outputReplacementSequence) {
                    Intrinsics.checkNotNullParameter((Object)$this$outputReplacementSequence, (String)"<this>");
                    $this$outputReplacementSequence.output((byte)63);
                }
            };
        } else if (n == ReplacementStrategy.U_FFFD.size) {
            feed = new DecoderFeed(this, out){

                protected void outputReplacementSequence(Decoder.OutFeed $this$outputReplacementSequence) {
                    Intrinsics.checkNotNullParameter((Object)$this$outputReplacementSequence, (String)"<this>");
                    $this$outputReplacementSequence.output((byte)-17);
                    $this$outputReplacementSequence.output((byte)-65);
                    $this$outputReplacementSequence.output((byte)-67);
                }
            };
        } else if (n == ReplacementStrategy.THROW.size) {
            feed = new DecoderFeed(this, out){

                protected void outputReplacementSequence(Decoder.OutFeed $this$outputReplacementSequence) {
                    Intrinsics.checkNotNullParameter((Object)$this$outputReplacementSequence, (String)"<this>");
                    throw new MalformedEncodingException("Malformed UTF-8 character sequence");
                }
            };
        } else {
            throw new IllegalStateException(("Unknown " + ((Config)this.getConfig()).replacementStrategy + ".size[" + ((Config)this.getConfig()).replacementStrategy.size + ']').toString());
        }
        return feed;
    }

    @NotNull
    protected final Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        return ((Config)this.getConfig()).replacementStrategy.size == ReplacementStrategy.THROW.size ? (Encoder.Feed)new EncoderFeed(this, out){

            protected void outputReplacementChar(Encoder.OutFeed $this$outputReplacementChar) {
                Intrinsics.checkNotNullParameter((Object)$this$outputReplacementChar, (String)"<this>");
                throw new MalformedEncodingException("Malformed UTF-8 character sequence");
            }
        } : (Encoder.Feed)new EncoderFeed(out);
    }

    private UTF8(Config config) {
        super((EncoderDecoder.Config)config);
    }

    @JvmStatic
    @JvmName(name="-Builder")
    @NotNull
    public static final UTF8 -Builder(@NotNull Function1<? super Builder, Unit> block) {
        return Default.-Builder(block);
    }

    @JvmStatic
    @JvmName(name="-Builder")
    @NotNull
    public static final UTF8 -Builder(@Nullable Config other, @NotNull Function1<? super Builder, Unit> block) {
        return Default.-Builder(other, block);
    }

    public /* synthetic */ UTF8(Config config, DefaultConstructorMarker $constructor_marker) {
        this(config);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u000bR \u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078@@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b8@@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lio/matthewnelson/encoding/utf8/UTF8$Builder;", "", "()V", "other", "Lio/matthewnelson/encoding/utf8/UTF8$Config;", "(Lio/matthewnelson/encoding/utf8/UTF8$Config;)V", "<set-?>", "", "_backFillBuffers", "get_backFillBuffers$io_matthewnelson_encoding_utf8_jvm", "()Z", "Lio/matthewnelson/encoding/utf8/UTF8$ReplacementStrategy;", "_replacementStrategy", "get_replacementStrategy$io_matthewnelson_encoding_utf8_jvm", "()Lio/matthewnelson/encoding/utf8/UTF8$ReplacementStrategy;", "backFillBuffers", "enable", "build", "Lio/matthewnelson/encoding/utf8/UTF8;", "replacement", "strategy", "io.matthewnelson.encoding_utf8_jvm"})
    @SourceDebugExtension(value={"SMAP\nUTF8.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UTF8.kt\nio/matthewnelson/encoding/utf8/UTF8$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1101:1\n1#2:1102\n*E\n"})
    public static final class Builder {
        @NotNull
        private ReplacementStrategy _replacementStrategy = ReplacementStrategy.KOTLIN;
        private boolean _backFillBuffers = true;

        public Builder() {
            this(null);
        }

        public Builder(@Nullable Config other) {
            if (other == null) {
                return;
            }
            this._replacementStrategy = other.replacementStrategy;
            this._backFillBuffers = other.backFillBuffers;
        }

        public final /* synthetic */ ReplacementStrategy get_replacementStrategy$io_matthewnelson_encoding_utf8_jvm() {
            return this._replacementStrategy;
        }

        public final /* synthetic */ boolean get_backFillBuffers$io_matthewnelson_encoding_utf8_jvm() {
            return this._backFillBuffers;
        }

        @NotNull
        public final Builder replacement(@NotNull ReplacementStrategy strategy) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
            Builder $this$replacement_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$replacement_u24lambda_u240._replacementStrategy = strategy;
            return builder;
        }

        @NotNull
        public final Builder backFillBuffers(boolean enable) {
            Builder builder;
            Builder $this$backFillBuffers_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$backFillBuffers_u24lambda_u240._backFillBuffers = enable;
            return builder;
        }

        @NotNull
        public final UTF8 build() {
            return Config.Companion.build$io_matthewnelson_encoding_utf8_jvm(this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\bJ\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\r\u0010\u0014\u001a\u00020\u0006*\u00020\u0013H\u0082\bR\u0012\u0010\u0005\u001a\u00020\u00068\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8G@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/matthewnelson/encoding/utf8/UTF8$CharPreProcessor;", "", "strategy", "Lio/matthewnelson/encoding/utf8/UTF8$ReplacementStrategy;", "(Lio/matthewnelson/encoding/utf8/UTF8$ReplacementStrategy;)V", "checkNext", "", "<set-?>", "", "currentSize", "()J", "setCurrentSize", "(J)V", "doFinal", "plus", "", "input", "", "replacementSize", "", "process", "Companion", "io.matthewnelson.encoding_utf8_jvm"})
    @SourceDebugExtension(value={"SMAP\nUTF8.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UTF8.kt\nio/matthewnelson/encoding/utf8/UTF8$CharPreProcessor\n*L\n1#1,1101:1\n500#1,17:1102\n500#1,17:1119\n*S KotlinDebug\n*F\n+ 1 UTF8.kt\nio/matthewnelson/encoding/utf8/UTF8$CharPreProcessor\n*L\n462#1:1102,17\n469#1:1119,17\n*E\n"})
    public static class CharPreProcessor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final ReplacementStrategy strategy;
        private long currentSize;
        @JvmField
        protected boolean checkNext;

        private CharPreProcessor(ReplacementStrategy strategy) {
            this.strategy = strategy;
        }

        @JvmName(name="currentSize")
        public final long currentSize() {
            return this.currentSize;
        }

        protected final void setCurrentSize(long l) {
            this.currentSize = l;
        }

        /*
         * WARNING - void declaration
         */
        public final void plus(char input) {
            char c = input;
            if (!this.checkNext) {
                boolean bl;
                void this_$iv;
                CharPreProcessor charPreProcessor = this;
                char $this$process$iv = c;
                boolean $i$f$process = false;
                if ($this$process$iv < '\u0080') {
                    ++this_$iv.currentSize;
                    bl = true;
                } else if ($this$process$iv < '\u0800') {
                    this_$iv.currentSize += 2L;
                    bl = true;
                } else if ($this$process$iv < '\ud800' || $this$process$iv > '\udfff') {
                    this_$iv.currentSize += 3L;
                    bl = true;
                } else if ($this$process$iv > '\udbff') {
                    this_$iv.currentSize += (long)this_$iv.replacementSize();
                    bl = true;
                } else {
                    bl = false;
                }
                if (bl) {
                    return;
                }
                this.checkNext = true;
                return;
            }
            if (c < '\udc00' || c > '\udfff') {
                boolean bl;
                this.currentSize += (long)this.replacementSize();
                CharPreProcessor this_$iv = this;
                char $this$process$iv = c;
                boolean $i$f$process = false;
                if ($this$process$iv < '\u0080') {
                    ++this_$iv.currentSize;
                    bl = true;
                } else if ($this$process$iv < '\u0800') {
                    this_$iv.currentSize += 2L;
                    bl = true;
                } else if ($this$process$iv < '\ud800' || $this$process$iv > '\udfff') {
                    this_$iv.currentSize += 3L;
                    bl = true;
                } else if ($this$process$iv > '\udbff') {
                    this_$iv.currentSize += (long)this_$iv.replacementSize();
                    bl = true;
                } else {
                    bl = false;
                }
                if (bl) {
                    this.checkNext = false;
                    return;
                }
                return;
            }
            this.checkNext = false;
            this.currentSize += 4L;
        }

        public final long doFinal() {
            long s = this.currentSize;
            this.currentSize = 0L;
            if (!this.checkNext) {
                return s;
            }
            this.checkNext = false;
            return s + (long)this.replacementSize();
        }

        protected int replacementSize() throws MalformedEncodingException {
            return this.strategy.size;
        }

        private final boolean process(int $this$process) {
            boolean $i$f$process = false;
            if ($this$process < 128) {
                ++this.currentSize;
                return true;
            }
            if ($this$process < 2048) {
                this.currentSize += 2L;
                return true;
            }
            if ($this$process < 55296 || $this$process > 57343) {
                this.currentSize += 3L;
                return true;
            }
            if ($this$process > 56319) {
                this.currentSize += (long)this.replacementSize();
                return true;
            }
            return false;
        }

        @JvmStatic
        @NotNull
        public static final CharPreProcessor of(@NotNull UTF8 utf8) {
            return Companion.of(utf8);
        }

        @JvmStatic
        @NotNull
        public static final CharPreProcessor of(@NotNull Config config) {
            return Companion.of(config);
        }

        @JvmStatic
        @NotNull
        public static final CharPreProcessor of(@NotNull ReplacementStrategy strategy) {
            return Companion.of(strategy);
        }

        @JvmStatic
        @JvmName(name="sizeOf")
        public static final long sizeOf(@NotNull char[] $this$sizeOf, @NotNull UTF8 utf8) {
            return Companion.sizeOf($this$sizeOf, utf8);
        }

        @JvmStatic
        @JvmName(name="sizeOf")
        public static final long sizeOf(@NotNull char[] $this$sizeOf, @NotNull Config config) {
            return Companion.sizeOf($this$sizeOf, config);
        }

        @JvmStatic
        @JvmName(name="sizeOf")
        public static final long sizeOf(@NotNull char[] $this$sizeOf, @NotNull ReplacementStrategy strategy) {
            return Companion.sizeOf($this$sizeOf, strategy);
        }

        @JvmStatic
        @JvmName(name="sizeOf")
        public static final long sizeOf(@NotNull CharSequence $this$sizeOf, @NotNull UTF8 utf8) {
            return Companion.sizeOf($this$sizeOf, utf8);
        }

        @JvmStatic
        @JvmName(name="sizeOf")
        public static final long sizeOf(@NotNull CharSequence $this$sizeOf, @NotNull Config config) {
            return Companion.sizeOf($this$sizeOf, config);
        }

        @JvmStatic
        @JvmName(name="sizeOf")
        public static final long sizeOf(@NotNull CharSequence $this$sizeOf, @NotNull ReplacementStrategy strategy) {
            return Companion.sizeOf($this$sizeOf, strategy);
        }

        @JvmStatic
        @JvmName(name="sizeOf")
        public static final long sizeOf(@NotNull CharIterator $this$sizeOf, @NotNull UTF8 utf8) {
            return Companion.sizeOf($this$sizeOf, utf8);
        }

        @JvmStatic
        @JvmName(name="sizeOf")
        public static final long sizeOf(@NotNull CharIterator $this$sizeOf, @NotNull Config config) {
            return Companion.sizeOf($this$sizeOf, config);
        }

        @JvmStatic
        @JvmName(name="sizeOf")
        public static final long sizeOf(@NotNull CharIterator $this$sizeOf, @NotNull ReplacementStrategy strategy) {
            return Companion.sizeOf($this$sizeOf, strategy);
        }

        public /* synthetic */ CharPreProcessor(ReplacementStrategy strategy, DefaultConstructorMarker $constructor_marker) {
            this(strategy);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0087\bJ\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0087\bJ\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0087\b\u00a2\u0006\u0002\b\u000eJ\u001a\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0087\b\u00a2\u0006\u0002\b\u000eJ\u0019\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u000eJ\u001a\u0010\u000b\u001a\u00020\f*\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0087\b\u00a2\u0006\u0002\b\u000eJ\u001a\u0010\u000b\u001a\u00020\f*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0087\b\u00a2\u0006\u0002\b\u000eJ\u0019\u0010\u000b\u001a\u00020\f*\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u000eJ\u001a\u0010\u000b\u001a\u00020\f*\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0087\b\u00a2\u0006\u0002\b\u000eJ\u001a\u0010\u000b\u001a\u00020\f*\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0087\b\u00a2\u0006\u0002\b\u000eJ\u0019\u0010\u000b\u001a\u00020\f*\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u000e\u00a8\u0006\u0011"}, d2={"Lio/matthewnelson/encoding/utf8/UTF8$CharPreProcessor$Companion;", "", "()V", "of", "Lio/matthewnelson/encoding/utf8/UTF8$CharPreProcessor;", "utf8", "Lio/matthewnelson/encoding/utf8/UTF8;", "config", "Lio/matthewnelson/encoding/utf8/UTF8$Config;", "strategy", "Lio/matthewnelson/encoding/utf8/UTF8$ReplacementStrategy;", "sizeUTF8", "", "", "sizeOf", "", "Lkotlin/collections/CharIterator;", "io.matthewnelson.encoding_utf8_jvm"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final CharPreProcessor of(@NotNull UTF8 utf8) {
                Intrinsics.checkNotNullParameter((Object)((Object)utf8), (String)"utf8");
                boolean $i$f$of = false;
                return this.of(((Config)utf8.getConfig()).replacementStrategy);
            }

            @JvmStatic
            @NotNull
            public final CharPreProcessor of(@NotNull Config config) {
                Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
                boolean $i$f$of = false;
                return this.of(config.replacementStrategy);
            }

            @JvmStatic
            @NotNull
            public final CharPreProcessor of(@NotNull ReplacementStrategy strategy) {
                Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
                return strategy.size == ReplacementStrategy.THROW.size ? (CharPreProcessor)new CharPreProcessor(strategy){

                    protected int replacementSize() {
                        this.setCurrentSize(0L);
                        this.checkNext = false;
                        throw new MalformedEncodingException("Malformed UTF-8 character sequence");
                    }
                } : new CharPreProcessor(strategy, null);
            }

            @JvmStatic
            @JvmName(name="sizeOf")
            public final long sizeOf(@NotNull char[] $this$sizeUTF8, @NotNull UTF8 utf8) {
                Intrinsics.checkNotNullParameter((Object)$this$sizeUTF8, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)((Object)utf8), (String)"utf8");
                boolean $i$f$sizeOf = false;
                return this.sizeOf($this$sizeUTF8, ((Config)utf8.getConfig()).replacementStrategy);
            }

            @JvmStatic
            @JvmName(name="sizeOf")
            public final long sizeOf(@NotNull char[] $this$sizeUTF8, @NotNull Config config) {
                Intrinsics.checkNotNullParameter((Object)$this$sizeUTF8, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
                boolean $i$f$sizeOf = false;
                return this.sizeOf($this$sizeUTF8, config.replacementStrategy);
            }

            @JvmStatic
            @JvmName(name="sizeOf")
            public final long sizeOf(@NotNull char[] $this$sizeUTF8, @NotNull ReplacementStrategy strategy) {
                Intrinsics.checkNotNullParameter((Object)$this$sizeUTF8, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
                CharPreProcessor cpp = this.of(strategy);
                int n = $this$sizeUTF8.length;
                for (int i = 0; i < n; ++i) {
                    cpp.plus($this$sizeUTF8[i]);
                }
                return cpp.doFinal();
            }

            @JvmStatic
            @JvmName(name="sizeOf")
            public final long sizeOf(@NotNull CharSequence $this$sizeUTF8, @NotNull UTF8 utf8) {
                Intrinsics.checkNotNullParameter((Object)$this$sizeUTF8, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)((Object)utf8), (String)"utf8");
                boolean $i$f$sizeOf = false;
                return this.sizeOf($this$sizeUTF8, ((Config)utf8.getConfig()).replacementStrategy);
            }

            @JvmStatic
            @JvmName(name="sizeOf")
            public final long sizeOf(@NotNull CharSequence $this$sizeUTF8, @NotNull Config config) {
                Intrinsics.checkNotNullParameter((Object)$this$sizeUTF8, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
                boolean $i$f$sizeOf = false;
                return this.sizeOf($this$sizeUTF8, config.replacementStrategy);
            }

            @JvmStatic
            @JvmName(name="sizeOf")
            public final long sizeOf(@NotNull CharSequence $this$sizeUTF8, @NotNull ReplacementStrategy strategy) {
                Intrinsics.checkNotNullParameter((Object)$this$sizeUTF8, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
                CharPreProcessor cpp = this.of(strategy);
                int n = $this$sizeUTF8.length();
                for (int i = 0; i < n; ++i) {
                    cpp.plus($this$sizeUTF8.charAt(i));
                }
                return cpp.doFinal();
            }

            @JvmStatic
            @JvmName(name="sizeOf")
            public final long sizeOf(@NotNull CharIterator $this$sizeUTF8, @NotNull UTF8 utf8) {
                Intrinsics.checkNotNullParameter((Object)$this$sizeUTF8, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)((Object)utf8), (String)"utf8");
                boolean $i$f$sizeOf = false;
                return this.sizeOf($this$sizeUTF8, ((Config)utf8.getConfig()).replacementStrategy);
            }

            @JvmStatic
            @JvmName(name="sizeOf")
            public final long sizeOf(@NotNull CharIterator $this$sizeUTF8, @NotNull Config config) {
                Intrinsics.checkNotNullParameter((Object)$this$sizeUTF8, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
                boolean $i$f$sizeOf = false;
                return this.sizeOf($this$sizeUTF8, config.replacementStrategy);
            }

            @JvmStatic
            @JvmName(name="sizeOf")
            public final long sizeOf(@NotNull CharIterator $this$sizeUTF8, @NotNull ReplacementStrategy strategy) {
                Intrinsics.checkNotNullParameter((Object)$this$sizeUTF8, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
                CharPreProcessor cpp = Companion.of(strategy);
                while ($this$sizeUTF8.hasNext()) {
                    cpp.plus($this$sizeUTF8.nextChar());
                }
                return cpp.doFinal();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0014J\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0012R\u00020\u00010\u0011H\u0014R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/matthewnelson/encoding/utf8/UTF8$Config;", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "replacementStrategy", "Lio/matthewnelson/encoding/utf8/UTF8$ReplacementStrategy;", "backFillBuffers", "", "(Lio/matthewnelson/encoding/utf8/UTF8$ReplacementStrategy;Z)V", "decodeOutMaxSizeOrFailProtected", "", "encodedSize", "input", "Lio/matthewnelson/encoding/core/util/DecoderInput;", "decodeOutMaxSizeProtected", "", "encodeOutSizeProtected", "unEncodedSize", "toStringAddSettings", "", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config$Setting;", "Companion", "io.matthewnelson.encoding_utf8_jvm"})
    public static final class Config
    extends EncoderDecoder.Config {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final ReplacementStrategy replacementStrategy;
        private static final long MAX_ENCODED_SIZE_64 = 0x2AAAAAAAAAAAAAAAL;
        private static final int MAX_ENCODED_SIZE_32 = 0x2AAAAAAA;
        @NotNull
        private static final Config DEFAULT = new Config(ReplacementStrategy.KOTLIN, true);
        @NotNull
        private static final Config THROW = new Config(ReplacementStrategy.THROW, Config.DEFAULT.backFillBuffers);

        private Config(ReplacementStrategy replacementStrategy, boolean backFillBuffers) {
            super(null, (byte)0, false, null, RangesKt.coerceAtLeast((int)(replacementStrategy.size * 2), (int)4), replacementStrategy.size == ReplacementStrategy.THROW.size ? 2 : 4, backFillBuffers);
            this.replacementStrategy = replacementStrategy;
        }

        protected long decodeOutMaxSizeProtected(long encodedSize) {
            if (encodedSize > 0x2AAAAAAAAAAAAAAAL) {
                throw EncoderDecoder.Config.Companion.outSizeExceedsMaxEncodingSizeException((Number)encodedSize, (Number)Long.MAX_VALUE);
            }
            return encodedSize * 3L;
        }

        protected int decodeOutMaxSizeOrFailProtected(int encodedSize, @NotNull DecoderInput input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (encodedSize > 0x2AAAAAAA) {
                throw EncoderDecoder.Config.Companion.outSizeExceedsMaxEncodingSizeException((Number)encodedSize, (Number)Integer.MAX_VALUE);
            }
            return encodedSize * 3;
        }

        protected long encodeOutSizeProtected(long unEncodedSize) {
            return unEncodedSize;
        }

        @NotNull
        protected Set<EncoderDecoder.Config.Setting> toStringAddSettings() {
            Set set;
            Set $this$toStringAddSettings_u24lambda_u240 = set = SetsKt.createSetBuilder((int)1);
            boolean bl = false;
            $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "replacementStrategy", (Object)this.replacementStrategy));
            return SetsKt.build((Set)set);
        }

        public /* synthetic */ Config(ReplacementStrategy replacementStrategy, boolean backFillBuffers, DefaultConstructorMarker $constructor_marker) {
            this(replacementStrategy, backFillBuffers);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011R\u0016\u0010\u0003\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lio/matthewnelson/encoding/utf8/UTF8$Config$Companion;", "", "()V", "DEFAULT", "Lio/matthewnelson/encoding/utf8/UTF8$Config;", "getDEFAULT$io_matthewnelson_encoding_utf8_jvm", "()Lio/matthewnelson/encoding/utf8/UTF8$Config;", "MAX_ENCODED_SIZE_32", "", "MAX_ENCODED_SIZE_64", "", "THROW", "getTHROW$io_matthewnelson_encoding_utf8_jvm", "build", "Lio/matthewnelson/encoding/utf8/UTF8;", "b", "Lio/matthewnelson/encoding/utf8/UTF8$Builder;", "build$io_matthewnelson_encoding_utf8_jvm", "io.matthewnelson.encoding_utf8_jvm"})
        @SourceDebugExtension(value={"SMAP\nUTF8.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UTF8.kt\nio/matthewnelson/encoding/utf8/UTF8$Config$Companion\n+ 2 -Config.kt\nio/matthewnelson/encoding/utf8/internal/_ConfigKt\n*L\n1#1,1101:1\n26#2,11:1102\n*S KotlinDebug\n*F\n+ 1 UTF8.kt\nio/matthewnelson/encoding/utf8/UTF8$Config$Companion\n*L\n278#1:1102,11\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final /* synthetic */ UTF8 build$io_matthewnelson_encoding_utf8_jvm(Builder b) {
                void $this$build$iv;
                UTF8 uTF8;
                void b$iv;
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                Function2 function2 = build.1.INSTANCE;
                Builder builder = b;
                Function1 utf8$iv = build.2.INSTANCE;
                boolean $i$f$build = false;
                if (b$iv.get_backFillBuffers$io_matthewnelson_encoding_utf8_jvm() == ((Config)UTF8.Default.getConfig()).backFillBuffers) {
                    if (Intrinsics.areEqual((Object)b$iv.get_replacementStrategy$io_matthewnelson_encoding_utf8_jvm(), (Object)((Config)UTF8.Default.getConfig()).replacementStrategy)) {
                        uTF8 = Default;
                        return uTF8;
                    }
                    if (Intrinsics.areEqual((Object)b$iv.get_replacementStrategy$io_matthewnelson_encoding_utf8_jvm(), (Object)((Config)ThrowOnInvalid.INSTANCE.getConfig()).replacementStrategy)) {
                        uTF8 = ThrowOnInvalid.INSTANCE;
                        return uTF8;
                    }
                }
                Config config$iv = (Config)((Object)$this$build$iv.invoke((Object)b$iv.get_replacementStrategy$io_matthewnelson_encoding_utf8_jvm(), (Object)b$iv.get_backFillBuffers$io_matthewnelson_encoding_utf8_jvm()));
                uTF8 = (UTF8)((Object)utf8$iv.invoke((Object)config$iv));
                return uTF8;
            }

            public final /* synthetic */ Config getDEFAULT$io_matthewnelson_encoding_utf8_jvm() {
                return DEFAULT;
            }

            public final /* synthetic */ Config getTHROW$io_matthewnelson_encoding_utf8_jvm() {
                return THROW;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\b\u00a2\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\b\u0010\u000f\u001a\u00020\fH\u0004J\f\u0010\u0010\u001a\u00020\f*\u00020\u0005H$J\r\u0010\u0011\u001a\u00020\n*\u00020\bH\u0082\bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/matthewnelson/encoding/utf8/UTF8$DecoderFeed;", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "Lio/matthewnelson/encoding/utf8/UTF8$Config;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "(Lio/matthewnelson/encoding/utf8/UTF8;Lio/matthewnelson/encoding/core/Decoder$OutFeed;)V", "buf", "", "hasBuffered", "", "consumeProtected", "", "input", "", "doFinalProtected", "outputReplacementSequence", "process", "io.matthewnelson.encoding_utf8_jvm"})
    @SourceDebugExtension(value={"SMAP\nUTF8.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UTF8.kt\nio/matthewnelson/encoding/utf8/UTF8$DecoderFeed\n*L\n1#1,1101:1\n605#1,20:1102\n605#1,20:1122\n*S KotlinDebug\n*F\n+ 1 UTF8.kt\nio/matthewnelson/encoding/utf8/UTF8$DecoderFeed\n*L\n572#1:1102,20\n580#1:1122,20\n*E\n"})
    private abstract class DecoderFeed
    extends Decoder.Feed {
        private int buf;
        private boolean hasBuffered;

        public DecoderFeed(Decoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            super((Decoder)UTF8.this, out);
        }

        protected abstract void outputReplacementSequence(@NotNull Decoder.OutFeed var1) throws MalformedEncodingException;

        /*
         * WARNING - void declaration
         */
        protected final void consumeProtected(char input) {
            char c = input;
            if (!this.hasBuffered) {
                boolean bl;
                void this_$iv;
                DecoderFeed decoderFeed = this;
                char $this$process$iv = c;
                boolean $i$f$process = false;
                if ($this$process$iv < '\u0080') {
                    this_$iv._out().output((byte)$this$process$iv);
                    bl = true;
                } else if ($this$process$iv < '\u0800') {
                    this_$iv._out().output((byte)($this$process$iv >> 6 | 0xC0));
                    this_$iv._out().output((byte)($this$process$iv & 0x3F | 0x80));
                    bl = true;
                } else if ($this$process$iv < '\ud800' || $this$process$iv > '\udfff') {
                    this_$iv._out().output((byte)($this$process$iv >> 12 | 0xE0));
                    this_$iv._out().output((byte)($this$process$iv >> 6 & 0x3F | 0x80));
                    this_$iv._out().output((byte)($this$process$iv & 0x3F | 0x80));
                    bl = true;
                } else if ($this$process$iv > '\udbff') {
                    this_$iv.outputReplacementSequence(this_$iv._out());
                    bl = true;
                } else {
                    bl = false;
                }
                if (bl) {
                    return;
                }
                this.buf = c;
                this.hasBuffered = true;
                return;
            }
            if (c < '\udc00' || c > '\udfff') {
                boolean bl;
                this.outputReplacementSequence(this._out());
                DecoderFeed this_$iv = this;
                char $this$process$iv = c;
                boolean $i$f$process = false;
                if ($this$process$iv < '\u0080') {
                    this_$iv._out().output((byte)$this$process$iv);
                    bl = true;
                } else if ($this$process$iv < '\u0800') {
                    this_$iv._out().output((byte)($this$process$iv >> 6 | 0xC0));
                    this_$iv._out().output((byte)($this$process$iv & 0x3F | 0x80));
                    bl = true;
                } else if ($this$process$iv < '\ud800' || $this$process$iv > '\udfff') {
                    this_$iv._out().output((byte)($this$process$iv >> 12 | 0xE0));
                    this_$iv._out().output((byte)($this$process$iv >> 6 & 0x3F | 0x80));
                    this_$iv._out().output((byte)($this$process$iv & 0x3F | 0x80));
                    bl = true;
                } else if ($this$process$iv > '\udbff') {
                    this_$iv.outputReplacementSequence(this_$iv._out());
                    bl = true;
                } else {
                    bl = false;
                }
                if (bl) {
                    this.hasBuffered = false;
                    return;
                }
                this.buf = c;
                return;
            }
            this.hasBuffered = false;
            int codePoint = (this.buf << 10) + c + -56613888;
            this._out().output((byte)(codePoint >> 18 | 0xF0));
            this._out().output((byte)(codePoint >> 12 & 0x3F | 0x80));
            this._out().output((byte)(codePoint >> 6 & 0x3F | 0x80));
            this._out().output((byte)(codePoint & 0x3F | 0x80));
        }

        protected final void doFinalProtected() {
            this.buf = 0;
            if (!this.hasBuffered) {
                return;
            }
            this.hasBuffered = false;
            this.outputReplacementSequence(this._out());
        }

        private final boolean process(int $this$process) {
            boolean $i$f$process = false;
            if ($this$process < 128) {
                this._out().output((byte)$this$process);
                return true;
            }
            if ($this$process < 2048) {
                this._out().output((byte)($this$process >> 6 | 0xC0));
                this._out().output((byte)($this$process & 0x3F | 0x80));
                return true;
            }
            if ($this$process < 55296 || $this$process > 57343) {
                this._out().output((byte)($this$process >> 12 | 0xE0));
                this._out().output((byte)($this$process >> 6 & 0x3F | 0x80));
                this._out().output((byte)($this$process & 0x3F | 0x80));
                return true;
            }
            if ($this$process > 56319) {
                this.outputReplacementSequence(this._out());
                return true;
            }
            return false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0005\u001a\u00020\u00012\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nH\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\b\u000bJA\u0010\u0005\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nH\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000e"}, d2={"Lio/matthewnelson/encoding/utf8/UTF8$Default;", "Lio/matthewnelson/encoding/utf8/UTF8;", "()V", "NAME", "", "Builder", "block", "Lkotlin/Function1;", "Lio/matthewnelson/encoding/utf8/UTF8$Builder;", "", "Lkotlin/ExtensionFunctionType;", "-Builder", "other", "Lio/matthewnelson/encoding/utf8/UTF8$Config;", "io.matthewnelson.encoding_utf8_jvm"})
    @SourceDebugExtension(value={"SMAP\nUTF8.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UTF8.kt\nio/matthewnelson/encoding/utf8/UTF8$Default\n*L\n1#1,1101:1\n93#1,2:1102\n*S KotlinDebug\n*F\n+ 1 UTF8.kt\nio/matthewnelson/encoding/utf8/UTF8$Default\n*L\n83#1:1102,2\n*E\n"})
    public static final class Default
    extends UTF8 {
        private Default() {
            super(Config.Companion.getDEFAULT$io_matthewnelson_encoding_utf8_jvm(), null);
        }

        @Override
        @JvmStatic
        @JvmName(name="-Builder")
        @NotNull
        public final UTF8 -Builder(@NotNull Function1<? super Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean bl = false;
            Default default_ = this;
            Config other$iv = null;
            $i$f$-Builder = false;
            Builder builder = new Builder(other$iv);
            block.invoke((Object)builder);
            return builder.build();
        }

        @Override
        @JvmStatic
        @JvmName(name="-Builder")
        @NotNull
        public final UTF8 -Builder(@Nullable Config other, @NotNull Function1<? super Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean bl = false;
            Builder builder = new Builder(other);
            block.invoke((Object)builder);
            return builder.build();
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u0092\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\b\u0010\u0010\u001a\u00020\rH\u0004J\u001d\u0010\u0011\u001a\u00020\r2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0082\bJ\r\u0010\u0012\u001a\u00020\u0013*\u00020\nH\u0082\bJ\f\u0010\u0014\u001a\u00020\r*\u00020\u0005H\u0014J\f\u0010\u0015\u001a\u00020\n*\u00020\nH\u0002J\u0014\u0010\u0016\u001a\u00020\n*\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u001c\u0010\u0018\u001a\u00020\n*\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002J$\u0010\u001a\u001a\u00020\n*\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0002J\r\u0010\u001c\u001a\u00020\r*\u00020\nH\u0082\bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/matthewnelson/encoding/utf8/UTF8$EncoderFeed;", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/utf8/UTF8$Config;", "out", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "(Lio/matthewnelson/encoding/utf8/UTF8;Lio/matthewnelson/encoding/core/Encoder$OutFeed;)V", "buf", "", "iBuf", "", "needed", "consumeProtected", "", "input", "", "doFinalProtected", "reset", "isContinuation", "", "outputReplacementChar", "process1", "process2", "b0", "process3", "b1", "process4", "b2", "processN", "io.matthewnelson.encoding_utf8_jvm"})
    @SourceDebugExtension(value={"SMAP\nUTF8.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UTF8.kt\nio/matthewnelson/encoding/utf8/UTF8$EncoderFeed\n+ 2 UTF8.kt\nio/matthewnelson/encoding/utf8/UTF8Kt\n*L\n1#1,1101:1\n924#1,4:1108\n915#1,4:1112\n924#1,4:1122\n924#1,4:1129\n915#1,4:1133\n916#1,3:1137\n924#1,4:1140\n915#1,4:1144\n924#1,4:1157\n924#1,4:1164\n915#1,4:1168\n916#1,3:1172\n924#1,4:1181\n924#1,4:1188\n915#1,4:1192\n916#1,3:1196\n924#1,4:1199\n924#1,4:1209\n924#1,4:1216\n915#1,4:1220\n916#1,3:1224\n924#1,4:1227\n915#1,4:1231\n916#1,3:1235\n924#1,4:1241\n924#1,4:1248\n915#1,4:1252\n916#1,3:1256\n924#1,4:1259\n915#1,4:1263\n915#1,4:1273\n915#1,4:1283\n915#1,4:1305\n915#1,4:1315\n1088#1:1340\n1088#1:1353\n1088#1:1357\n1088#1:1361\n1088#1:1365\n1088#1:1381\n1088#1:1385\n1088#1:1389\n1097#2,3:1102\n1097#2,3:1105\n1097#2,3:1116\n1097#2,3:1119\n1097#2,3:1126\n1097#2,3:1148\n1097#2,3:1151\n1097#2,3:1154\n1097#2,3:1161\n1097#2,3:1175\n1097#2,3:1178\n1097#2,3:1185\n1097#2,3:1203\n1097#2,3:1206\n1097#2,3:1213\n1097#2,3:1238\n1097#2,3:1245\n1097#2,3:1267\n1097#2,3:1270\n1097#2,3:1277\n1097#2,3:1280\n1097#2,3:1287\n1097#2,3:1290\n1097#2,3:1293\n1097#2,3:1296\n1097#2,3:1299\n1097#2,3:1302\n1097#2,3:1309\n1097#2,3:1312\n1097#2,3:1319\n1097#2,3:1322\n1097#2,3:1325\n1097#2,3:1328\n1097#2,3:1331\n1097#2,3:1334\n1097#2,3:1337\n1097#2,3:1341\n1097#2,3:1344\n1097#2,3:1347\n1097#2,3:1350\n1097#2,3:1354\n1097#2,3:1358\n1097#2,3:1362\n1097#2,3:1366\n1097#2,3:1369\n1097#2,3:1372\n1097#2,3:1375\n1097#2,3:1378\n1097#2,3:1382\n1097#2,3:1386\n1097#2,3:1390\n1097#2,3:1393\n*S KotlinDebug\n*F\n+ 1 UTF8.kt\nio/matthewnelson/encoding/utf8/UTF8$EncoderFeed\n*L\n663#1:1108,4\n665#1:1112,4\n673#1:1122,4\n677#1:1129,4\n679#1:1133,4\n685#1:1137,3\n689#1:1140,4\n691#1:1144,4\n701#1:1157,4\n705#1:1164,4\n707#1:1168,4\n713#1:1172,3\n721#1:1181,4\n725#1:1188,4\n727#1:1192,4\n733#1:1196,3\n737#1:1199,4\n744#1:1209,4\n748#1:1216,4\n750#1:1220,4\n756#1:1224,3\n760#1:1227,4\n762#1:1231,4\n769#1:1235,3\n775#1:1241,4\n779#1:1248,4\n781#1:1252,4\n787#1:1256,3\n791#1:1259,4\n793#1:1263,4\n808#1:1273,4\n838#1:1283,4\n889#1:1305,4\n906#1:1315,4\n975#1:1340\n1008#1:1353\n1012#1:1357\n1018#1:1361\n1024#1:1365\n1064#1:1381\n1069#1:1385\n1074#1:1389\n641#1:1102,3\n661#1:1105,3\n669#1:1116,3\n671#1:1119,3\n675#1:1126,3\n695#1:1148,3\n697#1:1151,3\n699#1:1154,3\n703#1:1161,3\n717#1:1175,3\n719#1:1178,3\n723#1:1185,3\n740#1:1203,3\n742#1:1206,3\n746#1:1213,3\n773#1:1238,3\n777#1:1245,3\n801#1:1267,3\n803#1:1270,3\n809#1:1277,3\n830#1:1280,3\n839#1:1287,3\n846#1:1290,3\n848#1:1293,3\n852#1:1296,3\n860#1:1299,3\n869#1:1302,3\n890#1:1309,3\n896#1:1312,3\n907#1:1319,3\n942#1:1322,3\n947#1:1325,3\n951#1:1328,3\n955#1:1331,3\n958#1:1334,3\n971#1:1337,3\n976#1:1341,3\n980#1:1344,3\n996#1:1347,3\n1002#1:1350,3\n1009#1:1354,3\n1013#1:1358,3\n1019#1:1362,3\n1025#1:1366,3\n1029#1:1369,3\n1046#1:1372,3\n1052#1:1375,3\n1058#1:1378,3\n1065#1:1382,3\n1070#1:1386,3\n1075#1:1390,3\n1079#1:1393,3\n*E\n"})
    private class EncoderFeed
    extends Encoder.Feed {
        @NotNull
        private final int[] buf;
        private int iBuf;
        private int needed;

        public EncoderFeed(Encoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            super((Encoder)UTF8.this, out);
            this.buf = new int[3];
        }

        protected void outputReplacementChar(@NotNull Encoder.OutFeed $this$outputReplacementChar) throws MalformedEncodingException {
            Intrinsics.checkNotNullParameter((Object)$this$outputReplacementChar, (String)"<this>");
            $this$outputReplacementChar.output('\ufffd');
        }

        /*
         * WARNING - void declaration
         */
        protected final void consumeProtected(byte input) {
            int iBuf$iv;
            int iBuf$iv2;
            byte $this$processN$iv;
            boolean $i$f$debug;
            int $this$debug$iv;
            byte $this$processN$iv2;
            boolean $i$f$debug2;
            int $this$debug$iv22;
            EncoderFeed $this$debug$iv3 = this;
            int $i$f$debug3 = 0;
            byte bN = input;
            if (this.needed == 0) {
                this.needed = this.process1(bN);
                if (this.needed > 0) {
                    $i$f$debug3 = this.iBuf;
                    this.iBuf = $i$f$debug3 + 1;
                    this.buf[$i$f$debug3] = bN;
                }
                return;
            }
            if (this.needed - 1 > this.iBuf) {
                $i$f$debug3 = this.iBuf;
                this.iBuf = $i$f$debug3 + 1;
                this.buf[$i$f$debug3] = bN;
                return;
            }
            int b0 = this.buf[0];
            if (this.needed == 2) {
                int $this$debug$iv42 = this.process2(bN, b0);
                boolean $i$f$debug4 = false;
                switch ($this$debug$iv42) {
                    case 0: {
                        void this_$iv;
                        EncoderFeed $this$debug$iv42 = this;
                        byte $this$processN$iv3 = bN;
                        boolean $i$f$processN = false;
                        this_$iv.iBuf = 0;
                        this_$iv.needed = super.process1($this$processN$iv3);
                        if (this_$iv.needed > 0) {
                            int n = this_$iv.iBuf;
                            this_$iv.iBuf = n + 1;
                            this_$iv.buf[n] = $this$processN$iv3;
                        }
                        return;
                    }
                    case 2: {
                        EncoderFeed $this$iv = this;
                        int iBuf$iv3 = 0;
                        int needed$iv = 0;
                        boolean $i$f$reset = false;
                        $this$iv.iBuf = iBuf$iv3;
                        $this$iv.needed = needed$iv;
                        return;
                    }
                }
            }
            int b1 = this.buf[1];
            if (this.needed == 3) {
                int $this$debug$iv5 = this.process3(bN, b0, b1);
                boolean $i$f$debug5 = false;
                block4 : switch ($this$debug$iv5) {
                    case 0: {
                        $this$debug$iv22 = this.process1(b1);
                        $i$f$debug2 = false;
                        int n = $this$debug$iv22;
                        switch (n) {
                            case 0: {
                                void this_$iv;
                                EncoderFeed $this$debug$iv22 = this;
                                $this$processN$iv2 = bN;
                                boolean $i$f$processN = false;
                                this_$iv.iBuf = 0;
                                this_$iv.needed = super.process1($this$processN$iv2);
                                if (this_$iv.needed > 0) {
                                    int n2 = this_$iv.iBuf;
                                    this_$iv.iBuf = n2 + 1;
                                    this_$iv.buf[n2] = $this$processN$iv2;
                                }
                                return;
                            }
                            case 2: {
                                $this$debug$iv = this.process2(bN, b1);
                                $i$f$debug = false;
                                switch ($this$debug$iv) {
                                    case 0: {
                                        void this_$iv;
                                        EncoderFeed $this$debug$iv6 = this;
                                        $this$processN$iv = bN;
                                        boolean $i$f$processN = false;
                                        this_$iv.iBuf = 0;
                                        this_$iv.needed = super.process1($this$processN$iv);
                                        if (this_$iv.needed > 0) {
                                            int n3 = this_$iv.iBuf;
                                            this_$iv.iBuf = n3 + 1;
                                            this_$iv.buf[n3] = $this$processN$iv;
                                        }
                                        return;
                                    }
                                    case 2: {
                                        EncoderFeed $this$iv = this;
                                        iBuf$iv2 = 0;
                                        int needed$iv = 0;
                                        boolean $i$f$reset = false;
                                        $this$iv.iBuf = iBuf$iv2;
                                        $this$iv.needed = needed$iv;
                                        return;
                                    }
                                }
                                break block4;
                            }
                            case 3: 
                            case 4: {
                                this.buf[0] = b1;
                                this.buf[1] = bN;
                                EncoderFeed this_$iv = this;
                                int $this$iv = 2;
                                int needed$iv = n;
                                boolean $i$f$reset = false;
                                this_$iv.iBuf = iBuf$iv;
                                this_$iv.needed = needed$iv;
                                return;
                            }
                        }
                        break;
                    }
                    case 1: {
                        void this_$iv;
                        EncoderFeed n = this;
                        byte $this$processN$iv4 = bN;
                        boolean $i$f$processN = false;
                        this_$iv.iBuf = 0;
                        this_$iv.needed = super.process1($this$processN$iv4);
                        if (this_$iv.needed > 0) {
                            int needed$iv = this_$iv.iBuf;
                            this_$iv.iBuf = needed$iv + 1;
                            this_$iv.buf[needed$iv] = $this$processN$iv4;
                        }
                        return;
                    }
                    case 3: {
                        EncoderFeed $this$iv = this;
                        int iBuf$iv4 = 0;
                        int needed$iv = 0;
                        boolean $i$f$reset = false;
                        $this$iv.iBuf = iBuf$iv4;
                        $this$iv.needed = needed$iv;
                        return;
                    }
                }
            }
            int b2 = this.buf[2];
            if (this.needed == 4) {
                $this$debug$iv22 = this.process4(bN, b0, b1, b2);
                $i$f$debug2 = false;
                block18 : switch ($this$debug$iv22) {
                    case 0: {
                        int $this$iv6;
                        int $this$debug$iv72;
                        $this$debug$iv = this.process1(b1);
                        $i$f$debug = false;
                        switch ($this$debug$iv) {
                            case 0: {
                                $this$debug$iv72 = this.process1(b2);
                                boolean $i$f$debug6 = false;
                                int n = $this$debug$iv72;
                                switch (n) {
                                    case 0: {
                                        void this_$iv;
                                        EncoderFeed $this$debug$iv72 = this;
                                        byte $this$processN$iv5 = bN;
                                        boolean $i$f$processN = false;
                                        this_$iv.iBuf = 0;
                                        this_$iv.needed = super.process1($this$processN$iv5);
                                        if (this_$iv.needed > 0) {
                                            int n4 = this_$iv.iBuf;
                                            this_$iv.iBuf = n4 + 1;
                                            this_$iv.buf[n4] = $this$processN$iv5;
                                        }
                                        return;
                                    }
                                    case 2: {
                                        int $this$debug$iv82 = this.process2(bN, b2);
                                        boolean $i$f$debug7 = false;
                                        switch ($this$debug$iv82) {
                                            case 0: {
                                                void this_$iv;
                                                EncoderFeed $this$debug$iv82 = this;
                                                byte $this$processN$iv6 = bN;
                                                boolean $i$f$processN = false;
                                                this_$iv.iBuf = 0;
                                                this_$iv.needed = super.process1($this$processN$iv6);
                                                if (this_$iv.needed > 0) {
                                                    int n5 = this_$iv.iBuf;
                                                    this_$iv.iBuf = n5 + 1;
                                                    this_$iv.buf[n5] = $this$processN$iv6;
                                                }
                                                return;
                                            }
                                            case 2: {
                                                EncoderFeed $this$iv2 = this;
                                                int iBuf$iv5 = 0;
                                                int needed$iv = 0;
                                                boolean $i$f$reset = false;
                                                $this$iv2.iBuf = iBuf$iv5;
                                                $this$iv2.needed = needed$iv;
                                                return;
                                            }
                                        }
                                        break block18;
                                    }
                                    case 3: 
                                    case 4: {
                                        void iBuf$iv6;
                                        this.buf[0] = b2;
                                        this.buf[1] = bN;
                                        EncoderFeed this_$iv = this;
                                        int $this$iv2 = 2;
                                        int needed$iv = n;
                                        boolean $i$f$reset = false;
                                        this_$iv.iBuf = (int)iBuf$iv6;
                                        this_$iv.needed = needed$iv;
                                        return;
                                    }
                                }
                                break block18;
                            }
                            case 2: {
                                int n7;
                                $this$debug$iv72 = this.process2(b2, b1);
                                boolean $i$f$debug8 = false;
                                switch ($this$debug$iv72) {
                                    case 0: {
                                        int $this$debug$iv92 = this.process1(b2);
                                        boolean $i$f$debug9 = false;
                                        n7 = $this$debug$iv92;
                                        switch (n7) {
                                            case 0: {
                                                void this_$iv;
                                                EncoderFeed $this$debug$iv92 = this;
                                                byte $this$processN$iv7 = bN;
                                                boolean $i$f$processN = false;
                                                this_$iv.iBuf = 0;
                                                this_$iv.needed = super.process1($this$processN$iv7);
                                                if (this_$iv.needed > 0) {
                                                    int $i$f$reset = this_$iv.iBuf;
                                                    this_$iv.iBuf = $i$f$reset + 1;
                                                    this_$iv.buf[$i$f$reset] = $this$processN$iv7;
                                                }
                                                return;
                                            }
                                            case 2: {
                                                int $this$debug$iv102 = this.process2(bN, b2);
                                                boolean $i$f$debug10 = false;
                                                switch ($this$debug$iv102) {
                                                    case 0: {
                                                        void this_$iv;
                                                        EncoderFeed $this$debug$iv102 = this;
                                                        byte $this$processN$iv8 = bN;
                                                        boolean $i$f$processN = false;
                                                        this_$iv.iBuf = 0;
                                                        this_$iv.needed = super.process1($this$processN$iv8);
                                                        if (this_$iv.needed > 0) {
                                                            int n6 = this_$iv.iBuf;
                                                            this_$iv.iBuf = n6 + 1;
                                                            this_$iv.buf[n6] = $this$processN$iv8;
                                                        }
                                                        return;
                                                    }
                                                    case 2: {
                                                        EncoderFeed $this$iv3 = this;
                                                        int iBuf$iv7 = 0;
                                                        int needed$iv = 0;
                                                        boolean $i$f$reset = false;
                                                        $this$iv3.iBuf = iBuf$iv7;
                                                        $this$iv3.needed = needed$iv;
                                                        return;
                                                    }
                                                }
                                                break block18;
                                            }
                                            case 3: 
                                            case 4: {
                                                void iBuf$iv8;
                                                this.buf[0] = b2;
                                                this.buf[1] = bN;
                                                EncoderFeed this_$iv = this;
                                                int $this$iv3 = 2;
                                                int needed$iv = n7;
                                                boolean $i$f$reset = false;
                                                this_$iv.iBuf = (int)iBuf$iv8;
                                                this_$iv.needed = needed$iv;
                                                return;
                                            }
                                        }
                                        break block18;
                                    }
                                    case 2: {
                                        void this_$iv;
                                        EncoderFeed n7 = this;
                                        byte $this$processN$iv9 = bN;
                                        boolean $i$f$processN = false;
                                        this_$iv.iBuf = 0;
                                        this_$iv.needed = super.process1($this$processN$iv9);
                                        if (this_$iv.needed > 0) {
                                            int needed$iv = this_$iv.iBuf;
                                            this_$iv.iBuf = needed$iv + 1;
                                            this_$iv.buf[needed$iv] = $this$processN$iv9;
                                        }
                                        return;
                                    }
                                }
                                break block18;
                            }
                            case 3: {
                                int n7;
                                $this$debug$iv72 = this.process3(bN, b1, b2);
                                boolean $i$f$debug11 = false;
                                switch ($this$debug$iv72) {
                                    case 0: {
                                        int $this$debug$iv112 = this.process1(b2);
                                        boolean $i$f$debug12 = false;
                                        n7 = $this$debug$iv112;
                                        switch (n7) {
                                            case 0: {
                                                void this_$iv;
                                                EncoderFeed $this$debug$iv112 = this;
                                                byte $this$processN$iv10 = bN;
                                                boolean $i$f$processN = false;
                                                this_$iv.iBuf = 0;
                                                this_$iv.needed = super.process1($this$processN$iv10);
                                                if (this_$iv.needed > 0) {
                                                    int $i$f$reset = this_$iv.iBuf;
                                                    this_$iv.iBuf = $i$f$reset + 1;
                                                    this_$iv.buf[$i$f$reset] = $this$processN$iv10;
                                                }
                                                return;
                                            }
                                            case 2: {
                                                int $this$debug$iv122 = this.process2(bN, b2);
                                                boolean $i$f$debug13 = false;
                                                switch ($this$debug$iv122) {
                                                    case 0: {
                                                        void this_$iv;
                                                        EncoderFeed $this$debug$iv122 = this;
                                                        byte $this$processN$iv11 = bN;
                                                        boolean $i$f$processN = false;
                                                        this_$iv.iBuf = 0;
                                                        this_$iv.needed = super.process1($this$processN$iv11);
                                                        if (this_$iv.needed > 0) {
                                                            int $i$f$reset = this_$iv.iBuf;
                                                            this_$iv.iBuf = $i$f$reset + 1;
                                                            this_$iv.buf[$i$f$reset] = $this$processN$iv11;
                                                        }
                                                        return;
                                                    }
                                                    case 2: {
                                                        EncoderFeed $this$iv4 = this;
                                                        int iBuf$iv9 = 0;
                                                        int needed$iv = 0;
                                                        boolean $i$f$reset = false;
                                                        $this$iv4.iBuf = iBuf$iv9;
                                                        $this$iv4.needed = needed$iv;
                                                        return;
                                                    }
                                                }
                                                break block18;
                                            }
                                            case 3: 
                                            case 4: {
                                                void iBuf$iv10;
                                                this.buf[0] = b2;
                                                this.buf[1] = bN;
                                                EncoderFeed this_$iv = this;
                                                int $this$iv4 = 2;
                                                int needed$iv = n7;
                                                boolean $i$f$reset = false;
                                                this_$iv.iBuf = (int)iBuf$iv10;
                                                this_$iv.needed = needed$iv;
                                                return;
                                            }
                                        }
                                        break block18;
                                    }
                                    case 1: {
                                        void this_$iv;
                                        EncoderFeed n = this;
                                        byte $this$processN$iv12 = bN;
                                        boolean $i$f$processN = false;
                                        this_$iv.iBuf = 0;
                                        this_$iv.needed = super.process1($this$processN$iv12);
                                        if (this_$iv.needed > 0) {
                                            int needed$iv = this_$iv.iBuf;
                                            this_$iv.iBuf = needed$iv + 1;
                                            this_$iv.buf[needed$iv] = $this$processN$iv12;
                                        }
                                        return;
                                    }
                                    case 3: {
                                        EncoderFeed $this$iv5 = this;
                                        int iBuf$iv11 = 0;
                                        int needed$iv = 0;
                                        boolean $i$f$reset = false;
                                        $this$iv5.iBuf = iBuf$iv11;
                                        $this$iv5.needed = needed$iv;
                                        return;
                                    }
                                }
                                break block18;
                            }
                            case 4: {
                                void this_$iv;
                                this.buf[0] = b1;
                                this.buf[1] = b2;
                                this.buf[2] = bN;
                                EncoderFeed n = this;
                                $this$iv6 = 3;
                                int needed$iv = 4;
                                boolean $i$f$reset = false;
                                ((EncoderFeed)this_$iv).iBuf = iBuf$iv2;
                                ((EncoderFeed)this_$iv).needed = needed$iv;
                                return;
                            }
                        }
                        break;
                    }
                    case 1: {
                        int $this$iv6;
                        int $this$debug$iv72;
                        $this$debug$iv = this.process1(b2);
                        $i$f$debug = false;
                        int n = $this$debug$iv;
                        switch (n) {
                            case 0: {
                                void this_$iv;
                                EncoderFeed $this$debug$iv13 = this;
                                $this$processN$iv = bN;
                                boolean $i$f$processN = false;
                                this_$iv.iBuf = 0;
                                this_$iv.needed = super.process1($this$processN$iv);
                                if (this_$iv.needed > 0) {
                                    int $i$f$reset = this_$iv.iBuf;
                                    this_$iv.iBuf = $i$f$reset + 1;
                                    this_$iv.buf[$i$f$reset] = $this$processN$iv;
                                }
                                return;
                            }
                            case 2: {
                                $this$debug$iv72 = this.process2(bN, b2);
                                boolean $i$f$debug14 = false;
                                switch ($this$debug$iv72) {
                                    case 0: {
                                        void this_$iv;
                                        EncoderFeed $this$debug$iv14 = this;
                                        byte $this$processN$iv13 = bN;
                                        boolean $i$f$processN = false;
                                        this_$iv.iBuf = 0;
                                        this_$iv.needed = super.process1($this$processN$iv13);
                                        if (this_$iv.needed > 0) {
                                            int $i$f$reset = this_$iv.iBuf;
                                            this_$iv.iBuf = $i$f$reset + 1;
                                            this_$iv.buf[$i$f$reset] = $this$processN$iv13;
                                        }
                                        return;
                                    }
                                    case 2: {
                                        EncoderFeed $this$iv6 = this;
                                        int iBuf$iv12 = 0;
                                        int needed$iv = 0;
                                        boolean $i$f$reset = false;
                                        $this$iv6.iBuf = iBuf$iv12;
                                        $this$iv6.needed = needed$iv;
                                        return;
                                    }
                                }
                                break block18;
                            }
                            case 3: 
                            case 4: {
                                this.buf[0] = b2;
                                this.buf[1] = bN;
                                EncoderFeed this_$iv = this;
                                $this$iv6 = 2;
                                int needed$iv = n;
                                boolean $i$f$reset = false;
                                this_$iv.iBuf = iBuf$iv2;
                                this_$iv.needed = needed$iv;
                                return;
                            }
                        }
                        break;
                    }
                    case 2: {
                        void this_$iv;
                        EncoderFeed n = this;
                        $this$processN$iv2 = bN;
                        boolean $i$f$processN = false;
                        this_$iv.iBuf = 0;
                        this_$iv.needed = super.process1($this$processN$iv2);
                        if (this_$iv.needed > 0) {
                            int needed$iv = this_$iv.iBuf;
                            this_$iv.iBuf = needed$iv + 1;
                            this_$iv.buf[needed$iv] = $this$processN$iv2;
                        }
                        return;
                    }
                    case 4: {
                        EncoderFeed $this$iv = this;
                        iBuf$iv = 0;
                        int needed$iv = 0;
                        boolean $i$f$reset = false;
                        $this$iv.iBuf = iBuf$iv;
                        $this$iv.needed = needed$iv;
                        return;
                    }
                }
            }
            throw new IllegalStateException(("Illegal configuration >> needed[" + this.needed + "] - iBuf[" + this.iBuf + "] - buf[" + this.buf[0] + ", " + this.buf[1] + ", " + this.buf[2] + "] - input[" + bN + ']').toString());
        }

        protected final void doFinalProtected() {
            EncoderFeed $this$debug$iv = this;
            boolean $i$f$debug = false;
            if (this.needed == 0) {
                $this$debug$iv = this;
                $i$f$debug = false;
                ArraysKt.fill$default((int[])this.buf, (int)0, (int)0, (int)0, (int)6, null);
                return;
            }
            if (this.iBuf == 1) {
                this.outputReplacementChar(this._out());
                EncoderFeed $this$iv = this;
                int iBuf$iv = 0;
                int needed$iv = 0;
                boolean $i$f$reset = false;
                $this$iv.iBuf = iBuf$iv;
                $this$iv.needed = needed$iv;
                $this$debug$iv = this;
                $i$f$debug = false;
                ArraysKt.fill$default((int[])this.buf, (int)0, (int)0, (int)0, (int)6, null);
                return;
            }
            int b0 = this.buf[0];
            int b1 = this.buf[1];
            int cN = 192;
            if (this.needed == 3) {
                int $this$debug$iv2 = this.process3(cN, b0, b1);
                boolean $i$f$debug2 = false;
                switch ($this$debug$iv2) {
                    case 0: {
                        if (this.process1(b1) == 0) break;
                        this.outputReplacementChar(this._out());
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("process3 unhandled return value".toString());
                    }
                }
                EncoderFeed $this$iv = this;
                int iBuf$iv = 0;
                int needed$iv = 0;
                boolean $i$f$reset = false;
                $this$iv.iBuf = iBuf$iv;
                $this$iv.needed = needed$iv;
                EncoderFeed $this$debug$iv3 = this;
                boolean $i$f$debug3 = false;
                ArraysKt.fill$default((int[])this.buf, (int)0, (int)0, (int)0, (int)6, null);
                return;
            }
            if (this.needed == 4 && this.iBuf > 2) {
                int b2 = this.buf[2];
                int $this$debug$iv4 = this.process4(cN, b0, b1, b2);
                boolean $i$f$debug4 = false;
                block4 : switch ($this$debug$iv4) {
                    case 0: {
                        int $this$debug$iv5 = this.process1(b1);
                        boolean $i$f$debug5 = false;
                        switch ($this$debug$iv5) {
                            case 0: {
                                if (this.process1(b2) == 0) break block4;
                                this.outputReplacementChar(this._out());
                                break block4;
                            }
                            case 2: {
                                int $this$debug$iv6 = this.process2(b2, b1);
                                boolean $i$f$debug6 = false;
                                switch ($this$debug$iv6) {
                                    case 0: {
                                        if (this.process1(b2) == 0) break block4;
                                        this.outputReplacementChar(this._out());
                                        break block4;
                                    }
                                    case 2: {
                                        break block4;
                                    }
                                    default: {
                                        throw new IllegalStateException("process2 unhandled return value".toString());
                                    }
                                }
                            }
                            case 3: {
                                int $this$debug$iv6 = this.process3(cN, b1, b2);
                                boolean $i$f$debug7 = false;
                                switch ($this$debug$iv6) {
                                    case 0: {
                                        if (this.process1(b2) == 0) break block4;
                                        this.outputReplacementChar(this._out());
                                        break block4;
                                    }
                                    case 1: {
                                        break block4;
                                    }
                                    default: {
                                        throw new IllegalStateException("process3 unhandled return value".toString());
                                    }
                                }
                            }
                            case 4: {
                                int $this$debug$iv6 = this.process4(cN, b1, b2, cN);
                                boolean $i$f$debug8 = false;
                                switch ($this$debug$iv6) {
                                    case 0: {
                                        if (this.process1(b2) == 0) break block4;
                                        this.outputReplacementChar(this._out());
                                        break block4;
                                    }
                                    case 1: {
                                        break block4;
                                    }
                                    case 2: {
                                        throw new IllegalStateException("process4 returned 2???".toString());
                                    }
                                    default: {
                                        throw new IllegalStateException("process4 unhandled return value".toString());
                                    }
                                }
                            }
                            default: {
                                throw new IllegalStateException("process1 unhandled return value".toString());
                            }
                        }
                    }
                    case 1: {
                        if (this.process1(b2) == 0) break;
                        this.outputReplacementChar(this._out());
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("process4 unhandled return value".toString());
                    }
                }
                EncoderFeed $this$iv = this;
                int iBuf$iv = 0;
                int needed$iv = 0;
                boolean $i$f$reset = false;
                $this$iv.iBuf = iBuf$iv;
                $this$iv.needed = needed$iv;
                EncoderFeed $this$debug$iv7 = this;
                boolean $i$f$debug9 = false;
                ArraysKt.fill$default((int[])this.buf, (int)0, (int)0, (int)0, (int)6, null);
                return;
            }
            if (this.needed == 4) {
                int $this$debug$iv8 = this.process4(cN, b0, b1, cN);
                boolean $i$f$debug10 = false;
                switch ($this$debug$iv8) {
                    case 0: {
                        if (this.process1(b1) == 0) break;
                        this.outputReplacementChar(this._out());
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        throw new IllegalStateException("process4 returned 2???".toString());
                    }
                    default: {
                        throw new IllegalStateException("process4 unhandled return value".toString());
                    }
                }
                EncoderFeed $this$iv = this;
                int iBuf$iv = 0;
                int needed$iv = 0;
                boolean $i$f$reset = false;
                $this$iv.iBuf = iBuf$iv;
                $this$iv.needed = needed$iv;
                EncoderFeed $this$debug$iv9 = this;
                boolean $i$f$debug11 = false;
                ArraysKt.fill$default((int[])this.buf, (int)0, (int)0, (int)0, (int)6, null);
                return;
            }
            throw new IllegalStateException(("Illegal configuration >> needed[" + this.needed + "] - iBuf[" + this.iBuf + "] - buf[" + this.buf[0] + ", " + this.buf[1] + ", " + this.buf[2] + ']').toString());
        }

        private final void reset(int iBuf, int needed) {
            boolean $i$f$reset = false;
            this.iBuf = iBuf;
            this.needed = needed;
        }

        static /* synthetic */ void reset$default(EncoderFeed $this, int iBuf, int needed, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reset");
            }
            if ((n & 1) != 0) {
                iBuf = 0;
            }
            if ((n & 2) != 0) {
                needed = 0;
            }
            boolean $i$f$reset = false;
            $this.iBuf = iBuf;
            $this.needed = needed;
        }

        private final void processN(int $this$processN) {
            boolean $i$f$processN = false;
            this.iBuf = 0;
            this.needed = this.process1($this$processN);
            if (this.needed > 0) {
                int n = this.iBuf;
                this.iBuf = n + 1;
                this.buf[n] = $this$processN;
            }
        }

        private final int process1(int $this$process1) {
            if ($this$process1 >= 0) {
                int $this$debug$iv = $this$process1;
                boolean $i$f$debug = false;
                this._out().output((char)$this$process1);
                return 0;
            }
            if ($this$process1 >> 5 == -2) {
                int $this$debug$iv = $this$process1;
                boolean $i$f$debug = false;
                return 2;
            }
            if ($this$process1 >> 4 == -2) {
                int $this$debug$iv = $this$process1;
                boolean $i$f$debug = false;
                return 3;
            }
            if ($this$process1 >> 3 == -2) {
                int $this$debug$iv = $this$process1;
                boolean $i$f$debug = false;
                return 4;
            }
            int $this$debug$iv = $this$process1;
            boolean $i$f$debug = false;
            this.outputReplacementChar(this._out());
            return 0;
        }

        private final int process2(int $this$process2, int b0) {
            boolean $i$f$debug;
            int b1 = $this$process2;
            if ((b0 & 0x1E) == 0) {
                int $this$debug$iv = $this$process2;
                boolean $i$f$debug2 = false;
                this.outputReplacementChar(this._out());
                return 0;
            }
            EncoderFeed $this$debug$iv = this;
            int $this$isContinuation$iv = b1;
            boolean $i$f$isContinuation = false;
            if (!(($this$isContinuation$iv & 0xC0) == 128)) {
                int $this$debug$iv2 = $this$process2;
                $i$f$debug = false;
                this.outputReplacementChar(this._out());
                return 0;
            }
            int $this$debug$iv3 = $this$process2;
            $i$f$debug = false;
            int codePoint = 0xF80 ^ b1 ^ b0 << 6;
            this._out().output((char)codePoint);
            return 2;
        }

        private final int process3(int $this$process3, int b0, int b1) {
            boolean $i$f$debug;
            boolean $i$f$isContinuation;
            int $this$isContinuation$iv;
            EncoderFeed $this$debug$iv5;
            int b2 = $this$process3;
            if ((b0 & 0xF) == 0) {
                if ((b1 & 0xE0) != 160) {
                    int $this$debug$iv2 = $this$process3;
                    boolean $i$f$debug2 = false;
                    this.outputReplacementChar(this._out());
                    return 0;
                }
            } else if ((b0 & 0xF) == 13) {
                if ((b1 & 0xE0) != 128) {
                    int $this$debug$iv22 = $this$process3;
                    boolean $i$f$debug3 = false;
                    this.outputReplacementChar(this._out());
                    if (((Config)this.getConfig()).replacementStrategy.size != ReplacementStrategy.U_003F.size) {
                        return 0;
                    }
                    EncoderFeed $this$debug$iv22 = this;
                    int $this$isContinuation$iv2 = b2;
                    boolean $i$f$isContinuation2 = false;
                    if (($this$isContinuation$iv2 & 0xC0) == 128) {
                        return 3;
                    }
                    int $this$debug$iv32 = $this$process3;
                    $i$f$debug3 = false;
                    EncoderFeed $this$debug$iv32 = this;
                    $this$isContinuation$iv2 = b1;
                    $i$f$isContinuation2 = false;
                    if (($this$isContinuation$iv2 & 0xC0) == 128) {
                        return 1;
                    }
                    int $this$debug$iv4 = $this$process3;
                    $i$f$debug3 = false;
                    return 0;
                }
            } else {
                $this$debug$iv5 = this;
                $this$isContinuation$iv = b1;
                $i$f$isContinuation = false;
                if (!(($this$isContinuation$iv & 0xC0) == 128)) {
                    int $this$debug$iv5 = $this$process3;
                    $i$f$debug = false;
                    this.outputReplacementChar(this._out());
                    return 0;
                }
            }
            $this$debug$iv5 = this;
            $this$isContinuation$iv = b2;
            $i$f$isContinuation = false;
            if (!(($this$isContinuation$iv & 0xC0) == 128)) {
                int $this$debug$iv6 = $this$process3;
                $i$f$debug = false;
                this.outputReplacementChar(this._out());
                return 1;
            }
            int $this$debug$iv7 = $this$process3;
            $i$f$debug = false;
            int codePoint = 0xFFFE1F80 ^ b2 ^ b1 << 6 ^ b0 << 12;
            this._out().output((char)codePoint);
            return 3;
        }

        private final int process4(int $this$process4, int b0, int b1, int b2) {
            boolean $i$f$debug;
            int b3 = $this$process4;
            if ((b0 & 0xF) == 0) {
                if ((b1 & 0xF0) <= 128) {
                    int $this$debug$iv = $this$process4;
                    boolean $i$f$debug2 = false;
                    this.outputReplacementChar(this._out());
                    return 0;
                }
            } else if ((b0 & 0xF) == 4) {
                if ((b1 & 0xF0) != 128) {
                    int $this$debug$iv = $this$process4;
                    boolean $i$f$debug3 = false;
                    this.outputReplacementChar(this._out());
                    return 0;
                }
            } else if ((b0 & 0xF) > 4) {
                int $this$debug$iv = $this$process4;
                boolean $i$f$debug4 = false;
                this.outputReplacementChar(this._out());
                return 0;
            }
            EncoderFeed $this$debug$iv = this;
            int $this$isContinuation$iv = b1;
            boolean $i$f$isContinuation = false;
            if (!(($this$isContinuation$iv & 0xC0) == 128)) {
                int $this$debug$iv2 = $this$process4;
                $i$f$debug = false;
                this.outputReplacementChar(this._out());
                return 0;
            }
            $this$debug$iv = this;
            $this$isContinuation$iv = b2;
            $i$f$isContinuation = false;
            if (!(($this$isContinuation$iv & 0xC0) == 128)) {
                int $this$debug$iv3 = $this$process4;
                $i$f$debug = false;
                this.outputReplacementChar(this._out());
                return 1;
            }
            $this$debug$iv = this;
            $this$isContinuation$iv = b3;
            $i$f$isContinuation = false;
            if (!(($this$isContinuation$iv & 0xC0) == 128)) {
                int $this$debug$iv4 = $this$process4;
                $i$f$debug = false;
                this.outputReplacementChar(this._out());
                return 2;
            }
            int $this$debug$iv5 = $this$process4;
            $i$f$debug = false;
            int codePoint = 0x381F80 ^ b3 ^ b2 << 6 ^ b1 << 12 ^ b0 << 18;
            int hi = codePoint - 65536 >> 10 | 0xD800;
            int lo = codePoint & 0x3FF | 0xDC00;
            this._out().output((char)hi);
            this._out().output((char)lo);
            return 4;
        }

        private final boolean isContinuation(int $this$isContinuation) {
            boolean $i$f$isContinuation = false;
            return ($this$isContinuation & 0xC0) == 128;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/matthewnelson/encoding/utf8/UTF8$ReplacementStrategy;", "", "size", "", "(I)V", "toString", "", "Companion", "io.matthewnelson.encoding_utf8_jvm"})
    @SourceDebugExtension(value={"SMAP\nUTF8.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UTF8.kt\nio/matthewnelson/encoding/utf8/UTF8$ReplacementStrategy\n+ 2 -ReplacementStrategyJvm.kt\nio/matthewnelson/encoding/utf8/internal/_ReplacementStrategyJvmKt\n*L\n1#1,1101:1\n26#2:1102\n*S KotlinDebug\n*F\n+ 1 UTF8.kt\nio/matthewnelson/encoding/utf8/UTF8$ReplacementStrategy\n*L\n207#1:1102\n*E\n"})
    public static final class ReplacementStrategy {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        public final int size;
        @JvmField
        @NotNull
        public static final ReplacementStrategy U_003F = new ReplacementStrategy(1);
        @JvmField
        @NotNull
        public static final ReplacementStrategy U_FFFD = new ReplacementStrategy(3);
        @JvmField
        @NotNull
        public static final ReplacementStrategy KOTLIN;
        @JvmField
        @NotNull
        public static final ReplacementStrategy THROW;

        private ReplacementStrategy(int size) {
            this.size = size;
        }

        @NotNull
        public String toString() {
            int n = this.size;
            return n == ReplacementStrategy.U_003F.size ? "UTF8.ReplacementStrategy[U+003F]" : (n == ReplacementStrategy.U_FFFD.size ? "UTF8.ReplacementStrategy[U+FFFD]" : "UTF8.ReplacementStrategy[THROW]");
        }

        static {
            Companion companion = Companion;
            ReplacementStrategy replacementStrategy = U_003F;
            ReplacementStrategy U_FFFD$iv = U_FFFD;
            boolean $i$f$initializeKotlin = false;
            KOTLIN = replacementStrategy;
            THROW = new ReplacementStrategy(0);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/matthewnelson/encoding/utf8/UTF8$ReplacementStrategy$Companion;", "", "()V", "KOTLIN", "Lio/matthewnelson/encoding/utf8/UTF8$ReplacementStrategy;", "THROW", "U_003F", "U_FFFD", "io.matthewnelson.encoding_utf8_jvm"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/matthewnelson/encoding/utf8/UTF8$ThrowOnInvalid;", "Lio/matthewnelson/encoding/utf8/UTF8;", "()V", "io.matthewnelson.encoding_utf8_jvm"})
    public static final class ThrowOnInvalid
    extends UTF8 {
        @NotNull
        public static final ThrowOnInvalid INSTANCE = new ThrowOnInvalid();

        private ThrowOnInvalid() {
            super(Config.Companion.getTHROW$io_matthewnelson_encoding_utf8_jvm(), null);
        }
    }
}

