/*
 * Copyright 2026 ej-technologies GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package com.jprofiler.api.controller;

/**
 * Represents the type of elements to be tracked in probe tracking.
 * @see Controller#startProbeTracking(String, String[], ProbeObjectType, ProbeValueType)
 */
public enum ProbeObjectType {

    /**
     * The {@code descriptions} parameter of the {@link Controller#startProbeTracking(String, String[], ProbeObjectType, ProbeValueType) startProbeTracking}
     * method will contain IDs of control objects.
     */
    CONTROL_OBJECT_FROM_ID("control object from id"),

    /**
     * The {@code descriptions} parameter of the {@link Controller#startProbeTracking(String, String[], ProbeObjectType, ProbeValueType) startProbeTracking}
     * method will contain the names of control objects.
     */
    CONTROL_OBJECT_FROM_DESCRIPTION("control object from description"),

    /**
     * The {@code descriptions} parameter of the {@link Controller#startProbeTracking(String, String[], ProbeObjectType, ProbeValueType) startProbeTracking}
     * method will contain the names of hot spots.
     */
    HOTSPOT("hotspot");

    private final String description;

    ProbeObjectType(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return description;
    }
}
