/*
 * Copyright 2026 ej-technologies GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package com.jprofiler.api.probe.injected.parameter;

import com.jprofiler.api.probe.injected.interception.AdditionalInterception;
import com.jprofiler.api.probe.injected.interception.Interception;
import com.jprofiler.api.probe.injected.interception.InvocationType;
import com.jprofiler.api.probe.injected.interception.PayloadInterception;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Assigns the exception thrown by the intercepted method to a parameter of a probe method. The probe method can be annotated with {@link Interception}, {@link PayloadInterception} or {@link AdditionalInterception} whose
 * {@code invokeOn} argument is set to {@link InvocationType#EXIT} or {@link InvocationType#EXCEPTION}. The type of the annotated parameter must be {@code Throwable}.
 * <p>If {@code invokeOn} is set to {@link InvocationType#EXIT} and the instrumented method returns normally, the argument will be {@code null}.</p>
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.PARAMETER)
public @interface ExceptionValue {
}
