/*
 * Copyright 2026 ej-technologies GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package com.jprofiler.api.probe.injected.interception;

import com.jprofiler.api.probe.injected.parameter.ExceptionValue;
import com.jprofiler.api.probe.injected.parameter.ReturnValue;

/**
 * Specifies the point at which the probe method is invoked.
 */
public enum InvocationType {
    /**
     * The probe method will be called before any code of the intercepted method is called. You cannot use {@link ReturnValue} or {@link ExceptionValue} parameters
     * for methods of this type.
     */
    ENTER,
    /**
     * The probe method will be called when the intercepted method exits, either by returning normally or by throwing an exception. You can use both
     * {@link ReturnValue} and {@link ExceptionValue} parameters for methods of this type. If the intercepted method returns normally, the {@link ExceptionValue} parameter will be {@code null}.
     * If the method throws an exception, the {@link ReturnValue} parameter will be {@code null}.
     * <p>This type cannot be used for constructors.</p>
     */
    EXIT,
    /**
     * The probe method will be called when the intercepted method returns normally. You can use a {@link ReturnValue} parameter, but no {@link ExceptionValue} parameter for methods of this type.
     */
    RETURN,
    /**
     * The probe method will be called when the intercepted method throws an exception. You can use an {@link ExceptionValue} parameter, but no {@link ReturnValue} parameter for methods of this type.
     * <p>This type cannot be used for constructors.</p>
     */
    EXCEPTION
}
