package jlama;

import javax.swing.*;
import javax.swing.plaf.basic.BasicTextAreaUI;
import java.awt.*;

public class MultiLineTextDisplay extends JTextArea {
    public MultiLineTextDisplay(String text) {
        updateUI();
        setText(text);
        setLineWrap(true);
        setWrapStyleWord(true);
        setEditable(false);
        setRequestFocusEnabled(false);
        setFocusable(false);
        updateUI();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension minimumSize = super.getMinimumSize();
        if (!isMinimumSizeSet()) {
            minimumSize.width = 0;
        }
        return minimumSize;
    }

    @Override
    public final void processEvent(AWTEvent event) {
    }

    @Override
    public void updateUI() {
        setUI(new BasicTextAreaUI());
        invalidate();
        setFont(UIManager.getFont("Label.font"));
        setOpaque(false);
    }
}
