/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.probe.payload;

import com.jprofiler.agent.probe.d;
import com.jprofiler.agent.probe.g.h;
import com.jprofiler.agent.probe.k;
import com.jprofiler.agent.probe.structures.n;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public class BasePayloadInfo
implements Serializable,
Cloneable {
    public static final int CLASS_MARKER_PLAIN = 1;
    public static final int CLASS_MARKER_WITH_SECONDARY = 2;
    public static final int CLASS_MARKER_ADDITIONAL_2 = 3;
    public static final int CLASS_MARKER_ADDITIONAL_4 = 4;
    protected static final int OFFSET_DEFERRED = -10000;
    public static final int EXTERNAL_CALL_TREE_ID = Integer.MAX_VALUE;
    public static final int INVALID_CALL_TREE_ID = 0x7FFFFFFE;
    public static final int DATA_CALL_TREE_ID = 0;
    public static final int DATA_THREAD_ID = 1;
    public static final int DATA_RUNNABLE = 2;
    public static final int DATA_WAITING = 3;
    public static final int DATA_BLOCKED = 4;
    public static final int DATA_NETIO = 5;
    public static final int DATA_TIMESTAMP = 6;
    public static final int DATA_LENGTH = 7;
    protected int callTreeId;
    protected long threadId;
    protected long runnableMicro;
    protected long waitingMicro;
    protected long blockedMicro;
    protected long netioMicro;
    protected long timeStampMicro;
    protected int count = 1;
    protected Object descriptor;

    public static BasePayloadInfo createEmptyPayload() {
        return new BasePayloadInfo();
    }

    protected BasePayloadInfo() {
    }

    protected BasePayloadInfo(Object object) {
        this.descriptor = object;
    }

    protected BasePayloadInfo(h h2, String string) {
        this.setDescription(h2, string);
    }

    protected BasePayloadInfo(Object object, long l2, int n2, int n3) {
        this(object);
        this.setTime(n2, l2);
        this.count = n3;
    }

    public int getClassMarker() {
        return 1;
    }

    public void setCallTreeId(int n2) {
        this.callTreeId = n2;
    }

    public void setThreadId(long l2) {
        this.threadId = l2;
    }

    public void setRunnableMicro(long l2) {
        this.runnableMicro = l2;
    }

    public void setWaitingMicro(long l2) {
        this.waitingMicro = l2;
    }

    public void setBlockedMicro(long l2) {
        this.blockedMicro = l2;
    }

    public void setNetioMicro(long l2) {
        this.netioMicro = l2;
    }

    public void setTimeStampMicro(long l2) {
        this.timeStampMicro = l2;
    }

    public int getCallTreeId() {
        return this.callTreeId;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public long getRunnableMicro() {
        return this.runnableMicro;
    }

    public long getWaitingMicro() {
        return this.waitingMicro;
    }

    public long getBlockedMicro() {
        return this.blockedMicro;
    }

    public long getNetioMicro() {
        return this.netioMicro;
    }

    public long getTimeStampMicro() {
        return this.timeStampMicro;
    }

    public final int getPrimaryCount() {
        return this.count;
    }

    public final int getCount(n n2) {
        return this.getCount(n2.b());
    }

    public int getCount(int n2) {
        return this.count;
    }

    public final long getTime(n n2) {
        return this.getTime(n2.b());
    }

    public long getTime(int n2) {
        switch (n2) {
            case 1: {
                return this.getRunnableMicro();
            }
            case 2: {
                return this.getWaitingMicro();
            }
            case 3: {
                return this.getBlockedMicro();
            }
            case 5: {
                return this.getNetioMicro();
            }
            case 4: {
                return this.getRunnableMicro() + this.getWaitingMicro() + this.getBlockedMicro() + this.getNetioMicro();
            }
        }
        return this.getWaitingMicro();
    }

    public void setTime(int n2, long l2) {
        switch (n2) {
            case 1: {
                this.runnableMicro = l2;
                break;
            }
            case 2: {
                this.waitingMicro = l2;
                break;
            }
            case 3: {
                this.blockedMicro = l2;
                break;
            }
            case 5: {
                this.netioMicro = l2;
                break;
            }
            case 4: {
                this.runnableMicro = l2;
                break;
            }
            default: {
                this.waitingMicro = l2;
            }
        }
    }

    public void setAdditional(int n2, long l2, int n3) {
    }

    public String toString() {
        return "type: " + this.getType() + ", descr: " + this.getDescription() + ", count: " + this.getPrimaryCount() + ", ct: " + this.getCallTreeId() + ", tm: " + this.getThreadId() + ", r: " + this.getRunnableMicro() + ", w: " + this.getWaitingMicro() + ", b: " + this.getBlockedMicro() + ", n: " + this.getNetioMicro() + ", ts: " + this.getTimeStampMicro();
    }

    public void subtractTime(BasePayloadInfo basePayloadInfo) {
        this.runnableMicro -= basePayloadInfo.runnableMicro;
        this.waitingMicro -= basePayloadInfo.waitingMicro;
        this.blockedMicro -= basePayloadInfo.blockedMicro;
        this.netioMicro -= basePayloadInfo.netioMicro;
    }

    public void addTime(BasePayloadInfo basePayloadInfo, double d2) {
        this.runnableMicro += (long)((double)basePayloadInfo.runnableMicro * d2);
        this.waitingMicro += (long)((double)basePayloadInfo.waitingMicro * d2);
        this.blockedMicro += (long)((double)basePayloadInfo.blockedMicro * d2);
        this.netioMicro += (long)((double)basePayloadInfo.netioMicro * d2);
    }

    public void subtractCount(BasePayloadInfo basePayloadInfo) {
        this.count -= basePayloadInfo.count;
    }

    public void addCount(BasePayloadInfo basePayloadInfo) {
        this.count += basePayloadInfo.count;
    }

    public final void calcDifference(long[] lArray, boolean bl) {
        if (lArray[6] > this.getTimeStampMicro()) {
            this.runnableMicro = lArray[2] - this.runnableMicro;
            this.waitingMicro = lArray[3] - this.waitingMicro;
            this.blockedMicro = lArray[4] - this.blockedMicro;
            this.netioMicro = lArray[5] - this.netioMicro;
        } else {
            this.runnableMicro -= lArray[2];
            this.waitingMicro -= lArray[3];
            this.blockedMicro -= lArray[4];
            this.netioMicro -= lArray[5];
        }
        if (bl) {
            this.callTreeId = (int)lArray[0];
            this.threadId = lArray[1];
        }
    }

    public Collection<? extends BasePayloadInfo> getSecondaryPayloads() {
        return null;
    }

    public int getType() {
        return 0;
    }

    public k getJProfilerDescriptor() {
        return this.descriptor instanceof k ? (k)this.descriptor : null;
    }

    public void write(DataOutput dataOutput, boolean bl) throws IOException {
        dataOutput.writeShort(this.getType());
        dataOutput.writeInt(this.descriptor == null ? 0 : this.getJProfilerDescriptor().b());
        dataOutput.writeInt(this.count);
        dataOutput.writeLong(this.callTreeId);
        dataOutput.writeLong(this.threadId);
        dataOutput.writeLong(this.runnableMicro);
        dataOutput.writeLong(this.waitingMicro);
        dataOutput.writeLong(this.blockedMicro);
        dataOutput.writeLong(this.netioMicro);
        dataOutput.writeLong(this.timeStampMicro);
    }

    public void multiplyTime(double d2) {
        this.runnableMicro = (long)((double)this.runnableMicro * d2);
        this.waitingMicro = (long)((double)this.waitingMicro * d2);
        this.blockedMicro = (long)((double)this.blockedMicro * d2);
        this.netioMicro = (long)((double)this.netioMicro * d2);
    }

    public void merge(BasePayloadInfo basePayloadInfo) {
        this.runnableMicro += basePayloadInfo.runnableMicro;
        this.waitingMicro += basePayloadInfo.waitingMicro;
        this.blockedMicro += basePayloadInfo.blockedMicro;
        this.netioMicro += basePayloadInfo.netioMicro;
        this.timeStampMicro = basePayloadInfo.timeStampMicro;
        this.count += basePayloadInfo.count;
    }

    public synchronized void mergeAsync(BasePayloadInfo basePayloadInfo) {
        this.runnableMicro += basePayloadInfo.runnableMicro;
        this.waitingMicro += basePayloadInfo.waitingMicro;
        this.blockedMicro += basePayloadInfo.blockedMicro;
        this.netioMicro += basePayloadInfo.netioMicro;
        this.timeStampMicro = basePayloadInfo.timeStampMicro;
        this.count += basePayloadInfo.count;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BasePayloadInfo)) {
            return false;
        }
        BasePayloadInfo basePayloadInfo = (BasePayloadInfo)object;
        if (!this.isDescriptionEqual(basePayloadInfo)) {
            return false;
        }
        return this.callTreeId == basePayloadInfo.callTreeId && this.threadId == basePayloadInfo.threadId && this.getType() == basePayloadInfo.getType();
    }

    protected boolean isDescriptionEqual(BasePayloadInfo basePayloadInfo) {
        if (this.descriptor == null) {
            return basePayloadInfo.descriptor == null;
        }
        if (this.descriptor.toString() == null) {
            return basePayloadInfo.descriptor != null && basePayloadInfo.descriptor.toString() == null;
        }
        return basePayloadInfo.descriptor != null && this.descriptor.toString().equals(basePayloadInfo.descriptor.toString());
    }

    public int hashCode() {
        int n2 = this.descriptor != null && this.descriptor.toString() != null ? this.descriptor.toString().hashCode() : 0;
        n2 = 29 * n2 + this.callTreeId;
        n2 = 29 * n2 + (int)(this.threadId ^ this.threadId >>> 32);
        n2 = 29 * n2 + this.getType();
        return n2;
    }

    public final String getDescription() {
        return this.descriptor == null ? "" : this.descriptor.toString();
    }

    public final void setDescription(h h2, String string) {
        this.descriptor = h2.f().d(string);
    }

    public Object getMemento() {
        return null;
    }

    public void setMemento(Object object) {
    }

    public BasePayloadInfo calculateTime(h h2) {
        h2.f().e(this);
        return this;
    }

    public BasePayloadInfo discardTime() {
        this.runnableMicro = 0L;
        this.waitingMicro = 0L;
        this.blockedMicro = 0L;
        this.netioMicro = 0L;
        return this;
    }

    public Object getDescriptor() {
        return this.descriptor;
    }

    public void substractVmStartTime(long l2) {
        this.timeStampMicro -= l2;
        if (this.timeStampMicro < 0L) {
            this.timeStampMicro = 0L;
        }
    }

    public void setDeferred() {
        if (this.getCallTreeId() > 0) {
            this.setCallTreeId(-this.getCallTreeId());
        }
    }

    public void clear() {
        this.discardTime();
        this.count = 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public void setCount(int n2) {
        this.count = n2;
    }

    public void addAllDescriptors(Map<String, k> map) {
        if (this.descriptor instanceof k && this.descriptor.toString() != null) {
            map.put(this.descriptor.toString(), (k)this.descriptor);
        }
    }

    public boolean isInvalid() {
        return this.callTreeId == 0x7FFFFFFE;
    }

    public void copyData(long[] lArray) {
        this.callTreeId = (int)lArray[0];
        this.threadId = lArray[1];
        this.runnableMicro = lArray[2];
        this.waitingMicro = lArray[3];
        this.blockedMicro = lArray[4];
        this.netioMicro = lArray[5];
        this.timeStampMicro = lArray[6];
    }

    public void copyData(d d2) {
        this.callTreeId = d2.a();
        this.threadId = d2.b();
        this.timeStampMicro = d2.c();
    }

    public void copyData(BasePayloadInfo basePayloadInfo, int n2) {
        this.runnableMicro = basePayloadInfo.runnableMicro / (long)n2;
        this.waitingMicro = basePayloadInfo.waitingMicro / (long)n2;
        this.blockedMicro = basePayloadInfo.blockedMicro / (long)n2;
        this.netioMicro = basePayloadInfo.netioMicro / (long)n2;
        this.callTreeId = basePayloadInfo.callTreeId;
        this.threadId = basePayloadInfo.threadId;
        this.timeStampMicro = basePayloadInfo.timeStampMicro;
    }

    public void copyTiming(long[] lArray) {
        this.runnableMicro = lArray[2];
        this.waitingMicro = lArray[3];
        this.blockedMicro = lArray[4];
        this.netioMicro = lArray[5];
        this.timeStampMicro = lArray[6];
    }

    public void setTimestamp(long l2) {
        this.timeStampMicro = l2;
    }

    public boolean isDeferred() {
        return false;
    }

    public void calcDifference(long[] lArray) {
        if (this.callTreeId == 0) {
            this.callTreeId = (int)lArray[0];
        }
        if (lArray[6] > this.getTimeStampMicro()) {
            this.runnableMicro = lArray[2] - this.runnableMicro;
            this.waitingMicro = lArray[3] - this.waitingMicro;
            this.blockedMicro = lArray[4] - this.blockedMicro;
            this.netioMicro = lArray[5] - this.netioMicro;
        } else {
            this.runnableMicro -= lArray[2];
            this.waitingMicro -= lArray[3];
            this.blockedMicro -= lArray[4];
            this.netioMicro -= lArray[5];
        }
    }

    public void writeData(DataOutputStream dataOutputStream, int n2, com.jprofiler.agent.probe.g.d d2) throws IOException {
        k k2 = this.getJProfilerDescriptor();
        d2.a(k2);
        dataOutputStream.writeInt(k2.b());
        dataOutputStream.writeInt(this.getCount(n2));
        this.writeTimedCount(dataOutputStream);
        dataOutputStream.writeLong(this.getTime(n2));
        Collection<? extends BasePayloadInfo> collection = this.getSecondaryPayloads();
        if (collection != null) {
            for (BasePayloadInfo basePayloadInfo : collection) {
                dataOutputStream.writeBoolean(true);
                dataOutputStream.writeInt(basePayloadInfo.getType());
                k k3 = basePayloadInfo.getJProfilerDescriptor();
                dataOutputStream.writeInt(k3.b());
                dataOutputStream.writeInt(basePayloadInfo.getCount(n2));
                dataOutputStream.writeLong(basePayloadInfo.getTime(n2));
                d2.a(k3);
            }
        }
        dataOutputStream.writeBoolean(false);
    }

    protected void writeTimedCount(DataOutputStream dataOutputStream) throws IOException {
    }

    public long getRequestedCallTreeId() {
        throw new UnsupportedOperationException("getRequestedCallTreeId not supported");
    }

    public void setRequestedCallTreeId(long l2) {
        throw new UnsupportedOperationException("setRequestedCallTreeId not supported");
    }

    public void deferredPayloadTree(boolean bl) {
        throw new UnsupportedOperationException("deferredPayloadTree not supported");
    }
}

