/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.FileDropListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class FileDrop {
    private static final boolean SUPPORTS_DND;
    private DropTargetListener dropListener;

    public static void addTo(JComponent component, FileDropListener listener) {
        if (!InstallerUtil.isUnattended() && !InstallerUtil.isConsole()) {
            new FileDrop(component, listener);
        }
    }

    public FileDrop(final Component c, final FileDropListener listener) {
        if (SUPPORTS_DND) {
            this.dropListener = new DropTargetListener(){

                @Override
                public void dragEnter(DropTargetDragEvent event) {
                    if (FileDrop.this.isDragOk(event)) {
                        event.acceptDrag(1);
                    } else {
                        event.rejectDrag();
                    }
                }

                @Override
                public void dragOver(DropTargetDragEvent event) {
                }

                @Override
                public void drop(DropTargetDropEvent event) {
                    try {
                        Transferable tr = event.getTransferable();
                        if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            event.acceptDrop(1);
                            List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                            if (!fileList.isEmpty()) {
                                File file = (File)fileList.get(0);
                                if (listener != null) {
                                    listener.fileDropped(file);
                                } else if (c instanceof JTextField) {
                                    ((JTextField)c).setText(file.getPath());
                                }
                            }
                            event.getDropTargetContext().dropComplete(true);
                        } else {
                            DataFlavor[] flavors = tr.getTransferDataFlavors();
                            boolean handled = false;
                            for (DataFlavor flavor : flavors) {
                                if (!flavor.isRepresentationClassReader()) continue;
                                event.acceptDrop(1);
                                event.getDropTargetContext().dropComplete(true);
                                handled = true;
                                break;
                            }
                            if (!handled) {
                                event.rejectDrop();
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        event.rejectDrop();
                    }
                }

                @Override
                public void dragExit(DropTargetEvent evt) {
                }

                @Override
                public void dropActionChanged(DropTargetDragEvent evt) {
                    if (FileDrop.this.isDragOk(evt)) {
                        evt.acceptDrag(1);
                    } else {
                        evt.rejectDrag();
                    }
                }
            };
            this.makeDropTarget(c);
        }
    }

    private void makeDropTarget(Component c) {
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        c.addHierarchyListener(evt -> {
            Container parent = c.getParent();
            if (parent == null) {
                c.setDropTarget(null);
            } else {
                new DropTarget(c, this.dropListener);
            }
        });
        if (c.getParent() != null) {
            new DropTarget(c, this.dropListener);
        }
    }

    private boolean isDragOk(DropTargetDragEvent evt) {
        DataFlavor[] flavors;
        for (DataFlavor flavor : flavors = evt.getCurrentDataFlavors()) {
            if (!flavor.equals(DataFlavor.javaFileListFlavor) && !flavor.isRepresentationClassReader()) continue;
            return true;
        }
        return false;
    }

    static {
        boolean support;
        try {
            Class.forName("java.awt.dnd.DnDConstants");
            support = true;
        }
        catch (Exception e) {
            support = false;
        }
        SUPPORTS_DND = support;
    }
}

