/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.windows;

import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.RegistryView;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.platform.win32.Registry;
import java.io.Serializable;

public class WinRegistry {
    public static boolean keyExists(RegistryRoot root, String keyName) {
        return WinRegistry.keyExists(root, keyName, RegistryView.DEFAULT);
    }

    public static boolean createKey(RegistryRoot root, String keyName) {
        return WinRegistry.createKey(root, keyName, RegistryView.DEFAULT);
    }

    public static Object getValue(RegistryRoot root, String keyName, String valueName) {
        return WinRegistry.getValue(root, keyName, valueName, RegistryView.DEFAULT);
    }

    public static boolean setValue(RegistryRoot root, String keyName, String valueName, Object value) {
        return WinRegistry.setValue(root, keyName, valueName, value, RegistryView.DEFAULT);
    }

    public static void deleteValue(RegistryRoot root, String keyName, String valueName) {
        WinRegistry.deleteValue(root, keyName, valueName, RegistryView.DEFAULT);
    }

    public static void deleteKey(RegistryRoot root, String keyName, boolean onlyIfEmpty) {
        WinRegistry.deleteKey(root, keyName, onlyIfEmpty, RegistryView.DEFAULT);
    }

    public static String[] getSubKeyNames(RegistryRoot root, String keyName) {
        return WinRegistry.getSubKeyNames(root, keyName, RegistryView.DEFAULT);
    }

    public static String[] getValueNames(RegistryRoot root, String keyName) {
        return WinRegistry.getValueNames(root, keyName, RegistryView.DEFAULT);
    }

    public static boolean saveKey(RegistryRoot root, String keyName, String fileName) {
        return WinRegistry.saveKey(root, keyName, fileName, RegistryView.DEFAULT);
    }

    public static boolean restoreKey(RegistryRoot root, String keyName, String fileName) {
        return WinRegistry.restoreKey(root, keyName, fileName, RegistryView.DEFAULT);
    }

    public static boolean keyExists(RegistryRoot root, String keyName, RegistryView registryView) {
        if (WinRegistry.isUnelevate(root)) {
            return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, context -> WinRegistry.keyExists(root, keyName, registryView));
        }
        return Registry.keyExists(root.getType(), keyName, registryView.getUsedType());
    }

    public static boolean createKey(RegistryRoot root, String keyName, RegistryView registryView) {
        if (WinRegistry.isUnelevate(root)) {
            return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, context -> WinRegistry.createKey(root, keyName, registryView));
        }
        return Registry.createKey(root.getType(), keyName, registryView.getUsedType());
    }

    public static Object getValue(RegistryRoot root, String keyName, String valueName, RegistryView registryView) {
        if (WinRegistry.isUnelevate(root)) {
            return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, context -> WinRegistry.getValue(root, keyName, valueName, registryView));
        }
        return Registry.getValue(root.getType(), keyName, valueName, registryView.getUsedType());
    }

    public static boolean setValue(RegistryRoot root, String keyName, String valueName, Object value, RegistryView registryView) {
        if (WinRegistry.isUnelevate(root)) {
            return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, context -> WinRegistry.setValue(root, keyName, valueName, value, registryView));
        }
        Object usedValue = value instanceof ExpandString ? new Registry.ExpandStringImpl(((ExpandString)value).getValue()) : value;
        return Registry.setValue(root.getType(), keyName, valueName, usedValue, registryView.getUsedType());
    }

    public static void deleteValue(RegistryRoot root, String keyName, String valueName, RegistryView registryView) {
        if (WinRegistry.isUnelevate(root)) {
            HelperCommunication.getInstance().runAction(ExecutionContext.UNELEVATED, context -> WinRegistry.deleteValue(root, keyName, valueName, registryView));
        } else {
            Registry.deleteValue(root.getType(), keyName, valueName, registryView.getUsedType());
        }
    }

    public static void deleteKey(RegistryRoot root, String keyName, boolean onlyIfEmpty, RegistryView registryView) {
        if (WinRegistry.isUnelevate(root)) {
            HelperCommunication.getInstance().runAction(ExecutionContext.UNELEVATED, context -> WinRegistry.deleteKey(root, keyName, onlyIfEmpty, registryView));
        } else {
            Registry.deleteKey(root.getType(), keyName, onlyIfEmpty, registryView.getUsedType());
        }
    }

    public static String[] getSubKeyNames(RegistryRoot root, String keyName, RegistryView registryView) {
        if (WinRegistry.isUnelevate(root)) {
            return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, context -> WinRegistry.getSubKeyNames(root, keyName, registryView));
        }
        return Registry.enumSubKeys(root.getType(), keyName, registryView.getUsedType());
    }

    public static String[] getValueNames(RegistryRoot root, String keyName, RegistryView registryView) {
        if (WinRegistry.isUnelevate(root)) {
            return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, context -> WinRegistry.getValueNames(root, keyName, registryView));
        }
        return Registry.enumValues(root.getType(), keyName, registryView.getUsedType());
    }

    public static boolean saveKey(RegistryRoot root, String keyName, String fileName, RegistryView registryView) {
        if (WinRegistry.isUnelevate(root)) {
            return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, context -> WinRegistry.saveKey(root, keyName, fileName, registryView));
        }
        return Registry.saveKey(root.getType(), keyName, fileName, registryView.getUsedType());
    }

    public static boolean restoreKey(RegistryRoot root, String keyName, String fileName, RegistryView registryView) {
        if (WinRegistry.isUnelevate(root)) {
            return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, context -> WinRegistry.restoreKey(root, keyName, fileName, registryView));
        }
        return Registry.restoreKey(root.getType(), keyName, fileName, registryView.getUsedType());
    }

    private static boolean isUnelevate(RegistryRoot root) {
        return HelperCommunication.getInstance().isElevatedHelper() && root == RegistryRoot.HKEY_CURRENT_USER;
    }

    private WinRegistry() {
    }

    public static class ExpandString
    implements Serializable {
        private String value;

        public ExpandString(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

