/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime.util;

import com.exe4j.runtime.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WinDel {
    public static final String PROP_NAME_SEMAPHORE_NAME = "exe4j.semaphoreName";
    public static final String SEMAPHORE_NAME = System.getProperty("exe4j.semaphoreName");
    private static final String REBOOT_DELETION = "reboot_deletion";
    private static final String NO_REBOOT_DELETION = "no_reboot_deletion";
    private static final String FORCE_REBOOT = "force_reboot";
    public static final String I4JDEL_FILENAME = "i4jdel.exe";
    private static final String I4JDEL_TARGET_NAME = "i4jdel";
    private static final String EXTERNAL_EXECUTABLE_PREFIX_PARAMETER = "__i4j_windel";
    private static File i4jdelTempFile;
    public static final String LOGFILE_PROPERTY_NAME = "windel.logfile";
    private static boolean used;
    private static boolean reboot;
    private static String rebootMessage;
    private static String rebootErrorMessage;
    private static List<File> usedFiles;
    private static List<File> usedDirs;
    private static final String EOSMARKER = "EOSMARKER";
    static String externalExecutable;
    private static Launcher launcher;

    public static void prepareDeletion(File delSourceFile) throws IOException {
        if (externalExecutable == null && i4jdelTempFile == null) {
            int i = 0;
            boolean nameFound = false;
            while (!nameFound && i < 50) {
                i4jdelTempFile = new File(System.getProperty("java.io.tmpdir"), I4JDEL_TARGET_NAME + i++ + ".exe");
                try {
                    FileUtil.copyFile(delSourceFile, i4jdelTempFile);
                    nameFound = true;
                }
                catch (IOException iOException) {}
            }
            if (!nameFound) {
                i4jdelTempFile = File.createTempFile("i4jd", ".exe");
                FileUtil.copyFile(delSourceFile, i4jdelTempFile);
            }
        }
    }

    public static void setRebootMessage(String rebootMessage, String rebootErrorMessage) {
        WinDel.rebootMessage = rebootMessage;
        WinDel.rebootErrorMessage = rebootErrorMessage;
    }

    public static void setReboot(boolean reboot) {
        WinDel.reboot = reboot;
    }

    public static void scheduleDeletion(Collection<File> files, Collection<File> dirs, boolean addOnly) throws IOException {
        usedFiles.addAll(files);
        usedDirs.addAll(dirs);
        if (addOnly) {
            return;
        }
        used = true;
        String externalLogFileName = System.getProperty(LOGFILE_PROPERTY_NAME);
        File logFile = externalLogFileName == null ? File.createTempFile("i4j", null) : new File(externalLogFileName);
        FileOutputStream out = new FileOutputStream(logFile);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-16LE"));
        pw.println(SEMAPHORE_NAME);
        if (externalLogFileName == null) {
            if (reboot) {
                pw.println(FORCE_REBOOT);
            } else if (Boolean.getBoolean("install4j.noRebootDeletion")) {
                pw.println(NO_REBOOT_DELETION);
            } else {
                pw.println(REBOOT_DELETION);
            }
            pw.println(rebootMessage);
            pw.println(EOSMARKER);
            pw.println(rebootErrorMessage);
            pw.println(EOSMARKER);
        }
        for (File file : usedFiles) {
            pw.println(file.getAbsolutePath());
        }
        pw.println();
        for (File file : usedDirs) {
            pw.println(file.getAbsolutePath());
        }
        pw.close();
        String[] launchCommand = externalExecutable != null ? new String[]{externalExecutable, EXTERNAL_EXECUTABLE_PREFIX_PARAMETER, logFile.getAbsolutePath()} : new String[]{i4jdelTempFile.getAbsolutePath(), logFile.getName()};
        if (externalLogFileName == null) {
            for (int i = 0; i < 10; ++i) {
                try {
                    launcher.launch(launchCommand);
                    return;
                }
                catch (IOException e) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            System.err.println("Could not run additional delete process");
        }
    }

    public static void setUsed(boolean used) {
        WinDel.used = used;
    }

    public static boolean isUsed() {
        return used;
    }

    public static void setLauncher(Launcher launcher) {
        WinDel.launcher = launcher;
    }

    static {
        rebootMessage = "";
        rebootErrorMessage = "";
        usedFiles = new ArrayList<File>();
        usedDirs = new ArrayList<File>();
        launcher = new Launcher(){

            @Override
            public void launch(String ... command) throws IOException {
                new ProcessBuilder(command).start();
            }
        };
    }

    public static interface Launcher {
        public void launch(String ... var1) throws IOException;
    }
}

