/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Resource;
import com.jidesoft.swing.SearchableProvider;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.swing.event.SearchableEvent;
import com.jidesoft.swing.event.SearchableListener;
import com.jidesoft.utils.DefaultWildcardSupport;
import com.jidesoft.utils.WildcardSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class Searchable {
    private final PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);
    protected final JComponent _component;
    private SearchPopup _popup;
    private JLayeredPane _layeredPane;
    private boolean _heavyweightComponentEnabled;
    private SearchableProvider _searchableProvider;
    private Pattern _pattern;
    private String _searchText;
    private String _previousSearchText;
    private boolean _fromStart = true;
    private boolean _caseSensitive = false;
    private boolean _repeats = false;
    private boolean _wildcardEnabled = true;
    private boolean _countMatch;
    protected int _matchCount;
    private WildcardSupport _wildcardSupport = null;
    private Color _mismatchForeground;
    private Color _foreground = null;
    private Color _background = null;
    protected ComponentListener _componentListener;
    protected KeyListener _keyListener;
    protected FocusListener _focusListener;
    private SearchableListener _searchableListener;
    public static final String PROPERTY_SEARCH_TEXT = "searchText";
    private int _cursor = -1;
    private String _searchLabel = null;
    private int _popupLocation = 1;
    private int _searchingDelay = 0;
    private int _popupTimeout = 0;
    private Timer _popupTimer;
    private boolean _reverseOrder = false;
    protected EventListenerList listenerList = new EventListenerList();
    private Component _popupLocationRelativeTo;
    public static final String CLIENT_PROPERTY_SEARCHABLE = "Searchable";
    private Set<Integer> _selection;
    private boolean _processModelChangeEvent = true;
    private boolean _hideSearchPopupOnEvent = true;

    public Searchable(JComponent jComponent) {
        Searchable searchable = Searchable.getSearchable(jComponent);
        if (searchable != null) {
            SearchableUtils.uninstallSearchable(searchable);
        }
        this._previousSearchText = null;
        this._component = jComponent;
        this._selection = new HashSet<Integer>();
        this.installListeners();
        this.updateClientProperty(this._component, this);
    }

    public Searchable(JComponent jComponent, SearchableProvider searchableProvider) {
        Searchable searchable = Searchable.getSearchable(jComponent);
        if (searchable != null) {
            SearchableUtils.uninstallSearchable(searchable);
        }
        this._searchableProvider = searchableProvider;
        this._previousSearchText = null;
        this._component = jComponent;
        this._selection = new HashSet<Integer>();
        this.installListeners();
        this.updateClientProperty(this._component, this);
    }

    protected abstract int getSelectedIndex();

    protected abstract void setSelectedIndex(int var1, boolean var2);

    public void adjustSelectedIndex(int n2, boolean bl2) {
        this.setSelectedIndex(n2, bl2);
    }

    protected abstract int getElementCount();

    protected abstract Object getElementAt(int var1);

    protected abstract String convertElementToString(Object var1);

    public String convertToString(Object object) {
        return this.convertElementToString(object);
    }

    public boolean isHideSearchPopupOnEvent() {
        return this._hideSearchPopupOnEvent;
    }

    public void setHideSearchPopupOnEvent(boolean bl2) {
        this._hideSearchPopupOnEvent = bl2;
    }

    public void hidePopup() {
        if (this._popup != null) {
            if (this.isHeavyweightComponentEnabled()) {
                this._popup.hidePopupImmediately();
            } else if (this._layeredPane != null) {
                this._layeredPane.remove(this._popup);
                this._layeredPane.validate();
                this._layeredPane.repaint();
                this._layeredPane = null;
            }
            this._popup = null;
            this._searchableProvider = null;
            this._previousSearchText = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3000, "", this.getCurrentIndex(), this._previousSearchText));
        }
        this.setCursor(-1);
    }

    public SearchableProvider getSearchableProvider() {
        return this._searchableProvider;
    }

    public void setSearchableProvider(SearchableProvider searchableProvider) {
        this._searchableProvider = searchableProvider;
    }

    public void installListeners() {
        if (this._componentListener == null) {
            this._componentListener = this.createComponentListener();
        }
        this._component.addComponentListener(this._componentListener);
        Component component = JideSwingUtilities.getScrollPane(this._component);
        if (component != null) {
            component.addComponentListener(this._componentListener);
        }
        if (this._keyListener == null) {
            this._keyListener = this.createKeyListener();
        }
        JideSwingUtilities.insertKeyListener(this.getComponent(), this._keyListener, 0);
        if (this._focusListener == null) {
            this._focusListener = this.createFocusListener();
        }
        if (this._focusListener != null) {
            this.getComponent().addFocusListener(this._focusListener);
        }
        if (this._searchableListener == null) {
            this._searchableListener = new SearchableListener(){

                @Override
                public void searchableEventFired(SearchableEvent searchableEvent) {
                    if (searchableEvent.getID() == 2999) {
                        if (Searchable.this.getPopupTimeout() > 0) {
                            Searchable.this._popupTimer = new Timer(Searchable.this.getPopupTimeout(), new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    if (Searchable.this.isPopupVisible()) {
                                        Searchable.this.hidePopup();
                                    }
                                }
                            });
                            Searchable.this._popupTimer.setRepeats(false);
                            Searchable.this._popupTimer.start();
                        }
                    } else if (Searchable.this._popupTimer != null) {
                        if (searchableEvent.getID() == 3000) {
                            Searchable.this._popupTimer.stop();
                        } else {
                            Searchable.this._popupTimer.restart();
                        }
                    }
                }
            };
        }
        this.addSearchableListener(this._searchableListener);
    }

    protected ComponentListener createComponentListener() {
        return new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                boolean bl2;
                super.componentHidden(componentEvent);
                boolean bl3 = bl2 = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (bl2) {
                    Searchable.this.hidePopup();
                }
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                boolean bl2;
                super.componentResized(componentEvent);
                boolean bl3 = bl2 = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (bl2) {
                    Searchable.this.updateSizeAndLocation();
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                boolean bl2;
                super.componentMoved(componentEvent);
                boolean bl3 = bl2 = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (bl2) {
                    Searchable.this.updateSizeAndLocation();
                }
            }
        };
    }

    protected KeyListener createKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                boolean bl2;
                boolean bl3 = bl2 = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (bl2) {
                    Searchable.this.keyTypedOrPressed(keyEvent);
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                boolean bl2;
                boolean bl3 = bl2 = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (bl2) {
                    Searchable.this.keyTypedOrPressed(keyEvent);
                }
            }
        };
    }

    protected FocusListener createFocusListener() {
        return new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                boolean bl2;
                boolean bl3 = bl2 = Searchable.this._searchableProvider == null || Searchable.this._searchableProvider.isPassive();
                if (bl2) {
                    Timer timer = new Timer(1000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            Searchable.this.hidePopup();
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
        };
    }

    public void uninstallListeners() {
        if (this._componentListener != null) {
            this.getComponent().removeComponentListener(this._componentListener);
            Component component = JideSwingUtilities.getScrollPane(this.getComponent());
            if (component != null) {
                component.removeComponentListener(this._componentListener);
            }
            this._componentListener = null;
        }
        if (this._keyListener != null) {
            this.getComponent().removeKeyListener(this._keyListener);
            this._keyListener = null;
        }
        if (this._focusListener != null) {
            this.getComponent().removeFocusListener(this._focusListener);
            this._focusListener = null;
        }
        if (this._searchableListener != null) {
            this.removeSearchableListener(this._searchableListener);
            this._searchableListener = null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChangeEvent(String string) {
        if (!string.equals(this._previousSearchText)) {
            this._propertyChangeSupport.firePropertyChange(PROPERTY_SEARCH_TEXT, this._previousSearchText, string);
            this.fireSearchableEvent(new SearchableEvent(this, 3004, string, this.getCurrentIndex(), this._previousSearchText));
            this._previousSearchText = string;
            if (string.length() == 0) {
                this.searchingTextEmpty();
            }
        }
    }

    protected void searchingTextEmpty() {
    }

    protected boolean compare(Object object, String string) {
        String string2 = this.convertElementToString(object);
        return string2 != null && this.compare(this.isCaseSensitive() ? string2 : string2.toLowerCase(), string);
    }

    protected boolean compare(String string, String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            return true;
        }
        if (!this.isWildcardEnabled()) {
            return string2 != null && (string2.equals(string) || string2.length() > 0 && (this.isFromStart() ? string.startsWith(string2) : string.indexOf(string2) != -1));
        }
        if (this._searchText != null && this._searchText.equals(string2) && this._pattern != null) {
            return this._pattern.matcher(string).find();
        }
        WildcardSupport wildcardSupport = this.getWildcardSupport();
        String string3 = wildcardSupport.convert(string2);
        if (string2.equals(string3)) {
            return this.isFromStart() ? string.startsWith(string2) : string.indexOf(string2) != -1;
        }
        this._searchText = string2;
        try {
            this._pattern = Pattern.compile((String)(this.isFromStart() ? "^" + string3 : string3), this.isCaseSensitive() ? 0 : 2);
            return this._pattern.matcher(string).find();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public int getCursor() {
        return this._cursor;
    }

    public void setCursor(int n2) {
        this.setCursor(n2, false);
    }

    public void setCursor(int n2, boolean bl2) {
        if (!bl2 || this._cursor < 0) {
            this._selection.clear();
        }
        if (this._cursor >= 0) {
            this._selection.add(n2);
        }
        this._cursor = n2;
    }

    protected void highlightAll() {
        int n2 = -1;
        int n3 = this.getSelectedIndex();
        String string = this.getSearchingText();
        while (n3 != -1) {
            int n4 = this.findNext(string);
            if ((n3 = n3 == n4 ? -1 : n4) == -1) continue;
            if (n2 == -1) {
                n2 = n3;
            }
            this.select(n3, string);
        }
        if (n2 != -1) {
            this.select(n2, string);
        }
    }

    protected void cancelHighlightAll() {
    }

    protected void select(int n2, String string) {
        if (n2 != -1) {
            this.setSelectedIndex(n2, true);
            this.setCursor(n2, true);
            Object object = this.getElementAt(n2);
            this.fireSearchableEvent(new SearchableEvent(this, 3002, string, object, this.convertElementToString(object)));
        } else {
            this.setSelectedIndex(-1, false);
            this.fireSearchableEvent(new SearchableEvent(this, 3003, string));
        }
    }

    public int findNext(String string) {
        Object object;
        int n2;
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n3 = this.getElementCount();
        if (n3 == 0) {
            return string.length() > 0 ? -1 : 0;
        }
        int n4 = this.getCurrentIndex();
        for (n2 = n4 + 1; n2 < n3; ++n2) {
            object = this.getElementAt(n2);
            if (!this.compare(object, string2)) continue;
            return n2;
        }
        if (this.isRepeats()) {
            for (n2 = 0; n2 < n4; ++n2) {
                object = this.getElementAt(n2);
                if (!this.compare(object, string2)) continue;
                return n2;
            }
        }
        return n4 == -1 ? -1 : (this.compare(this.getElementAt(n4), string2) ? n4 : -1);
    }

    protected int getCurrentIndex() {
        if (this._selection.contains(this.getSelectedIndex())) {
            return this._cursor != -1 ? this._cursor : this.getSelectedIndex();
        }
        this._selection.clear();
        return this.getSelectedIndex();
    }

    public int findPrevious(String string) {
        Object object;
        int n2;
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n3 = this.getElementCount();
        if (n3 == 0) {
            return string.length() > 0 ? -1 : 0;
        }
        int n4 = this.getCurrentIndex();
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            object = this.getElementAt(n2);
            if (!this.compare(object, string2)) continue;
            return n2;
        }
        if (this.isRepeats()) {
            for (n2 = n3 - 1; n2 >= n4; --n2) {
                object = this.getElementAt(n2);
                if (!this.compare(object, string2)) continue;
                return n2;
            }
        }
        return n4 == -1 ? -1 : (this.compare(this.getElementAt(n4), string2) ? n4 : -1);
    }

    public int findFromCursor(String string) {
        Object object;
        int n2;
        int n3;
        int n4;
        if (this.isCountMatch()) {
            boolean bl2 = this.isReverseOrder();
            this.setReverseOrder(false);
            n4 = this.getCurrentIndex();
            if (n4 < 0) {
                n4 = 0;
            }
            n3 = -1;
            this._matchCount = -1;
            do {
                this.setSelectedIndex(n3, false);
                n2 = n3;
                n3 = this.findNext(string);
                ++this._matchCount;
            } while (n3 > n2);
            this.setSelectedIndex(n4, false);
            this.setReverseOrder(bl2);
        }
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(string);
        }
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        n4 = this.getCurrentIndex();
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n2 = this.getElementCount()) == 0) {
            return -1;
        }
        for (n3 = n4; n3 < n2; ++n3) {
            object = this.getElementAt(n3);
            if (!this.compare(object, string2)) continue;
            return n3;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            object = this.getElementAt(n3);
            if (!this.compare(object, string2)) continue;
            return n3;
        }
        return -1;
    }

    public int reverseFindFromCursor(String string) {
        Object object;
        int n2;
        int n3;
        if (!this.isReverseOrder()) {
            return this.findFromCursor(string);
        }
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n4 = this.getCurrentIndex();
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n3 = this.getElementCount()) == 0) {
            return -1;
        }
        for (n2 = n4; n2 >= 0; --n2) {
            object = this.getElementAt(n2);
            if (!this.compare(object, string2)) continue;
            return n2;
        }
        for (n2 = n3 - 1; n2 >= n4; --n2) {
            object = this.getElementAt(n2);
            if (!this.compare(object, string2)) continue;
            return n2;
        }
        return -1;
    }

    public int findFirst(String string) {
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n2 = this.getElementCount();
        if (n2 == 0) {
            return string.length() > 0 ? -1 : 0;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.getIndex(n2, i2);
            Object object = this.getElementAt(n3);
            if (!this.compare(object, string2)) continue;
            return n3;
        }
        return -1;
    }

    public int findLast(String string) {
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n2 = this.getElementCount();
        if (n2 == 0) {
            return string.length() > 0 ? -1 : 0;
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            Object object = this.getElementAt(i2);
            if (!this.compare(object, string2)) continue;
            return i2;
        }
        return -1;
    }

    protected void keyTypedOrPressed(KeyEvent keyEvent) {
        if (this._searchableProvider != null && this._searchableProvider.isPassive()) {
            this._searchableProvider.processKeyEvent(keyEvent);
            return;
        }
        if (this.isActivateKey(keyEvent)) {
            String string = "";
            if (keyEvent.getID() == 400) {
                if (JideSwingUtilities.isMenuShortcutKeyDown(keyEvent)) {
                    return;
                }
                if (keyEvent.isAltDown()) {
                    return;
                }
                string = String.valueOf(keyEvent.getKeyChar());
            }
            this.showPopup(string);
            if (keyEvent.getKeyCode() != 10) {
                keyEvent.consume();
            }
        }
    }

    private int getIndex(int n2, int n3) {
        return this.isReverseOrder() ? n2 - n3 - 1 : n3;
    }

    public void showPopup(String string) {
        if (this._searchableProvider == null) {
            this.fireSearchableEvent(new SearchableEvent(this, 2999, string));
            this.showPopup(this.createSearchPopup(string));
            this._searchableProvider = new SearchableProvider(){

                @Override
                public String getSearchingText() {
                    return Searchable.this._popup != null ? Searchable.this._popup.getSearchingText() : "";
                }

                @Override
                public boolean isPassive() {
                    return true;
                }

                @Override
                public void processKeyEvent(KeyEvent keyEvent) {
                    if (Searchable.this._popup != null) {
                        Searchable.this._popup.processKeyEvent(keyEvent);
                    }
                }
            };
        }
    }

    protected SearchPopup createSearchPopup(String string) {
        return new DefaultSearchPopup(string);
    }

    public String getSearchingText() {
        return this._searchableProvider != null ? this._searchableProvider.getSearchingText() : "";
    }

    private void showPopup(SearchPopup searchPopup) {
        JRootPane jRootPane = this._component.getRootPane();
        this._layeredPane = jRootPane != null ? jRootPane.getLayeredPane() : null;
        if (this._layeredPane == null || this.isHeavyweightComponentEnabled()) {
            this._popup = searchPopup;
            Point point = this.updateSizeAndLocation();
            if (point != null) {
                searchPopup.showPopup(point.x, point.y);
                this._popup.setVisible(true);
            } else {
                this._popup = null;
            }
        } else {
            if (this._popup != null && this._layeredPane != null) {
                this._layeredPane.remove(this._popup);
                this._layeredPane.validate();
                this._layeredPane.repaint();
                this._layeredPane = null;
            } else {
                this._popup = !this._component.isShowing() ? null : searchPopup;
            }
            if (this._popup == null || !this._component.isDisplayable()) {
                return;
            }
            if (this._layeredPane == null) {
                System.err.println("Failed to find layeredPane.");
                return;
            }
            this._layeredPane.add((Component)this._popup, JLayeredPane.POPUP_LAYER);
            this.updateSizeAndLocation();
            this._popup.setVisible(true);
            this._popup.validate();
        }
        if (this._popup != null) {
            this._popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    Searchable.this._popup = null;
                    Searchable.this._searchableProvider = null;
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
    }

    private Point updateSizeAndLocation() {
        Component component = this.getPopupLocationRelativeTo();
        if (component == null) {
            component = JideSwingUtilities.getScrollPane(this._component);
        }
        if (component == null) {
            component = this._component;
        }
        if (this._popup != null) {
            Point point;
            Dimension dimension = this._popup.getPreferredSize();
            switch (this.getPopupLocation()) {
                case 3: {
                    try {
                        point = component.getLocationOnScreen();
                        point.y += component.getHeight();
                        if (this.isHeavyweightComponentEnabled()) break;
                        SwingUtilities.convertPointFromScreen(point, this._layeredPane);
                        if (point.y + dimension.height <= this._layeredPane.getHeight()) break;
                        point.y = this._layeredPane.getHeight() - dimension.height;
                        break;
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        return null;
                    }
                }
                default: {
                    try {
                        point = component.getLocationOnScreen();
                        if (!this.isHeavyweightComponentEnabled()) {
                            SwingUtilities.convertPointFromScreen(point, this._layeredPane);
                        }
                        point.y -= dimension.height;
                        if (point.y >= 0) break;
                        point.y = 0;
                        break;
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        return null;
                    }
                }
            }
            if (!this.isHeavyweightComponentEnabled()) {
                this._popup.setLocation(point);
                this._popup.setSize(dimension);
            } else {
                this._popup.packPopup();
            }
            return point;
        }
        return null;
    }

    protected boolean isFindFirstKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 36;
    }

    protected boolean isFindLastKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 35;
    }

    protected boolean isFindPreviousKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 38;
    }

    protected boolean isFindNextKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 40;
    }

    protected boolean isNavigationKey(KeyEvent keyEvent) {
        return this.isFindFirstKey(keyEvent) || this.isFindLastKey(keyEvent) || this.isFindNextKey(keyEvent) || this.isFindPreviousKey(keyEvent);
    }

    protected boolean isActivateKey(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        return keyEvent.getID() == 400 && c2 > ' ' && c2 != '\u007f';
    }

    protected boolean isDeactivateKey(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        return n2 == 10 || n2 == 27 || n2 == 33 || n2 == 34 || n2 == 36 || n2 == 35 || n2 == 37 || n2 == 39 || n2 == 38 || n2 == 40;
    }

    protected boolean isSelectAllKey(KeyEvent keyEvent) {
        return JideSwingUtilities.isMenuShortcutKeyDown(keyEvent) && keyEvent.getKeyCode() == 65;
    }

    protected boolean isIncrementalSelectKey(KeyEvent keyEvent) {
        return JideSwingUtilities.isMenuShortcutKeyDown(keyEvent);
    }

    public Color getMismatchForeground() {
        if (this._mismatchForeground == null) {
            return Color.RED;
        }
        return this._mismatchForeground;
    }

    public void setMismatchForeground(Color color) {
        this._mismatchForeground = color;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean bl2) {
        this._caseSensitive = bl2;
    }

    public int getSearchingDelay() {
        return this._searchingDelay;
    }

    public void setSearchingDelay(int n2) {
        this._searchingDelay = n2;
    }

    public boolean isRepeats() {
        return this._repeats;
    }

    public void setRepeats(boolean bl2) {
        this._repeats = bl2;
    }

    public Color getForeground() {
        if (this._foreground == null) {
            return UIDefaultsLookup.getColor("ToolTip.foreground");
        }
        return this._foreground;
    }

    public void setForeground(Color color) {
        this._foreground = color;
    }

    public Color getBackground() {
        if (this._background == null) {
            return UIDefaultsLookup.getColor("ToolTip.background");
        }
        return this._background;
    }

    public void setBackground(Color color) {
        this._background = color;
    }

    public boolean isWildcardEnabled() {
        return this._wildcardEnabled;
    }

    public void setWildcardEnabled(boolean bl2) {
        this._wildcardEnabled = bl2;
    }

    public WildcardSupport getWildcardSupport() {
        if (this._wildcardSupport == null) {
            this._wildcardSupport = new DefaultWildcardSupport();
        }
        return this._wildcardSupport;
    }

    public void setWildcardSupport(WildcardSupport wildcardSupport) {
        this._wildcardSupport = wildcardSupport;
    }

    public String getSearchLabel() {
        if (this._searchLabel == null) {
            return this.getResourceString("Searchable.searchFor");
        }
        return this._searchLabel;
    }

    public void setSearchLabel(String string) {
        this._searchLabel = string;
    }

    public void addSearchableListener(SearchableListener searchableListener) {
        this.listenerList.add(SearchableListener.class, searchableListener);
    }

    public void removeSearchableListener(SearchableListener searchableListener) {
        this.listenerList.remove(SearchableListener.class, searchableListener);
    }

    public SearchableListener[] getSearchableListeners() {
        return (SearchableListener[])this.listenerList.getListeners(SearchableListener.class);
    }

    public boolean isSearchableListenerInstalled(SearchableListener searchableListener) {
        SearchableListener[] searchableListenerArray;
        for (SearchableListener searchableListener2 : searchableListenerArray = this.getSearchableListeners()) {
            if (searchableListener2 != searchableListener) continue;
            return true;
        }
        return false;
    }

    protected void fireSearchableEvent(SearchableEvent searchableEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != SearchableListener.class) continue;
            ((SearchableListener)objectArray[i2 + 1]).searchableEventFired(searchableEvent);
        }
    }

    public Component getComponent() {
        return this._component;
    }

    public int getPopupLocation() {
        return this._popupLocation;
    }

    public void setPopupLocation(int n2) {
        this._popupLocation = n2;
    }

    public boolean isReverseOrder() {
        return this._reverseOrder;
    }

    public void setReverseOrder(boolean bl2) {
        this._reverseOrder = bl2;
    }

    protected String getResourceString(String string) {
        return Resource.getResourceBundle(this._component != null ? this._component.getLocale() : Locale.getDefault()).getString(string);
    }

    public boolean isPopupVisible() {
        return this._popup != null;
    }

    public boolean isHeavyweightComponentEnabled() {
        return this._heavyweightComponentEnabled;
    }

    public void setHeavyweightComponentEnabled(boolean bl2) {
        this._heavyweightComponentEnabled = bl2;
    }

    public Component getPopupLocationRelativeTo() {
        return this._popupLocationRelativeTo;
    }

    public void setPopupLocationRelativeTo(Component component) {
        this._popupLocationRelativeTo = component;
    }

    public boolean isFromStart() {
        return this._fromStart;
    }

    public void setFromStart(boolean bl2) {
        this.hidePopup();
        this._fromStart = bl2;
    }

    public static Searchable getSearchable(JComponent jComponent) {
        Object object = jComponent.getClientProperty(CLIENT_PROPERTY_SEARCHABLE);
        if (object instanceof Searchable) {
            return (Searchable)object;
        }
        return null;
    }

    private void updateClientProperty(JComponent jComponent, Searchable searchable) {
        if (jComponent != null) {
            Object object = this._component.getClientProperty(CLIENT_PROPERTY_SEARCHABLE);
            if (object instanceof Searchable) {
                ((Searchable)object).uninstallListeners();
            }
            jComponent.putClientProperty(CLIENT_PROPERTY_SEARCHABLE, searchable);
        }
    }

    public boolean isProcessModelChangeEvent() {
        return this._processModelChangeEvent;
    }

    public void setProcessModelChangeEvent(boolean bl2) {
        this._processModelChangeEvent = bl2;
    }

    public int getPopupTimeout() {
        return this._popupTimeout;
    }

    public void setPopupTimeout(int n2) {
        this._popupTimeout = n2;
    }

    public boolean isCountMatch() {
        return this._countMatch;
    }

    public void setCountMatch(boolean bl2) {
        this._countMatch = bl2;
    }

    int getMatchCount() {
        return this._matchCount;
    }

    public List<Integer> findAll(String string) {
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = this.getElementCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = this.getElementAt(i2);
            if (!this.compare(object, string2)) continue;
            arrayList.add(i2);
        }
        return arrayList;
    }

    public String getElementAtAsString(int n2) {
        return this.convertElementToString(this.getElementAt(n2));
    }

    protected void textChanged(String string) {
        if (string == null || string.length() == 0) {
            this.firePropertyChangeEvent("");
            return;
        }
        int n2 = this.findFromCursor(string);
        if (n2 == -1) {
            this.firePropertyChangeEvent(string);
            this.fireSearchableEvent(new SearchableEvent(this, 3003, string));
        } else {
            this.firePropertyChangeEvent(string);
            Object object = this.getElementAt(n2);
            this.fireSearchableEvent(new SearchableEvent(this, 3002, string, object, this.convertElementToString(object)));
        }
    }

    public int findFirstExactly(String string) {
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        int n2 = this.getElementCount();
        if (n2 == 0) {
            return string.length() > 0 ? -1 : 0;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.getIndex(n2, i2);
            Object object = this.getElementAt(n3);
            String string3 = this.convertElementToString(object);
            if (!JideSwingUtilities.equals(string3, string2)) continue;
            return n3;
        }
        return -1;
    }

    public abstract class SearchPopup
    extends JidePopup {
        protected SearchField _textField;

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            this._textField.processKeyEvent(keyEvent);
            if (keyEvent.isConsumed()) {
                String string = this.getSearchingText();
                if (string.length() == 0) {
                    return;
                }
                if (Searchable.this.isSelectAllKey(keyEvent)) {
                    this.selectAll(keyEvent, string);
                    return;
                }
                if (Searchable.this.isFindPreviousKey(keyEvent)) {
                    int n2 = Searchable.this.findPrevious(string);
                    this.select(n2, keyEvent, string);
                } else if (Searchable.this.isFindNextKey(keyEvent)) {
                    int n3 = Searchable.this.findNext(string);
                    this.select(n3, keyEvent, string);
                } else if (Searchable.this.isFindFirstKey(keyEvent)) {
                    int n4 = Searchable.this.findFirst(string);
                    this.select(n4, keyEvent, string);
                } else if (Searchable.this.isFindLastKey(keyEvent)) {
                    int n5 = Searchable.this.findLast(string);
                    this.select(n5, keyEvent, string);
                }
            }
            if (keyEvent.getKeyCode() != 10) {
                keyEvent.consume();
            }
        }

        private void selectAll(KeyEvent keyEvent, String string) {
            int n2;
            boolean bl2;
            int n3;
            boolean bl3 = Searchable.this.isReverseOrder();
            if (bl3) {
                Searchable.this.setReverseOrder(false);
            }
            if ((n3 = Searchable.this.findFirst(string)) != -1) {
                Searchable.this.setSelectedIndex(n3, false);
                Searchable.this.setCursor(n3);
            }
            if (bl2 = Searchable.this.isRepeats()) {
                Searchable.this.setRepeats(false);
            }
            while (n3 != -1 && (n3 = n3 == (n2 = Searchable.this.findNext(string)) ? -1 : n2) != -1) {
                this.select(n3, keyEvent, string);
            }
            if (bl2) {
                Searchable.this.setRepeats(bl2);
            }
            if (bl3) {
                Searchable.this.setReverseOrder(bl3);
            }
        }

        public String getSearchingText() {
            return this._textField != null ? this._textField.getText() : "";
        }

        public JTextField getTextField() {
            return this._textField;
        }

        protected abstract void select(int var1, KeyEvent var2, String var3);
    }

    public class DefaultSearchPopup
    extends SearchPopup {
        private JLabel _label;
        private JLabel _noMatch;

        public DefaultSearchPopup(String string) {
            this.initComponents(string);
        }

        private void initComponents(String string) {
            final Color color = Searchable.this.getForeground();
            Color color2 = Searchable.this.getBackground();
            this._label = new JLabel(Searchable.this.getSearchLabel());
            this._label.setForeground(color);
            this._label.setVerticalAlignment(3);
            this._noMatch = new JLabel();
            this._noMatch.setForeground(Searchable.this.getMismatchForeground());
            this._noMatch.setVerticalAlignment(3);
            this._textField = new SearchField();
            this._textField.setFocusable(false);
            this._textField.setBorder(BorderFactory.createEmptyBorder());
            this._textField.setForeground(color);
            this._textField.setCursor(this.getCursor());
            this._textField.getDocument().addDocumentListener(new DocumentListener(){
                private Timer timer = new Timer(200, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.applyText();
                    }
                });

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.startTimer();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.startTimer();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.startTimer();
                }

                protected void applyText() {
                    String string = DefaultSearchPopup.this._textField.getText();
                    Searchable.this.firePropertyChangeEvent(string);
                    if (string.length() != 0) {
                        int n2 = Searchable.this.findFromCursor(string);
                        if (n2 == -1) {
                            DefaultSearchPopup.this._textField.setForeground(Searchable.this.getMismatchForeground());
                        } else {
                            DefaultSearchPopup.this._textField.setForeground(color);
                        }
                        DefaultSearchPopup.this.select(n2, null, string);
                    } else {
                        DefaultSearchPopup.this._textField.setForeground(color);
                        DefaultSearchPopup.this._noMatch.setText("");
                        DefaultSearchPopup.this.updatePopupBounds();
                        DefaultSearchPopup.this.hidePopup();
                    }
                }

                void startTimer() {
                    DefaultSearchPopup.this.updatePopupBounds();
                    if (Searchable.this.getSearchingDelay() > 0) {
                        this.timer.setInitialDelay(Searchable.this.getSearchingDelay());
                        if (this.timer.isRunning()) {
                            this.timer.restart();
                        } else {
                            this.timer.setRepeats(false);
                            this.timer.start();
                        }
                    } else {
                        this.applyText();
                    }
                }
            });
            this._textField.setText(string);
            this.setBackground(color2);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIDefaultsLookup.getColor("controlShadow"), 1), BorderFactory.createEmptyBorder(0, 6, 1, 8)));
            this.setLayout(new BorderLayout(2, 0));
            Dimension dimension = this._label.getPreferredSize();
            dimension.height = this._textField.getPreferredSize().height;
            this._label.setPreferredSize(dimension);
            this.add((Component)this._label, "Before");
            this.add((Component)this._textField, "Center");
            this.add((Component)this._noMatch, "After");
            this.setPopupBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        protected void select(int n2, KeyEvent keyEvent, String string) {
            if (n2 != -1) {
                boolean bl2 = keyEvent != null && Searchable.this.isIncrementalSelectKey(keyEvent);
                Searchable.this.setSelectedIndex(n2, bl2);
                Searchable.this.setCursor(n2, bl2);
                this._textField.setForeground(Searchable.this.getForeground());
                this._noMatch.setText("");
            } else {
                this._textField.setForeground(Searchable.this.getMismatchForeground());
                this._noMatch.setText(Searchable.this.getResourceString("Searchable.noMatch"));
            }
            this.updatePopupBounds();
            if (n2 != -1) {
                Object object = Searchable.this.getElementAt(n2);
                Searchable.this.fireSearchableEvent(new SearchableEvent(Searchable.this, 3002, string, object, Searchable.this.convertElementToString(object)));
            } else {
                Searchable.this.fireSearchableEvent(new SearchableEvent(Searchable.this, 3003, string));
            }
        }

        private void updatePopupBounds() {
            if (Searchable.this._popup != null) {
                this._textField.invalidate();
                try {
                    if (!Searchable.this.isHeavyweightComponentEnabled()) {
                        Dimension dimension = this._noMatch.getPreferredSize();
                        dimension.width += this._label.getPreferredSize().width;
                        dimension.width += new JLabel((String)this._textField.getText()).getPreferredSize().width + 24;
                        dimension.height = ((Searchable)Searchable.this)._popup.getSize().height;
                        Searchable.this._popup.setSize(dimension);
                        Searchable.this._popup.validate();
                    } else {
                        Searchable.this._popup.packPopup();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected class SearchField
    extends JTextField {
        SearchField() {
            JideSwingUtilities.setComponentTransparent(this);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + 4;
            return dimension;
        }

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            int n2 = keyEvent.getKeyCode();
            if (n2 == 8 && this.getDocument().getLength() == 0) {
                keyEvent.consume();
                return;
            }
            boolean bl2 = Searchable.this.isNavigationKey(keyEvent);
            if (Searchable.this.isDeactivateKey(keyEvent) && !bl2) {
                Searchable.this.hidePopup();
                if (n2 == 27) {
                    keyEvent.consume();
                }
                return;
            }
            super.processKeyEvent(keyEvent);
            if (n2 == 8 || bl2) {
                keyEvent.consume();
            }
            if (Searchable.this.isSelectAllKey(keyEvent)) {
                keyEvent.consume();
            }
        }
    }
}

