/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import sun.swing.CachedPainter;

public class MetalUtils {
    static void drawFlush3DBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
        graphics.drawRect(0, 0, n4 - 2, n5 - 2);
        graphics.setColor(MetalLookAndFeel.getControlHighlight());
        graphics.drawRect(1, 1, n4 - 2, n5 - 2);
        graphics.setColor(MetalLookAndFeel.getControl());
        graphics.drawLine(0, n5 - 1, 1, n5 - 2);
        graphics.drawLine(n4 - 1, 0, n4 - 2, 1);
        graphics.translate(-n2, -n3);
    }

    static void drawPressed3DBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        MetalUtils.drawFlush3DBorder(graphics, 0, 0, n4, n5);
        graphics.setColor(MetalLookAndFeel.getControlShadow());
        graphics.drawLine(1, 1, 1, n5 - 2);
        graphics.drawLine(1, 1, n4 - 2, 1);
        graphics.translate(-n2, -n3);
    }

    static void drawActiveButtonBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        MetalUtils.drawFlush3DBorder(graphics, n2, n3, n4, n5);
        graphics.setColor(MetalLookAndFeel.getPrimaryControl());
        graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n5 - 3);
        graphics.drawLine(n2 + 1, n3 + 1, n4 - 3, n2 + 1);
        graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
        graphics.drawLine(n2 + 2, n5 - 2, n4 - 2, n5 - 2);
        graphics.drawLine(n4 - 2, n3 + 2, n4 - 2, n5 - 2);
    }

    static boolean drawGradient(Component component, Graphics graphics, String string, int n2, int n3, int n4, int n5, boolean bl2) {
        List list = (List)UIManager.get(string);
        if (list == null || !(graphics instanceof Graphics2D)) {
            return false;
        }
        if (n4 <= 0 || n5 <= 0) {
            return true;
        }
        GradientPainter.INSTANCE.paint(component, (Graphics2D)graphics, list, n2, n3, n4, n5, bl2);
        return true;
    }

    private static class GradientPainter
    extends CachedPainter {
        public static final GradientPainter INSTANCE = new GradientPainter(8);
        private static final int IMAGE_SIZE = 64;
        private int w;
        private int h;

        GradientPainter(int n2) {
            super(n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Component component, Graphics2D graphics2D, List list, int n2, int n3, int n4, int n5, boolean bl2) {
            int n6;
            int n7;
            if (bl2) {
                n7 = 64;
                n6 = n5;
            } else {
                n7 = n4;
                n6 = 64;
            }
            Object object = component.getTreeLock();
            synchronized (object) {
                this.w = n4;
                this.h = n5;
                this.paint(component, (Graphics)graphics2D, n2, n3, n7, n6, list, bl2);
            }
        }

        @Override
        protected void paintToImage(Component component, Image image, Graphics graphics, int n2, int n3, Object[] objectArray) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            List list = (List)objectArray[0];
            boolean bl2 = (Boolean)objectArray[1];
            if (bl2) {
                this.drawVerticalGradient(graphics2D, ((Number)list.get(0)).floatValue(), ((Number)list.get(1)).floatValue(), (Color)list.get(2), (Color)list.get(3), (Color)list.get(4), n2, n3);
            } else {
                this.drawHorizontalGradient(graphics2D, ((Number)list.get(0)).floatValue(), ((Number)list.get(1)).floatValue(), (Color)list.get(2), (Color)list.get(3), (Color)list.get(4), n2, n3);
            }
        }

        @Override
        protected void paintImage(Component component, Graphics graphics, int n2, int n3, int n4, int n5, Image image, Object[] objectArray) {
            boolean bl2 = (Boolean)objectArray[1];
            graphics.translate(n2, n3);
            if (bl2) {
                for (int i2 = 0; i2 < this.w; i2 += 64) {
                    int n6 = Math.min(64, this.w - i2);
                    graphics.drawImage(image, i2, 0, i2 + n6, this.h, 0, 0, n6, this.h, null);
                }
            } else {
                for (int i3 = 0; i3 < this.h; i3 += 64) {
                    int n7 = Math.min(64, this.h - i3);
                    graphics.drawImage(image, 0, i3, this.w, i3 + n7, 0, 0, this.w, n7, null);
                }
            }
            graphics.translate(-n2, -n3);
        }

        private void drawVerticalGradient(Graphics2D graphics2D, float f2, float f3, Color color, Color color2, Color color3, int n2, int n3) {
            int n4 = (int)(f2 * (float)n3);
            int n5 = (int)(f3 * (float)n3);
            if (n4 > 0) {
                graphics2D.setPaint(this.getGradient(0.0f, 0.0f, color, 0.0f, n4, color2));
                graphics2D.fillRect(0, 0, n2, n4);
            }
            if (n5 > 0) {
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, n4, n2, n5);
            }
            if (n4 > 0) {
                graphics2D.setPaint(this.getGradient(0.0f, (float)n4 + (float)n5, color2, 0.0f, (float)n4 * 2.0f + (float)n5, color));
                graphics2D.fillRect(0, n4 + n5, n2, n4);
            }
            if (n3 - n4 * 2 - n5 > 0) {
                graphics2D.setPaint(this.getGradient(0.0f, (float)n4 * 2.0f + (float)n5, color, 0.0f, n3, color3));
                graphics2D.fillRect(0, n4 * 2 + n5, n2, n3 - n4 * 2 - n5);
            }
        }

        private void drawHorizontalGradient(Graphics2D graphics2D, float f2, float f3, Color color, Color color2, Color color3, int n2, int n3) {
            int n4 = (int)(f2 * (float)n2);
            int n5 = (int)(f3 * (float)n2);
            if (n4 > 0) {
                graphics2D.setPaint(this.getGradient(0.0f, 0.0f, color, n4, 0.0f, color2));
                graphics2D.fillRect(0, 0, n4, n3);
            }
            if (n5 > 0) {
                graphics2D.setColor(color2);
                graphics2D.fillRect(n4, 0, n5, n3);
            }
            if (n4 > 0) {
                graphics2D.setPaint(this.getGradient((float)n4 + (float)n5, 0.0f, color2, (float)n4 * 2.0f + (float)n5, 0.0f, color));
                graphics2D.fillRect(n4 + n5, 0, n4, n3);
            }
            if (n2 - n4 * 2 - n5 > 0) {
                graphics2D.setPaint(this.getGradient((float)n4 * 2.0f + (float)n5, 0.0f, color, n2, 0.0f, color3));
                graphics2D.fillRect(n4 * 2 + n5, 0, n2 - n4 * 2 - n5, n3);
            }
        }

        private GradientPaint getGradient(float f2, float f3, Color color, float f4, float f5, Color color2) {
            return new GradientPaint(f2, f3, color, f4, f5, color2, true);
        }
    }
}

