/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import com.formdev.flatlaf.util.ScaledImageIcon;
import com.jidesoft.icons.ColorFilter;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.icons.TintFilter;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class IconsFactory {
    static final double DEGREE_90 = 1.5707963267948966;
    public static ImageIcon EMPTY_ICON = new ImageIcon(){
        private static final long serialVersionUID = 5081581607741629368L;

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public synchronized void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }
    };
    static Map<String, ImageIcon> _icons = new HashMap<String, ImageIcon>();
    static Map<String, ImageIcon> _disableIcons = new HashMap<String, ImageIcon>();
    static Map<String, ImageIcon> _brighterIcons = new HashMap<String, ImageIcon>();
    static Map<String, ImageIcon> _tintedIcons = new HashMap<String, ImageIcon>();

    public static ImageIcon getImageIcon(Class<?> clazz, String string) {
        String string2 = clazz.getName() + ":" + string;
        Object object = UIManager.getDefaults().get(string2);
        if (object instanceof ImageIcon) {
            return (ImageIcon)object;
        }
        ImageIcon imageIcon = _icons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        ImageIcon imageIcon2 = IconsFactory.createImageIcon(clazz, string);
        _icons.put(string2, imageIcon2);
        return imageIcon2;
    }

    public static Icon getScaledIcon(Class<?> clazz, String string) {
        if (LookAndFeelFactory.isFlatLnfInstalled()) {
            return new ScaledImageIcon(IconsFactory.getImageIcon(clazz, string));
        }
        return IconsFactory.getImageIcon(clazz, string);
    }

    public static ImageIcon findImageIcon(Class<?> clazz, String string) throws IOException {
        String string2 = clazz.getName() + ":" + string;
        Object object = UIManager.getDefaults().get(string2);
        if (object instanceof ImageIcon) {
            return (ImageIcon)object;
        }
        ImageIcon imageIcon = _icons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        ImageIcon imageIcon2 = IconsFactory.createImageIconWithException(clazz, string);
        _icons.put(string2, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon getDisabledImageIcon(Class<?> clazz, String string) {
        String string2 = clazz.getName() + ":" + string;
        ImageIcon imageIcon = _disableIcons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        ImageIcon imageIcon2 = IconsFactory.createGrayImage(IconsFactory.getImageIcon(clazz, string));
        _disableIcons.put(string2, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon getBrighterImageIcon(Class<?> clazz, String string) {
        String string2 = clazz.getName() + ":" + string + ":" + ColorFilter.getPercent();
        ImageIcon imageIcon = _brighterIcons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        ImageIcon imageIcon2 = IconsFactory.createBrighterImage(IconsFactory.getImageIcon(clazz, string));
        _brighterIcons.put(string2, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon getBrighterImageIcon(Class<?> clazz, String string, int n2) {
        String string2 = clazz.getName() + ":" + string + ":" + n2;
        ImageIcon imageIcon = _brighterIcons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        ImageIcon imageIcon2 = IconsFactory.createBrighterImage(IconsFactory.getImageIcon(clazz, string), n2);
        _brighterIcons.put(string2, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon getTintedImageIcon(Class<?> clazz, String string, Color color) {
        String string2 = clazz.getName() + ":" + string + ":" + color.toString();
        ImageIcon imageIcon = _tintedIcons.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        ImageIcon imageIcon2 = IconsFactory.createTintedImage(IconsFactory.getImageIcon(clazz, string), color);
        _tintedIcons.put(string2, imageIcon2);
        return imageIcon2;
    }

    public static ImageIcon createGrayImage(Image image) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(GrayFilter.createDisabledImage(image));
    }

    private static ImageIcon createGrayImage(ImageIcon imageIcon) {
        if (imageIcon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(GrayFilter.createDisabledImage(imageIcon.getImage()));
    }

    public static ImageIcon createGrayImage(Component component, Icon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        int n2 = icon.getIconWidth();
        int n3 = icon.getIconHeight();
        if (n2 == 0 || n3 == 0) {
            return EMPTY_ICON;
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(GrayFilter.createDisabledImage(bufferedImage));
    }

    public static ImageIcon createBrighterImage(Image image) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(image));
    }

    public static ImageIcon createBrighterImage(Image image, int n2) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(image, n2));
    }

    public static ImageIcon createBrighterImage(Component component, Icon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(ColorFilter.createBrighterImage(bufferedImage));
    }

    public static ImageIcon createBrighterImage(Component component, Icon icon, int n2) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(ColorFilter.createBrighterImage(bufferedImage, n2));
    }

    public static ImageIcon createBrighterImage(ImageIcon imageIcon) {
        if (imageIcon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(imageIcon.getImage()));
    }

    public static ImageIcon createBrighterImage(ImageIcon imageIcon, int n2) {
        if (imageIcon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(imageIcon.getImage(), n2));
    }

    public static ImageIcon createTintedImage(ImageIcon imageIcon, Color color) {
        if (imageIcon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(TintFilter.createTintedImage(imageIcon.getImage(), color, null));
    }

    public static ImageIcon createNegativeImage(Image image) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(MaskFilter.createNegativeImage(image));
    }

    public static ImageIcon createMaskImage(Component component, Icon icon, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(MaskFilter.createImage(bufferedImage, color, color2));
    }

    public static ImageIcon createRotatedImage(Component component, Icon icon, double d2) {
        int n2;
        int n3;
        double d3 = d2 % 360.0;
        if (d2 != 0.0 && d3 == 0.0) {
            d3 = 360.0;
        }
        double d4 = d3 % 90.0;
        if (d3 != 0.0 && d4 == 0.0) {
            d4 = 90.0;
        }
        double d5 = Math.toRadians(d4);
        int n4 = icon.getIconWidth();
        int n5 = icon.getIconHeight();
        if (d3 >= 0.0 && d3 <= 90.0 || d3 > 180.0 && d3 <= 270.0) {
            n3 = (int)Math.round((double)n4 * Math.sin(1.5707963267948966 - d5) + (double)n5 * Math.sin(d5));
            n2 = (int)Math.round((double)n4 * Math.sin(d5) + (double)n5 * Math.sin(1.5707963267948966 - d5));
        } else {
            n3 = (int)((double)n5 * Math.sin(1.5707963267948966 - d5) + (double)n4 * Math.sin(d5));
            n2 = (int)((double)n5 * Math.sin(d5) + (double)n4 * Math.sin(1.5707963267948966 - d5));
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n2, 2);
        Graphics graphics = bufferedImage.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n6 = n4 / 2;
        int n7 = n5 / 2;
        int n8 = n4 % 2 != 0 && d3 >= 90.0 && d3 <= 180.0 ? 1 : 0;
        int n9 = n4 % 2 != 0 && d3 >= 180.0 && d3 < 360.0 ? 1 : 0;
        graphics2D.translate(n3 / 2 + n8, n2 / 2 + n9);
        graphics2D.rotate(Math.toRadians(d3));
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        icon.paintIcon(component, graphics2D, -n6, -n7);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon createNegativeImage(Component component, Icon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(MaskFilter.createNegativeImage(bufferedImage));
    }

    private static ImageIcon createImageIcon(Class<?> clazz, String string) {
        try {
            return IconsFactory.createImageIconWithException(clazz, string);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getLocalizedMessage());
            return null;
        }
    }

    private static ImageIcon createImageIconWithException(Class<?> clazz, String string) throws IOException {
        Image image;
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException(string);
        }
        String string2 = IconsFactory.addSuffixToFilename(string, "@2x");
        String string3 = IconsFactory.addSuffixToFilename(string, "@3x");
        InputStream inputStream2 = clazz.getResourceAsStream(string2);
        InputStream inputStream3 = clazz.getResourceAsStream(string3);
        Image image2 = null;
        Image image3 = null;
        if ("true".equals(SecurityUtils.getProperty("jide.useImageIO", "true"))) {
            image = ImageIO.read(inputStream);
            if (inputStream2 != null) {
                image2 = ImageIO.read(inputStream2);
            }
            if (inputStream3 != null) {
                image3 = ImageIO.read(inputStream3);
            }
        } else {
            image = IconsFactory.readImageIcon(clazz, string, inputStream);
            if (inputStream2 != null) {
                image2 = IconsFactory.readImageIcon(clazz, string, inputStream2);
            }
            if (inputStream3 != null) {
                image3 = IconsFactory.readImageIcon(clazz, string, inputStream3);
            }
        }
        try {
            inputStream.close();
            if (inputStream2 != null) {
                inputStream2.close();
            }
            if (inputStream3 != null) {
                inputStream3.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (image2 == null && image3 == null) {
            return new ImageIcon(image);
        }
        if (image3 == null) {
            return new ImageIcon(new BaseMultiResolutionImage(image, image2));
        }
        return new ImageIcon(new BaseMultiResolutionImage(image, image2, image3));
    }

    public static String addSuffixToFilename(String string, String string2) {
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string + string2;
        }
        String string3 = string.substring(0, n2);
        String string4 = string.substring(n2);
        return string3 + string2 + string4;
    }

    private static Image readImageIcon(Class clazz, String string, InputStream inputStream) throws IOException {
        int n2;
        byte[][] byArrayArray = new byte[1][];
        Object object = new BufferedInputStream(inputStream);
        Object object2 = new ByteArrayOutputStream(1024);
        byArrayArray[0] = new byte[1024];
        while ((n2 = ((FilterInputStream)object).read(byArrayArray[0])) > 0) {
            ((ByteArrayOutputStream)object2).write(byArrayArray[0], 0, n2);
        }
        ((BufferedInputStream)object).close();
        ((OutputStream)object2).flush();
        byArrayArray[0] = ((ByteArrayOutputStream)object2).toByteArray();
        if (byArrayArray[0] == null || byArrayArray[0].length == 0) {
            object = clazz.getPackage();
            object2 = "";
            if (object != null) {
                object2 = ((Package)object).getName().replace('.', '/');
            }
            if (byArrayArray[0] == null) {
                throw new IOException("Warning: Resource " + (String)object2 + "/" + string + " not found.");
            }
            if (byArrayArray[0].length == 0) {
                throw new IOException("Warning: Resource " + (String)object2 + "/" + string + " is zero-length");
            }
        }
        return Toolkit.getDefaultToolkit().createImage(byArrayArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateHTML(Class<?> clazz) {
        String string = clazz.getName();
        String string2 = IconsFactory.getClassName(string);
        File file = new File(string + ".html");
        try {
            try (FileWriter fileWriter = new FileWriter(file);){
                fileWriter.write("<html>\n<body>\n<p><b><font size=\"5\" face=\"Verdana\">Icons in " + string + "</font></b></p>");
                fileWriter.write("<p><b><font size=\"3\" face=\"Verdana\">Generated by JIDE Icons</font></b></p>");
                fileWriter.write("<p><b><font size=\"3\" color=\"#AAAAAA\" face=\"Verdana\">1. If you cannot view the images in this page, make sure the file is at the same directory as " + string2 + ".java</font></b></p>");
                fileWriter.write("<p><b><font size=\"3\" color=\"#AAAAAA\" face=\"Verdana\">2. To get a particular icon in your code, call " + string2 + ".getImageIcon(FULL_CONSTANT_NAME). Replace FULL_CONSTANT_NAME with the actual full constant name as in the table below</font></b></p>");
                IconsFactory.generate(clazz, fileWriter, string2);
                fileWriter.write("\n</body>\n</html>");
            }
            System.out.println("File is generated at \"" + file.getAbsolutePath() + "\". Please copy it to the same directory as " + string2 + ".java");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private static String getClassName(String string) {
        int n2 = string.lastIndexOf(".");
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "$");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append(".");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    private static void generate(Class<?> clazz, FileWriter fileWriter, String string) throws IOException {
        Class<?>[] classArray = clazz.getDeclaredClasses();
        for (int i2 = classArray.length - 1; i2 >= 0; --i2) {
            Field[] fieldArray = classArray[i2];
            IconsFactory.generate(fieldArray, fileWriter, IconsFactory.getClassName(fieldArray.getName()));
        }
        Field[] fieldArray = clazz.getFields();
        fileWriter.write("<p><font face=\"Verdana\"><b>" + string + "</b></font></p>");
        fileWriter.write("<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" bordercolor=\"#CCCCCC\" width=\"66%\">");
        fileWriter.write("<tr>\n");
        fileWriter.write("<td width=\"24%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Name</font></b></td>\n");
        fileWriter.write("<td width=\"13%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Image</font></b></td>\n");
        fileWriter.write("<td width=\"32%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">File Name</font></b></td>\n");
        fileWriter.write("<td width=\"31%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Full Constant Name</font></b></td>\n");
        fileWriter.write("</tr>\n");
        for (Field field : fieldArray) {
            try {
                String string2 = field.getName();
                Object object = field.get(clazz);
                fileWriter.write("<tr>\n");
                fileWriter.write("<td align=\"left\"><font face=\"Verdana\">" + string2 + "</font></td>\n");
                fileWriter.write("<td align=\"center\"><font face=\"Verdana\"><img border=\"0\" src=\"" + object + "\"></font></td>\n");
                fileWriter.write("<td align=\"left\"><font face=\"Verdana\">" + object + "</font></td>\n");
                fileWriter.write("<td align=\"left\"><font face=\"Verdana\">" + string + "." + string2 + "</font></td>\n");
                fileWriter.write("</tr>\n");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        fileWriter.write("</table><br><p>\n");
    }

    public static ImageIcon getIcon(Component component, ImageIcon imageIcon, int n2, int n3, int n4, int n5) {
        return IconsFactory.getIcon(component, imageIcon, n2, n3, n4, n5, n4, n5);
    }

    public static ImageIcon getIcon(Component component, ImageIcon imageIcon, int n2, int n3, int n4, int n5, int n6, int n7) {
        return IconsFactory.getIcon(component, imageIcon, n2, n3, n4, n5, 2, n6, n7);
    }

    public static ImageIcon getIcon(Component component, ImageIcon imageIcon, int n2, int n3, int n4, int n5, int n6) {
        return IconsFactory.getIcon(component, imageIcon, n2, n3, n4, n5, n6, n4, n5);
    }

    public static ImageIcon getIcon(Component component, ImageIcon imageIcon, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (imageIcon == null || n2 < 0 || n2 + n4 > imageIcon.getIconWidth() || n3 < 0 || n3 + n5 > imageIcon.getIconHeight()) {
            return EMPTY_ICON;
        }
        BufferedImage bufferedImage = new BufferedImage(n7, n8, n6);
        bufferedImage.getGraphics().drawImage(imageIcon.getImage(), 0, 0, n7, n8, n2, n3, n2 + n4, n3 + n5, component);
        return new ImageIcon(bufferedImage);
    }

    public static Icon getOverlayIcon(Component component, Icon icon, Icon icon2, int n2) {
        return IconsFactory.getOverlayIcon(component, icon, icon2, n2, new Insets(0, 0, 0, 0));
    }

    public static Icon getOverlayIcon(Component component, Icon icon, Icon icon2, int n2, Insets insets) {
        int n3 = -1;
        int n4 = -1;
        int n5 = icon.getIconWidth();
        int n6 = icon.getIconHeight();
        int n7 = icon2.getIconWidth();
        int n8 = icon2.getIconHeight();
        switch (n2) {
            case 0: {
                n3 = (n5 - n7) / 2;
                n4 = (n6 - n8) / 2;
                break;
            }
            case 1: {
                n3 = (n5 - n7) / 2;
                n4 = insets.top;
                break;
            }
            case 5: {
                n3 = (n5 - n7) / 2;
                n4 = n6 - insets.bottom - n8;
                break;
            }
            case 7: {
                n3 = insets.left;
                n4 = (n6 - n8) / 2;
                break;
            }
            case 3: {
                n3 = n5 - insets.right - n7;
                n4 = (n6 - n8) / 2;
                break;
            }
            case 2: {
                n3 = n5 - insets.right - n7;
                n4 = insets.top;
                break;
            }
            case 8: {
                n3 = insets.left;
                n4 = insets.top;
                break;
            }
            case 6: {
                n3 = insets.left;
                n4 = n6 - insets.bottom - n8;
                break;
            }
            case 4: {
                n3 = n5 - insets.right - n7;
                n4 = n6 - insets.bottom - n8;
            }
        }
        return IconsFactory.getOverlayIcon(component, icon, icon2, n3, n4);
    }

    public static Icon getOverlayIcon(Component component, Icon icon, Icon icon2, int n2, int n3) {
        int n4;
        int n5 = icon == null ? icon2.getIconWidth() : icon.getIconWidth();
        int n6 = n4 = icon == null ? icon2.getIconHeight() : icon.getIconHeight();
        if (n2 != -1 && n3 != -1) {
            BufferedImage bufferedImage = new BufferedImage(n5, n4, 2);
            if (icon != null) {
                icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
            }
            icon2.paintIcon(component, bufferedImage.getGraphics(), n2, n3);
            return new ImageIcon(bufferedImage);
        }
        return icon;
    }

    public static Icon getCombinedIcon(Component component, Icon icon, Icon icon2, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (icon == null) {
            return icon2;
        }
        if (icon2 == null) {
            return icon;
        }
        int n10 = icon.getIconWidth();
        int n11 = icon.getIconHeight();
        int n12 = icon2.getIconWidth();
        int n13 = icon2.getIconHeight();
        if (n2 == 0) {
            n9 = n10 + n12 + n3;
            n8 = Math.max(n11, n13);
            n7 = 0;
            n6 = n10 + n3;
            n5 = n11 > n13 ? 0 : (n13 - n11) / 2;
            n4 = n11 < n13 ? 0 : (n11 - n13) / 2;
        } else {
            n9 = Math.max(n10, n12);
            n8 = n11 + n13 + n3;
            n7 = n10 > n12 ? 0 : (n12 - n10) / 2;
            n6 = n10 < n12 ? 0 : (n10 - n12) / 2;
            n5 = 0;
            n4 = n11 + n3;
        }
        BufferedImage bufferedImage = new BufferedImage(n9, n8, 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), n7, n5);
        icon2.paintIcon(component, bufferedImage.getGraphics(), n6, n4);
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon getScaledImage(Component component, ImageIcon imageIcon, int n2, int n3) {
        if (n2 >= imageIcon.getIconWidth() / 2) {
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(imageIcon.getImage(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), component);
            graphics2D.dispose();
            return new ImageIcon(bufferedImage);
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), component);
        graphics2D.dispose();
        return new ImageIcon(JideSwingUtilities.getFasterScaledInstance(bufferedImage, n2, n3, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true));
    }

    public static void writeGifToFile(Component component, File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IconsFactory.writeToStream(component, "gif", fileOutputStream);
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().severe(iOException.getMessage());
        }
    }

    public static void writeJpegToFile(Component component, File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IconsFactory.writeToStream(component, "jpg", fileOutputStream);
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().severe(iOException.getMessage());
        }
    }

    public static void writePngToFile(Component component, File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IconsFactory.writeToStream(component, "png", fileOutputStream);
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().severe(iOException.getMessage());
        }
    }

    public static void writeToStream(Component component, OutputStream outputStream) {
        IconsFactory.writeToStream(component, "png", outputStream);
    }

    private static void writeToStream(Component component, String string, OutputStream outputStream) {
        BufferedImage bufferedImage = IconsFactory.createImage(component);
        try {
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().severe(iOException.getMessage());
        }
    }

    public static BufferedImage createImage(Component component) {
        return IconsFactory.createImage(component, 1);
    }

    public static BufferedImage createImage(Component component, Rectangle rectangle, int n2) {
        return IconsFactory.createImage(component, rectangle, n2, 1);
    }

    public static BufferedImage createImage(Component component, int n2) {
        Dimension dimension = component.getSize();
        return IconsFactory.createImage(component, new Rectangle(0, 0, dimension.width, dimension.height), n2, 1);
    }

    public static BufferedImage createImage(Component component, Rectangle rectangle, int n2, int n3) {
        BufferedImage bufferedImage = new BufferedImage(rectangle.width * n3, rectangle.height * n3, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            boolean bl2 = jComponent.isDoubleBuffered();
            jComponent.setDoubleBuffered(false);
            graphics2D.translate(-rectangle.x, -rectangle.y);
            graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            jComponent.paint(graphics2D);
            jComponent.setDoubleBuffered(bl2);
        } else {
            component.paint(graphics2D);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image createThumbnailImage(Component component, int n2, int n3) {
        BufferedImage bufferedImage = IconsFactory.createImage(component);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        double d2 = (double)n2 / (double)bufferedImage.getWidth();
        double d3 = (double)n3 / (double)bufferedImage.getHeight();
        assert (d2 <= 1.0) : "The thumbnail should be smaller than the original";
        assert (d3 <= 1.0) : "The thumbnail should be smaller than the original";
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d2, d3);
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        return bufferedImage2;
    }

    public static ImageIcon createThumbnail(Component component, int n2, int n3) {
        return new ImageIcon(IconsFactory.createThumbnailImage(component, n2, n3));
    }

    public static TexturePaint createTexture(JComponent jComponent, String string) {
        Image image = IconsFactory.createImage(string);
        MediaTracker mediaTracker = new MediaTracker(jComponent);
        mediaTracker.addImage(image, 1);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = image.getWidth(jComponent);
        int n3 = image.getHeight(jComponent);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, jComponent);
        return new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    public static Image createImage(String string) {
        ClassLoader classLoader = IconsFactory.class.getClassLoader();
        if (classLoader != null) {
            URL uRL = classLoader.getResource(string);
            if (uRL == null) {
                uRL = classLoader.getResource("/" + string);
            }
            return Toolkit.getDefaultToolkit().createImage(uRL);
        }
        return null;
    }
}

