/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.io.OutputStream;
import java.util.Arrays;
import kotlin.IgnorableReturnValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.internal.ByteArrayPool;
import kotlinx.serialization.json.internal.CharArrayPool;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.JsonEncodingException;
import kotlinx.serialization.json.internal.StringOpsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0000\u0018\u00002\u00020\u0001B\u0011\bF\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0080\u0004J\u0012\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0080\u0004J\u0012\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0080\u0004J\u0012\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0080\u0004J\u001a\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0015H\u0082\u0080\u0004J\u001a\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0083\u0080\bJ\n\u0010\u001d\u001a\u00020\rH\u0096\u0080\u0004J\n\u0010\u001e\u001a\u00020\rH\u0082\u0080\u0004J\u0012\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u000bH\u0082\u0088\u0004J\u0012\u0010\u0013\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000bH\u0082\u0088\u0004J\n\u0010\"\u001a\u00020\u000bH\u0082\u0088\u0004J\u001a\u0010#\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u000bH\u0082\u0080\u0004J\u0012\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u000bH\u0082\u0080\u0004R\u000f\u0010\u0002\u001a\u00020\u0003X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0006\u001a\u00020\u0007X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\b\u001a\u00020\tX\u0082\u008e\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\n\u001a\u00020\u000bX\u0082\u008e\b\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lkotlinx/serialization/json/internal/JsonToJavaStreamWriter;", "Lkotlinx/serialization/json/internal/InternalJsonWriter;", "stream", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "buffer", "", "charArray", "", "indexInBuffer", "", "writeLong", "", "value", "", "writeChar", "char", "", "write", "text", "", "writeQuoted", "appendStringSlowPath", "currentSize", "string", "ensureTotalCapacity", "oldSize", "additional", "release", "flush", "ensure", "bytesCount", "byte", "rest", "writeUtf8", "count", "writeUtf8CodePoint", "codePoint", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nJvmJsonStreams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmJsonStreams.kt\nkotlinx/serialization/json/internal/JsonToJavaStreamWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n131#1:270\n118#1:272\n131#1:273\n119#1,3:274\n126#1,2:277\n131#1:279\n126#1,2:280\n118#1:282\n131#1:283\n119#1,3:284\n126#1,2:287\n126#1,2:289\n118#1:291\n131#1:292\n119#1,3:293\n126#1,2:296\n126#1,2:298\n126#1,2:300\n118#1:302\n131#1:303\n119#1,3:304\n126#1,2:307\n118#1:309\n131#1:310\n119#1,3:311\n126#1,2:314\n126#1,2:316\n126#1,2:318\n126#1,2:320\n118#1:322\n131#1:323\n119#1,3:324\n126#1,2:327\n118#1:329\n131#1:330\n119#1,3:331\n126#1,2:334\n126#1,2:336\n118#1:338\n131#1:339\n119#1,3:340\n126#1,2:343\n118#1:345\n131#1:346\n119#1,3:347\n126#1,2:350\n126#1,2:352\n126#1,2:354\n118#1:356\n131#1:357\n119#1,3:358\n126#1,2:361\n126#1,2:363\n126#1,2:365\n126#1,2:367\n1#2:271\n*S KotlinDebug\n*F\n+ 1 JvmJsonStreams.kt\nkotlinx/serialization/json/internal/JsonToJavaStreamWriter\n*L\n118#1:270\n149#1:272\n149#1:273\n149#1:274,3\n150#1:277,2\n152#1:279\n159#1:280,2\n166#1:282\n166#1:283\n166#1:284,3\n167#1:287,2\n168#1:289,2\n174#1:291\n174#1:292\n174#1:293,3\n175#1:296,2\n176#1:298,2\n177#1:300,2\n187#1:302\n187#1:303\n187#1:304,3\n188#1:307,2\n197#1:309\n197#1:310\n197#1:311,3\n198#1:314,2\n199#1:316,2\n200#1:318,2\n201#1:320,2\n216#1:322\n216#1:323\n216#1:324,3\n217#1:327,2\n222#1:329\n222#1:330\n222#1:331,3\n223#1:334,2\n224#1:336,2\n229#1:338\n229#1:339\n229#1:340,3\n230#1:343,2\n235#1:345\n235#1:346\n235#1:347,3\n236#1:350,2\n237#1:352,2\n238#1:354,2\n243#1:356\n243#1:357\n243#1:358,3\n244#1:361,2\n245#1:363,2\n246#1:365,2\n247#1:367,2\n*E\n"})
public final class JsonToJavaStreamWriter
implements InternalJsonWriter {
    @NotNull
    private final OutputStream stream;
    @NotNull
    private final byte[] buffer;
    @NotNull
    private char[] charArray;
    private int indexInBuffer;

    public JsonToJavaStreamWriter(@NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
        this.buffer = ByteArrayPool.INSTANCE.take();
        this.charArray = CharArrayPool.INSTANCE.take();
    }

    @Override
    public void writeLong(long value) {
        this.write(String.valueOf(value));
    }

    @Override
    public void writeChar(char c) {
        this.writeUtf8CodePoint(c);
    }

    @Override
    public void write(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int length = text.length();
        this.ensureTotalCapacity(0, length);
        String string = text;
        char[] cArray = this.charArray;
        int n = 0;
        int n2 = 0;
        string.getChars(n2, length, cArray, n);
        this.writeUtf8(this.charArray, length);
    }

    @Override
    public void writeQuoted(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.ensureTotalCapacity(0, text.length() + 2);
        char[] arr = this.charArray;
        arr[0] = 34;
        int length = text.length();
        String string = text;
        int n = 1;
        int n2 = 0;
        string.getChars(n2, length, arr, n);
        n = 1 + length;
        for (int i = 1; i < n; ++i) {
            char ch = arr[i];
            if (ch >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[ch] == 0) continue;
            this.appendStringSlowPath(i, text);
            return;
        }
        arr[length + 1] = 34;
        this.writeUtf8(arr, length + 2);
        this.flush();
    }

    private final void appendStringSlowPath(int currentSize, String string) {
        int sz = currentSize;
        int n = string.length();
        for (int i = currentSize - 1; i < n; ++i) {
            sz = this.ensureTotalCapacity(sz, 2);
            char ch = string.charAt(i);
            if (ch < StringOpsKt.getESCAPE_MARKERS().length) {
                byte marker = StringOpsKt.getESCAPE_MARKERS()[ch];
                if (marker == 0) {
                    this.charArray[sz++] = ch;
                    continue;
                }
                if (marker == 1) {
                    String escapedString;
                    Intrinsics.checkNotNull((Object)StringOpsKt.getESCAPE_STRINGS()[ch]);
                    sz = this.ensureTotalCapacity(sz, escapedString.length());
                    String string2 = escapedString;
                    char[] cArray = this.charArray;
                    int n2 = 0;
                    int n3 = escapedString.length();
                    string2.getChars(n2, n3, cArray, sz);
                    sz += escapedString.length();
                    continue;
                }
                this.charArray[sz] = 92;
                this.charArray[sz + 1] = (char)marker;
                sz += 2;
                continue;
            }
            this.charArray[sz++] = ch;
        }
        this.ensureTotalCapacity(sz, 1);
        this.charArray[sz++] = 34;
        this.writeUtf8(this.charArray, sz);
        this.flush();
    }

    @IgnorableReturnValue
    private final int ensureTotalCapacity(int oldSize, int additional) {
        int newSize = oldSize + additional;
        if (this.charArray.length <= newSize) {
            char[] cArray = Arrays.copyOf(this.charArray, RangesKt.coerceAtLeast((int)newSize, (int)(oldSize * 2)));
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"copyOf(...)");
            this.charArray = cArray;
        }
        return oldSize;
    }

    @Override
    public void release() {
        this.flush();
        CharArrayPool.INSTANCE.release(this.charArray);
        ByteArrayPool.INSTANCE.release(this.buffer);
    }

    private final void flush() {
        this.stream.write(this.buffer, 0, this.indexInBuffer);
        this.indexInBuffer = 0;
    }

    private final void ensure(int bytesCount) {
        boolean $i$f$ensure = false;
        JsonToJavaStreamWriter this_$iv = this;
        boolean $i$f$rest = false;
        if (this_$iv.buffer.length - this_$iv.indexInBuffer < bytesCount) {
            this.flush();
        }
    }

    private final void write(int n) {
        boolean $i$f$write = false;
        int n2 = this.indexInBuffer;
        this.indexInBuffer = n2 + 1;
        this.buffer[n2] = (byte)n;
    }

    private final int rest() {
        boolean $i$f$rest = false;
        return this.buffer.length - this.indexInBuffer;
    }

    private final void writeUtf8(char[] string, int count) {
        if (!(count >= 0)) {
            boolean $i$a$-require-JsonToJavaStreamWriter$writeUtf8$32 = false;
            String $i$a$-require-JsonToJavaStreamWriter$writeUtf8$32 = "count < 0";
            throw new IllegalArgumentException($i$a$-require-JsonToJavaStreamWriter$writeUtf8$32.toString());
        }
        if (!(count <= string.length)) {
            boolean $i$a$-require-JsonToJavaStreamWriter$writeUtf8$42 = false;
            String $i$a$-require-JsonToJavaStreamWriter$writeUtf8$42 = "count > string.length: " + count + " > " + string.length;
            throw new IllegalArgumentException($i$a$-require-JsonToJavaStreamWriter$writeUtf8$42.toString());
        }
        int i = 0;
        while (i < count) {
            JsonToJavaStreamWriter this_$iv;
            char low;
            char c;
            block17: {
                JsonToJavaStreamWriter this_$iv2;
                boolean $i$f$write;
                block16: {
                    int this_$iv$iv22;
                    int $i$f$rest;
                    c = string[i];
                    if (c < '\u0080') {
                        JsonToJavaStreamWriter this_$iv3;
                        JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
                        int bytesCount$iv = 1;
                        boolean $i$f$ensure = false;
                        void this_$iv$iv22 = this_$iv3;
                        $i$f$rest = 0;
                        if (this_$iv$iv22.buffer.length - this_$iv$iv22.indexInBuffer < bytesCount$iv) {
                            super.flush();
                        }
                        this_$iv3 = this;
                        char byte$iv = c;
                        boolean $i$f$write2 = false;
                        this_$iv$iv22 = this_$iv3.indexInBuffer;
                        this_$iv3.indexInBuffer = this_$iv$iv22 + 1;
                        this_$iv3.buffer[this_$iv$iv22] = (byte)byte$iv;
                        JsonToJavaStreamWriter this_$iv2222 = this;
                        boolean $i$f$rest2 = false;
                        int this_$iv2222 = ++i + (this_$iv2222.buffer.length - this_$iv2222.indexInBuffer);
                        int runLimit = Math.min(count, this_$iv2222);
                        while (i < runLimit && (c = string[i]) < '\u0080') {
                            JsonToJavaStreamWriter this_$iv2222 = this;
                            char byte$iv2 = c;
                            $i$f$write = false;
                            $i$f$rest = this_$iv2222.indexInBuffer;
                            this_$iv2222.indexInBuffer = $i$f$rest + 1;
                            this_$iv2222.buffer[$i$f$rest] = (byte)byte$iv2;
                            ++i;
                        }
                        continue;
                    }
                    if (c < '\u0800') {
                        JsonToJavaStreamWriter this_$iv4;
                        JsonToJavaStreamWriter runLimit = this;
                        int bytesCount$iv = 2;
                        boolean $i$f$ensure = false;
                        void this_$iv$iv = this_$iv4;
                        $i$f$rest = 0;
                        if (this_$iv$iv.buffer.length - this_$iv$iv.indexInBuffer < bytesCount$iv) {
                            super.flush();
                        }
                        this_$iv4 = this;
                        int byte$iv = c >> 6 | 0xC0;
                        boolean $i$f$write3 = false;
                        this_$iv$iv22 = this_$iv4.indexInBuffer;
                        this_$iv4.indexInBuffer = this_$iv$iv22 + 1;
                        this_$iv4.buffer[this_$iv$iv22] = (byte)byte$iv;
                        this_$iv4 = this;
                        byte$iv = c & 0x3F | 0x80;
                        $i$f$write3 = false;
                        this_$iv$iv22 = this_$iv4.indexInBuffer;
                        this_$iv4.indexInBuffer = this_$iv$iv22 + 1;
                        this_$iv4.buffer[this_$iv$iv22] = (byte)byte$iv;
                        ++i;
                        continue;
                    }
                    if (c < '\ud800' || c > '\udfff') {
                        JsonToJavaStreamWriter this_$iv5 = this;
                        int bytesCount$iv = 3;
                        boolean $i$f$ensure = false;
                        JsonToJavaStreamWriter this_$iv$iv = this_$iv5;
                        $i$f$rest = 0;
                        if (this_$iv$iv.buffer.length - this_$iv$iv.indexInBuffer < bytesCount$iv) {
                            this_$iv5.flush();
                        }
                        this_$iv5 = this;
                        int byte$iv = c >> 12 | 0xE0;
                        boolean $i$f$write4 = false;
                        this_$iv$iv22 = this_$iv5.indexInBuffer;
                        this_$iv5.indexInBuffer = this_$iv$iv22 + 1;
                        this_$iv5.buffer[this_$iv$iv22] = (byte)byte$iv;
                        this_$iv5 = this;
                        byte$iv = c >> 6 & 0x3F | 0x80;
                        $i$f$write4 = false;
                        this_$iv$iv22 = this_$iv5.indexInBuffer;
                        this_$iv5.indexInBuffer = this_$iv$iv22 + 1;
                        this_$iv5.buffer[this_$iv$iv22] = (byte)byte$iv;
                        this_$iv5 = this;
                        byte$iv = c & 0x3F | 0x80;
                        $i$f$write4 = false;
                        this_$iv$iv22 = this_$iv5.indexInBuffer;
                        this_$iv5.indexInBuffer = this_$iv$iv22 + 1;
                        this_$iv5.buffer[this_$iv$iv22] = (byte)byte$iv;
                        ++i;
                        continue;
                    }
                    char c2 = low = i + 1 < count ? string[i + 1] : (char)'\u0000';
                    if (c > '\udbff') break block16;
                    if ('\udc00' <= low ? low < '\ue000' : false) break block17;
                }
                JsonToJavaStreamWriter byte$iv = this;
                int bytesCount$iv = 1;
                boolean $i$f$ensure = false;
                void this_$iv$iv32 = this_$iv2;
                boolean $i$f$rest = false;
                if (this_$iv$iv32.buffer.length - this_$iv$iv32.indexInBuffer < bytesCount$iv) {
                    super.flush();
                }
                this_$iv2 = this;
                int byte$iv3 = 63;
                $i$f$write = false;
                int this_$iv$iv32 = this_$iv2.indexInBuffer;
                this_$iv2.indexInBuffer = this_$iv$iv32 + 1;
                this_$iv2.buffer[this_$iv$iv32] = (byte)byte$iv3;
                ++i;
                continue;
            }
            int codePoint = 65536 + ((c & 0x3FF) << 10 | low & 0x3FF);
            JsonToJavaStreamWriter byte$iv3 = this;
            int bytesCount$iv = 4;
            boolean $i$f$ensure = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$rest = false;
            if (this_$iv$iv.buffer.length - this_$iv$iv.indexInBuffer < bytesCount$iv) {
                super.flush();
            }
            this_$iv = this;
            int byte$iv = codePoint >> 18 | 0xF0;
            boolean $i$f$write = false;
            int n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv;
            this_$iv = this;
            byte$iv = codePoint >> 12 & 0x3F | 0x80;
            $i$f$write = false;
            n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv;
            this_$iv = this;
            byte$iv = codePoint >> 6 & 0x3F | 0x80;
            $i$f$write = false;
            n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv;
            this_$iv = this;
            byte$iv = codePoint & 0x3F | 0x80;
            $i$f$write = false;
            n = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = n + 1;
            this_$iv.buffer[n] = (byte)byte$iv;
            i += 2;
        }
    }

    private final void writeUtf8CodePoint(int codePoint) {
        if (codePoint < 128) {
            JsonToJavaStreamWriter this_$iv;
            JsonToJavaStreamWriter jsonToJavaStreamWriter = this;
            int bytesCount$iv = 1;
            boolean $i$f$ensure = false;
            void this_$iv$iv22 = this_$iv;
            boolean $i$f$rest = false;
            if (this_$iv$iv22.buffer.length - this_$iv$iv22.indexInBuffer < bytesCount$iv) {
                super.flush();
            }
            this_$iv = this;
            int byte$iv = codePoint;
            boolean $i$f$write = false;
            int this_$iv$iv22 = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = this_$iv$iv22 + 1;
            this_$iv.buffer[this_$iv$iv22] = (byte)byte$iv;
        } else if (codePoint < 2048) {
            JsonToJavaStreamWriter this_$iv = this;
            int bytesCount$iv = 2;
            boolean $i$f$ensure = false;
            JsonToJavaStreamWriter this_$iv$iv32 = this_$iv;
            boolean $i$f$rest = false;
            if (this_$iv$iv32.buffer.length - this_$iv$iv32.indexInBuffer < bytesCount$iv) {
                this_$iv.flush();
            }
            this_$iv = this;
            int byte$iv = codePoint >> 6 | 0xC0;
            boolean $i$f$write = false;
            int this_$iv$iv32 = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = this_$iv$iv32 + 1;
            this_$iv.buffer[this_$iv$iv32] = (byte)byte$iv;
            this_$iv = this;
            byte$iv = codePoint & 0x3F | 0x80;
            $i$f$write = false;
            this_$iv$iv32 = this_$iv.indexInBuffer;
            this_$iv.indexInBuffer = this_$iv$iv32 + 1;
            this_$iv.buffer[this_$iv$iv32] = (byte)byte$iv;
        } else {
            boolean bl = 55296 <= codePoint ? codePoint < 57344 : false;
            if (bl) {
                JsonToJavaStreamWriter this_$iv = this;
                int bytesCount$iv = 1;
                boolean $i$f$ensure = false;
                JsonToJavaStreamWriter this_$iv$iv42 = this_$iv;
                boolean $i$f$rest = false;
                if (this_$iv$iv42.buffer.length - this_$iv$iv42.indexInBuffer < bytesCount$iv) {
                    this_$iv.flush();
                }
                this_$iv = this;
                int byte$iv = 63;
                boolean $i$f$write = false;
                int this_$iv$iv42 = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = this_$iv$iv42 + 1;
                this_$iv.buffer[this_$iv$iv42] = (byte)byte$iv;
            } else if (codePoint < 65536) {
                JsonToJavaStreamWriter this_$iv = this;
                int bytesCount$iv = 3;
                boolean $i$f$ensure = false;
                JsonToJavaStreamWriter this_$iv$iv52 = this_$iv;
                boolean $i$f$rest = false;
                if (this_$iv$iv52.buffer.length - this_$iv$iv52.indexInBuffer < bytesCount$iv) {
                    this_$iv.flush();
                }
                this_$iv = this;
                int byte$iv = codePoint >> 12 | 0xE0;
                boolean $i$f$write = false;
                int this_$iv$iv52 = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = this_$iv$iv52 + 1;
                this_$iv.buffer[this_$iv$iv52] = (byte)byte$iv;
                this_$iv = this;
                byte$iv = codePoint >> 6 & 0x3F | 0x80;
                $i$f$write = false;
                this_$iv$iv52 = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = this_$iv$iv52 + 1;
                this_$iv.buffer[this_$iv$iv52] = (byte)byte$iv;
                this_$iv = this;
                byte$iv = codePoint & 0x3F | 0x80;
                $i$f$write = false;
                this_$iv$iv52 = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = this_$iv$iv52 + 1;
                this_$iv.buffer[this_$iv$iv52] = (byte)byte$iv;
            } else if (codePoint <= 0x10FFFF) {
                JsonToJavaStreamWriter this_$iv = this;
                int bytesCount$iv = 4;
                boolean $i$f$ensure = false;
                JsonToJavaStreamWriter this_$iv$iv = this_$iv;
                boolean $i$f$rest = false;
                if (this_$iv$iv.buffer.length - this_$iv$iv.indexInBuffer < bytesCount$iv) {
                    this_$iv.flush();
                }
                this_$iv = this;
                int byte$iv = codePoint >> 18 | 0xF0;
                boolean $i$f$write = false;
                int n = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = n + 1;
                this_$iv.buffer[n] = (byte)byte$iv;
                this_$iv = this;
                byte$iv = codePoint >> 12 & 0x3F | 0x80;
                $i$f$write = false;
                n = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = n + 1;
                this_$iv.buffer[n] = (byte)byte$iv;
                this_$iv = this;
                byte$iv = codePoint >> 6 & 0x3F | 0x80;
                $i$f$write = false;
                n = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = n + 1;
                this_$iv.buffer[n] = (byte)byte$iv;
                this_$iv = this;
                byte$iv = codePoint & 0x3F | 0x80;
                $i$f$write = false;
                n = this_$iv.indexInBuffer;
                this_$iv.indexInBuffer = n + 1;
                this_$iv.buffer[n] = (byte)byte$iv;
            } else {
                throw new JsonEncodingException("Unexpected code point: " + codePoint);
            }
        }
    }
}

