/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.api.agent;

import com.jprofiler.agent.util.HttpUtilImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HttpUtil {
    public static String getPathSegments(String requestURI, int fromSegment, int toSegment, boolean replaceNumericIds) {
        if (requestURI == null || requestURI.length() == 0) {
            return requestURI;
        }
        StringBuilder builder = new StringBuilder();
        HttpUtilImpl.addSegments((StringBuilder)builder, (String)requestURI, (int)fromSegment, (int)toSegment, (boolean)replaceNumericIds, (String)HttpUtilImpl.ID_PLACEHOLDER, (boolean)false);
        return builder.toString();
    }

    public static String getParameter(String parameterName, String queryString) {
        List<String> values = HttpUtil.getParameters(queryString).get(parameterName);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public static Map<String, List<String>> getParameters(String queryString) {
        String[] pairs;
        LinkedHashMap<String, List<String>> keyValuePairs = new LinkedHashMap<String, List<String>>();
        for (String pair : pairs = queryString.split("&")) {
            int index = pair.indexOf("=");
            try {
                String key = index > 0 ? URLDecoder.decode(pair.substring(0, index), "UTF-8") : pair;
                List<String> values = HttpUtil.getValues(key, keyValuePairs);
                String value = index > 0 && pair.length() > index + 1 ? URLDecoder.decode(pair.substring(index + 1), "UTF-8") : "";
                values.add(value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return keyValuePairs;
    }

    @NotNull
    private static List<String> getValues(String key, Map<String, List<String>> keyValuePairs) {
        List<String> values = keyValuePairs.get(key);
        if (values == null) {
            values = new ArrayList<String>();
            keyValuePairs.put(key, values);
        }
        return values;
    }
}

