/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers.actions;

import com.jprofiler.agent.triggers.TriggerManager;
import com.jprofiler.agent.triggers.actions.ImmediateAction;
import com.jprofiler.agent.triggers.actions.TriggerAction;
import com.jprofiler.agent.triggers.nanoxml.XMLElement;
import java.util.ArrayList;
import java.util.List;

public class SleepAction
extends TriggerAction
implements ImmediateAction {
    public static final int DEFAULT_TIME = 1;
    public static final String DEFAULT_TIME_UNIT = "m";
    private long sleepTime;
    private List<TriggerAction> subsequentActions = new ArrayList<TriggerAction>();

    public SleepAction(XMLElement xMLElement) {
        int n2 = xMLElement.getIntAttribute("time", 1);
        String string = xMLElement.getStringAttribute("timeUnit", DEFAULT_TIME_UNIT);
        this.sleepTime = TriggerManager.getTimeMillis(n2, string);
    }

    public void addSubsequentAction(TriggerAction triggerAction) {
        this.subsequentActions.add(triggerAction);
    }

    @Override
    public void execute(final boolean bl2) {
        new Thread("_jprofiler_trigger_sleep"){
            {
                super(string);
                this.setDaemon(true);
            }

            @Override
            public void run() {
                SleepAction.this.sleepNow();
                for (TriggerAction triggerAction : SleepAction.this.subsequentActions) {
                    triggerAction.execute(bl2);
                }
            }
        }.start();
    }

    private void sleepNow() {
        try {
            Thread.sleep(this.sleepTime);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public void executeImmediate() {
        this.sleepNow();
        if (!this.subsequentActions.isEmpty()) {
            System.err.println("JProfiler> ERROR: Sleep trigger action contains subsequent actions, but was executed immediately.");
        }
    }
}

