/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.file.internal.fs;

import io.matthewnelson.kmp.file.OpenExcl;
import io.matthewnelson.kmp.file.internal.fs.ParcelFileDescriptor;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.ClosedChannelException;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/matthewnelson/kmp/file/internal/fs/ParcelFileDescriptor;", "", "()V", "MODE_CREATE", "", "MODE_WRITE_ONLY", "close", "Ljava/lang/reflect/Method;", "getFileDescriptor", "open", "Companion", "Opener", "io.matthewnelson.kmp-file_file_jvm"})
final class ParcelFileDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int MODE_WRITE_ONLY;
    private final int MODE_CREATE;
    @NotNull
    private final Method close;
    @NotNull
    private final Method getFileDescriptor;
    @NotNull
    private final Method open;
    @NotNull
    private static final Lazy<ParcelFileDescriptor> INSTANCE$delegate = LazyKt.lazy((Function0)Companion.INSTANCE.2.INSTANCE);

    private ParcelFileDescriptor() {
        Class<?> clazz = Class.forName("android.os.ParcelFileDescriptor");
        this.MODE_WRITE_ONLY = clazz.getField("MODE_WRITE_ONLY").getInt(null);
        this.MODE_CREATE = clazz.getField("MODE_CREATE").getInt(null);
        Method method = clazz.getMethod("close", new Class[0]);
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getMethod(...)");
        this.close = method;
        Method method2 = clazz.getMethod("getFileDescriptor", new Class[0]);
        Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"getMethod(...)");
        this.getFileDescriptor = method2;
        Class[] classArray = new Class[]{File.class, Integer.TYPE};
        Method method3 = clazz.getMethod("open", classArray);
        Intrinsics.checkNotNullExpressionValue((Object)method3, (String)"getMethod(...)");
        this.open = method3;
    }

    public /* synthetic */ ParcelFileDescriptor(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lio/matthewnelson/kmp/file/internal/fs/ParcelFileDescriptor$Companion;", "", "()V", "INSTANCE", "Lio/matthewnelson/kmp/file/internal/fs/ParcelFileDescriptor;", "getINSTANCE", "()Lio/matthewnelson/kmp/file/internal/fs/ParcelFileDescriptor;", "INSTANCE$delegate", "Lkotlin/Lazy;", "io.matthewnelson.kmp-file_file_jvm"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ParcelFileDescriptor getINSTANCE() {
            Lazy lazy = INSTANCE$delegate;
            return (ParcelFileDescriptor)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\fR\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/matthewnelson/kmp/file/internal/fs/ParcelFileDescriptor$Opener;", "Ljava/io/Closeable;", "Lio/matthewnelson/kmp/file/Closeable;", "file", "Ljava/io/File;", "Lio/matthewnelson/kmp/file/File;", "excl", "Lio/matthewnelson/kmp/file/OpenExcl;", "(Lio/matthewnelson/kmp/file/internal/fs/ParcelFileDescriptor;Ljava/io/File;Lio/matthewnelson/kmp/file/OpenExcl;)V", "_pfd", "Lkotlin/Pair;", "", "Ljava/io/FileDescriptor;", "close", "", "getFD", "io.matthewnelson.kmp-file_file_jvm"})
    @SourceDebugExtension(value={"SMAP\n-FsJvmAndroidLegacy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 -FsJvmAndroidLegacy.kt\nio/matthewnelson/kmp/file/internal/fs/ParcelFileDescriptor$Opener\n+ 2 Exceptions.kt\nio/matthewnelson/kmp/file/Exceptions\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,460:1\n143#2,3:461\n146#2,2:465\n1#3:464\n*S KotlinDebug\n*F\n+ 1 -FsJvmAndroidLegacy.kt\nio/matthewnelson/kmp/file/internal/fs/ParcelFileDescriptor$Opener\n*L\n433#1:461,3\n433#1:465,2\n433#1:464\n*E\n"})
    public final class Opener
    implements Closeable {
        @Nullable
        private volatile Pair<? extends Object, FileDescriptor> _pfd;

        public Opener(@NotNull File file, OpenExcl excl) throws Throwable {
            FileDescriptor fileDescriptor;
            int n;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)excl, (String)"excl");
            int n2 = ParcelFileDescriptor.this.MODE_WRITE_ONLY;
            OpenExcl openExcl = excl;
            if (openExcl instanceof OpenExcl.MaybeCreate ? true : openExcl instanceof OpenExcl.MustCreate) {
                n = ParcelFileDescriptor.this.MODE_CREATE;
            } else if (openExcl instanceof OpenExcl.MustExist) {
                n = 0;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            int flags = n2 | n;
            Object[] objectArray = new Object[]{file, flags};
            Object obj = ParcelFileDescriptor.this.open.invoke(null, objectArray);
            try {
                Object object = ParcelFileDescriptor.this.getFileDescriptor.invoke(obj, new Object[0]);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.io.FileDescriptor");
                fileDescriptor = (FileDescriptor)object;
            }
            catch (Throwable t) {
                try {
                    ParcelFileDescriptor.this.close.invoke(obj, new Object[0]);
                }
                catch (Throwable tt) {
                    Throwable throwable;
                    if (tt instanceof InvocationTargetException) {
                        throwable = tt.getCause();
                        if (throwable == null) {
                            throwable = tt;
                        }
                    } else {
                        throwable = tt;
                    }
                    Throwable c = throwable;
                    ExceptionsKt.addSuppressed((Throwable)t, (Throwable)c);
                }
                throw t;
            }
            FileDescriptor fd = fileDescriptor;
            this._pfd = TuplesKt.to((Object)obj, (Object)fd);
        }

        @NotNull
        public final FileDescriptor getFD() throws ClosedChannelException {
            Object object = this._pfd;
            if (object == null || (object = (FileDescriptor)object.getSecond()) == null) {
                throw new ClosedChannelException();
            }
            return object;
        }

        @Override
        public void close() {
            Pair<? extends Object, FileDescriptor> pair = this._pfd;
            if (pair == null) {
                return;
            }
            Pair<? extends Object, FileDescriptor> pair2 = pair;
            Object obj = pair2.component1();
            FileDescriptor fd = (FileDescriptor)pair2.component2();
            this._pfd = null;
            IOException threw = null;
            try {
                ParcelFileDescriptor.this.close.invoke(obj, new Object[0]);
            }
            catch (Throwable t) {
                IOException iOException;
                Throwable c;
                Throwable throwable;
                if (t instanceof InvocationTargetException) {
                    throwable = t.getCause();
                    if (throwable == null) {
                        throwable = t;
                    }
                } else {
                    throwable = t;
                }
                Throwable $this$wrapIOException$iv = c = throwable;
                boolean $i$f$wrapIO = false;
                Throwable throwable2 = $this$wrapIOException$iv;
                if (throwable2 instanceof IOException) {
                    iOException = (IOException)$this$wrapIOException$iv;
                } else if (throwable2 instanceof InterruptedException) {
                    InterruptedIOException interruptedIOException;
                    InterruptedIOException it$iv = interruptedIOException = new InterruptedIOException();
                    boolean bl = false;
                    ExceptionsKt.addSuppressed((Throwable)it$iv, (Throwable)$this$wrapIOException$iv);
                    iOException = interruptedIOException;
                } else {
                    iOException = new IOException($this$wrapIOException$iv);
                }
                threw = iOException;
            }
            if (fd.valid()) {
                IOException e = new IOException("FileDescriptor.valid() == true");
                if (threw != null) {
                    ExceptionsKt.addSuppressed((Throwable)threw, (Throwable)e);
                } else {
                    threw = e;
                }
            }
            IOException iOException = threw;
            if (iOException != null) {
                throw iOException;
            }
        }
    }
}

