/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.immutable.collections;

import io.matthewnelson.immutable.collections.ImmutableCollection;
import io.matthewnelson.immutable.collections.ImmutableListIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010*\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0016\u00a8\u0006\u0013"}, d2={"Lio/matthewnelson/immutable/collections/ImmutableList;", "T", "Lio/matthewnelson/immutable/collections/ImmutableCollection;", "", "delegate", "(Ljava/util/List;)V", "get", "index", "", "(I)Ljava/lang/Object;", "indexOf", "element", "(Ljava/lang/Object;)I", "lastIndexOf", "listIterator", "", "subList", "fromIndex", "toIndex", "io.matthewnelson.immutable_collections_jvm"})
final class ImmutableList<T>
extends ImmutableCollection<T, List<? extends T>>
implements List<T>,
KMappedMarker {
    public ImmutableList(@NotNull List<? extends T> delegate) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        super((Collection)delegate);
    }

    @Override
    public T get(int index) {
        return (T)((List)this.getDelegate()).get(index);
    }

    @Override
    public int indexOf(Object element) {
        return ((List)this.getDelegate()).indexOf(element);
    }

    @Override
    public int lastIndexOf(Object element) {
        return ((List)this.getDelegate()).lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return new ImmutableListIterator(((List)this.getDelegate()).listIterator());
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        return new ImmutableListIterator(((List)this.getDelegate()).listIterator(index));
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex == 0 && toIndex == this.size()) {
            return this;
        }
        List subList = ((List)this.getDelegate()).subList(fromIndex, toIndex);
        if (subList.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return new ImmutableList(subList);
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<T> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super T> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

