/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers.actions;

import com.jprofiler.agent.AgentEnvironment;
import com.jprofiler.agent.triggers.actions.TriggerAction;
import com.jprofiler.agent.triggers.actions.TriggerUtil;
import com.jprofiler.agent.triggers.nanoxml.XMLElement;
import com.jprofiler.agent.util.ag;
import com.jprofiler.agent.util.l;
import com.jprofiler.agent.util.logging.a;
import com.jprofiler.agent.util.logging.b;
import com.jprofiler.agent.util.m;
import com.jprofiler.agent.util.o;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class HprofHeapdumpAction
extends TriggerAction {
    public static final String DEFAULT_FILE_NAME = "";
    public static final boolean DEFAULT_FULL_GC = true;
    public static final boolean DEFAULT_NUMBER = false;
    private String fileName;
    private boolean fullGc;
    private boolean number;

    public HprofHeapdumpAction(XMLElement xMLElement) {
        this.fileName = xMLElement.getStringAttribute("file", DEFAULT_FILE_NAME);
        this.fullGc = xMLElement.getBooleanAttribute("fullGc", true);
        this.number = xMLElement.getBooleanAttribute("number", false);
    }

    @Override
    public void execute(boolean bl2) {
        HprofHeapdumpAction.triggerHprofDump(a.a, this.fileName, this.fullGc, this.number, false);
    }

    public static String triggerHprofDump(b b2, String string, boolean bl2, boolean bl3, boolean bl4) {
        if (!o.a()) {
            HprofHeapdumpAction.printVmTypeWarning();
        } else {
            try {
                String string2 = TriggerUtil.getSnapshotFilename(string, HprofHeapdumpAction.getTempSuffix(bl4), bl3);
                String string3 = bl4 ? File.createTempFile("jhd", ".hpz", AgentEnvironment.getTempDir()).getAbsolutePath() : string2;
                HprofHeapdumpAction.dump(b2, string2, bl2);
                if (bl4) {
                    m m2 = new m(new GZIPOutputStream(new FileOutputStream(string3)));
                    l l2 = new l(new FileInputStream(string2));
                    TriggerUtil.pumpStream(l2, m2);
                    ((InputStream)l2).close();
                    ((OutputStream)m2).close();
                    new File(string2).delete();
                }
                return string3;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (throwable.getCause() != null) {
                    throwable2 = throwable.getCause();
                }
                System.err.println("JProfiler> Error saving heap snapshot:");
                throwable2.printStackTrace();
            }
        }
        return null;
    }

    private static void printVmTypeWarning() {
        if (ag.c()) {
            System.err.println("JProfiler> *****************************************************");
            System.err.println("JProfiler> WARNING: Could not save HPROF or PHD snapshot. ");
            System.err.println("JProfiler> *****************************************************");
        } else {
            System.err.println("JProfiler> ************************************************");
            System.err.println("JProfiler> WARNING: Could not save HPROF snapshot. ");
            System.err.println("JProfiler> ************************************************");
        }
    }

    public static void dump(String string, boolean bl2) throws Exception {
        HprofHeapdumpAction.dump(a.a, string, bl2);
    }

    public static void dump(b b2, String string, boolean bl2) throws Exception {
        new File(string).delete();
        b2.a("Saving heap snapshot '" + string + "' ... ");
        o.a(string, bl2);
        b2.a("Done.");
    }

    public static String getTempSuffix(boolean bl2) {
        if (bl2) {
            return ".dat";
        }
        if (ag.c()) {
            return ".phd";
        }
        return ".hprof";
    }
}

